/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={NEIServerUtils.class})
public class MixinNEIServerUtils {
    @Overwrite
    public static void advanceDisabledTimes(World world) {
        int dim = CommonUtils.getDimension((World)world);
        int hour = (int)(MixinNEIServerUtils.getTime(world) % 24000L) / 1000;
        int timeZonesLength = NEIActions.timeZones.length;
        int newhour = hour;
        while (NEIServerConfig.isActionDisabled((int)dim, (String)NEIActions.timeZones[newhour / 6])) {
            newhour = (newhour / 6 + 1) % (timeZonesLength / 6) * 6;
        }
        if (newhour != hour) {
            MixinNEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    @Overwrite
    public static long getTime(World world) {
        return world.func_72912_H().func_76073_f();
    }

    @Overwrite
    public static void setHourForward(World world, int hour, boolean notify) {
        long day = MixinNEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)hour * 1000L;
        MixinNEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll((IChatComponent)new ChatComponentTranslation("nei.chat.time", new Object[]{MixinNEIServerUtils.getTime(world) / 24000L, hour}));
        }
    }

    @Overwrite
    public static void setTime(long l, World world) {
        world.func_72912_H().func_76068_b(l);
    }
}

