/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.packagedauto;

import codechicken.nei.event.NEIConfigsLoadedEvent;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import thelm.packagedauto.integration.nei.NEIHandler;

@Mixin(value={NEIHandler.class})
public class MixinNeiHandlerPackagedAuto {
    @Shadow
    private static Function<TemplateRecipeHandler.RecipeTransferRect, String> getCategory;
    @Shadow
    private static final ListMultimap<String, ICraftingHandler> HANDLERS;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Overwrite(remap=false)
    public void onNEIConfigsLoaded(NEIConfigsLoadedEvent event) {
        HANDLERS.clear();
    }

    @Shadow
    public Set<String> getRecipeCategories(IRecipeHandler recipeHandler) {
        String cat;
        TreeSet<String> categories = new TreeSet<String>();
        if (recipeHandler instanceof TemplateRecipeHandler) {
            ((TemplateRecipeHandler)recipeHandler).transferRects.stream().map(getCategory).filter(Objects::nonNull).distinct().forEach(categories::add);
        }
        if ((cat = recipeHandler.getOverlayIdentifier()) != null) {
            categories.add(cat);
        }
        return categories;
    }

    static {
        HANDLERS = MultimapBuilder.treeKeys().arrayListValues().build();
    }
}

