/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.slimecarnage;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.chunk.IChunkProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import supremopete.SlimeCarnage.worldgen.WorldGenDesertRuins;
import supremopete.SlimeCarnage.worldgen.WorldGenDesertTomb;
import supremopete.SlimeCarnage.worldgen.WorldGenMadLab;
import supremopete.SlimeCarnage.worldgen.WorldGenSewers;
import supremopete.SlimeCarnage.worldgen.WorldGenSlimeCarnage;
import supremopete.SlimeCarnage.worldgen.WorldGenStoneRuins;

@Mixin(value={WorldGenSlimeCarnage.class})
public class MixinFixCascadingFromWorldGenSlimeCarnage
implements IWorldGenerator {
    @Overwrite(remap=false)
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX, chunkZ);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX, chunkZ);
                break;
            }
        }
    }

    @Overwrite(remap=false)
    private void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        if (this.optimizationsAndTweaks$generateCave(world, random, chunkX, chunkZ)) {
            return;
        }
        int biomeCheck = this.optimizationsAndTweaks$getBiomeCheck(world, random, chunkX, chunkZ);
        if (biomeCheck == 1) {
            this.optimizationsAndTweaks$generateDesertRuins(world, random, chunkX, chunkZ);
        } else if (biomeCheck == 2) {
            this.optimizationsAndTweaks$generateStoneRuins(world, random, chunkX, chunkZ);
        }
        if (this.optimizationsAndTweaks$generateMadLab(random)) {
            this.optimizationsAndTweaks$generateMadLab(world, random, chunkX, chunkZ);
        }
        if (biomeCheck == 1 && this.optimizationsAndTweaks$generateDesertTomb(random)) {
            this.optimizationsAndTweaks$generateDesertTomb(world, random, chunkX, chunkZ);
        }
    }

    @Unique
    private boolean optimizationsAndTweaks$generateCave(World world, Random rand, int chunkX, int chunkZ) {
        int Xcoord2 = chunkX + rand.nextInt(16);
        int Ycoord2 = 64 + rand.nextInt(6);
        int Zcoord2 = chunkZ + rand.nextInt(16);
        return new WorldGenSewers().func_76484_a(world, rand, Xcoord2, Ycoord2, Zcoord2);
    }

    @Unique
    private int optimizationsAndTweaks$getBiomeCheck(World world, Random rand, int chunkX, int chunkZ) {
        BiomeGenBase biomegenbase = world.func_72807_a(chunkX * 16, chunkZ * 16);
        if (biomegenbase instanceof BiomeGenDesert) {
            return rand.nextInt(10);
        }
        if (biomegenbase instanceof BiomeGenPlains) {
            return rand.nextInt(4);
        }
        return 0;
    }

    @Unique
    private void optimizationsAndTweaks$generateDesertRuins(World world, Random rand, int chunkX, int chunkZ) {
        int Xcoord4 = chunkX + rand.nextInt(16);
        int scrub4 = 66 + rand.nextInt(12);
        int Xcoord5 = chunkZ + rand.nextInt(16);
        new WorldGenDesertRuins().func_76484_a(world, rand, Xcoord4, scrub4, Xcoord5);
    }

    @Unique
    private void optimizationsAndTweaks$generateStoneRuins(World world, Random rand, int chunkX, int chunkZ) {
        int Xcoord4 = chunkX + rand.nextInt(16);
        int Xcoord5 = chunkZ + rand.nextInt(16);
        new WorldGenStoneRuins().func_76484_a(world, rand, Xcoord4, 66 + rand.nextInt(12), Xcoord5);
    }

    @Unique
    private boolean optimizationsAndTweaks$generateMadLab(Random rand) {
        return rand.nextInt(16) == 0;
    }

    @Unique
    private void optimizationsAndTweaks$generateMadLab(World world, Random rand, int chunkX, int chunkZ) {
        int Xcoord4 = chunkX + rand.nextInt(16);
        int scrub5 = 66 + rand.nextInt(6);
        int Xcoord5 = chunkZ + rand.nextInt(16);
        new WorldGenMadLab().func_76484_a(world, rand, Xcoord4, scrub5, Xcoord5);
    }

    @Unique
    private boolean optimizationsAndTweaks$generateDesertTomb(Random rand) {
        return rand.nextInt(10) == 0;
    }

    @Unique
    private void optimizationsAndTweaks$generateDesertTomb(World world, Random rand, int chunkX, int chunkZ) {
        int Xcoord5 = chunkX + rand.nextInt(16);
        int Ycoord5 = 64 + rand.nextInt(8);
        int Zcoord5 = chunkZ + rand.nextInt(16);
        new WorldGenDesertTomb().func_76484_a(world, rand, Xcoord5, Ycoord5, Zcoord5);
    }

    @Shadow
    private void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }

    @Shadow
    private void generateEnd(World world, Random random, int chunkX, int chunkZ) {
    }
}

