/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EntityAgeable.class})
public abstract class MixinEntityAgeable
extends EntityCreature {
    @Unique
    public float CHILD_SCALE = 0.5f;
    @Unique
    public int GROWING_AGE_DATA_WATCHER_ID = 12;
    @Unique
    public float ADULT_SCALE = 1.0f;
    @Shadow
    private float field_98056_d = -1.0f;
    @Shadow
    private float field_98057_e;

    public MixinEntityAgeable(World worldIn) {
        super(worldIn);
    }

    @Unique
    public int optimizationsAndTweaks$getGrowingAge() {
        return this.field_70180_af.func_75679_c(this.GROWING_AGE_DATA_WATCHER_ID);
    }

    @Unique
    public void optimizationsAndTweaks$setGrowingAge(int age) {
        this.field_70180_af.func_75692_b(this.GROWING_AGE_DATA_WATCHER_ID, (Object)age);
        this.optimizationsAndTweaks$setScaleForAge(this.func_70631_g_());
    }

    @Unique
    public void optimizationsAndTweaks$setScaleForAge(boolean isChild) {
        this.optimizationsAndTweaks$setScale(isChild ? this.CHILD_SCALE : this.ADULT_SCALE);
    }

    @Unique
    protected final void optimizationsAndTweaks$setScale(float scale) {
        super.func_70105_a(this.field_98056_d * scale, this.field_98057_e * scale);
    }

    @Overwrite
    public void func_110195_a(int p_110195_1_) {
        if (OptimizationsandTweaksConfig.enableMixinEntityAgeable) {
            int currentAge = this.optimizationsAndTweaks$getGrowingAge();
            if ((currentAge += p_110195_1_ * 20) > 0) {
                currentAge = 0;
            }
            this.optimizationsAndTweaks$setGrowingAge(currentAge);
        }
    }

    @Overwrite
    public void func_70636_d() {
        if (OptimizationsandTweaksConfig.enableMixinEntityAgeable) {
            super.func_70636_d();
            if (this.field_70170_p.field_72995_K) {
                this.optimizationsAndTweaks$setScaleForAge(this.func_70631_g_());
            } else {
                int currentAge = this.optimizationsAndTweaks$getGrowingAge();
                if (currentAge < 0) {
                    this.optimizationsAndTweaks$setGrowingAge(++currentAge);
                } else if (currentAge > 0) {
                    this.optimizationsAndTweaks$setGrowingAge(--currentAge);
                }
            }
        }
    }

    public boolean func_70631_g_() {
        return this.optimizationsAndTweaks$getGrowingAge() < 0;
    }
}

