/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.etfuturumrequiem;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.api.DeepslateOreRegistry;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={DeepslateOreRegistry.class})
public class MixinDeepslateOreRegistry {
    @Shadow
    private static final Map<RegistryMapping<Block>, RegistryMapping<Block>> deepslateOres = new HashMap<RegistryMapping<Block>, RegistryMapping<Block>>();

    @Overwrite
    public static void init() {
        if (ConfigBlocksItems.enableDeepslateOres) {
            for (Map.Entry<RegistryMapping<Block>, RegistryMapping<Block>> entry : MixinDeepslateOreRegistry.getOreMap().entrySet()) {
                MixinDeepslateOreRegistry.optimizationsAndTweaks$processEntry(entry);
            }
        }
    }

    @Unique
    private static void optimizationsAndTweaks$processEntry(Map.Entry<RegistryMapping<Block>, RegistryMapping<Block>> entry) {
        Block oreNorm = MixinDeepslateOreRegistry.optimizationsAndTweaks$getOreNorm(entry);
        Block oreDeep = MixinDeepslateOreRegistry.optimizationsAndTweaks$getOreDeep(entry);
        if (oreNorm == null || oreDeep == null) {
            return;
        }
        MixinDeepslateOreRegistry.optimizationsAndTweaks$setBlockSoundIfNeeded(oreDeep);
        ItemStack stackNorm = MixinDeepslateOreRegistry.optimizationsAndTweaks$getItemStack(oreNorm, entry.getKey().getMeta());
        ItemStack stackDeep = MixinDeepslateOreRegistry.optimizationsAndTweaks$getItemStack(oreDeep, entry.getValue().getMeta());
        MixinDeepslateOreRegistry.optimizationsAndTweaks$addSmeltingRecipeIfNeeded(stackNorm, stackDeep);
    }

    @Unique
    private static Block optimizationsAndTweaks$getOreNorm(Map.Entry<RegistryMapping<Block>, RegistryMapping<Block>> entry) {
        Block oreNorm = (Block)entry.getKey().getObject();
        if (oreNorm == null) {
            System.err.println("[OptimizationsAndTweaks] oreNorm is null for entry: {}" + entry);
        }
        return oreNorm;
    }

    @Unique
    private static Block optimizationsAndTweaks$getOreDeep(Map.Entry<RegistryMapping<Block>, RegistryMapping<Block>> entry) {
        Block oreDeep = (Block)entry.getValue().getObject();
        if (oreDeep == null) {
            System.err.println("[OptimizationsAndTweaks] oreDeep is null for entry: {}" + entry);
        }
        return oreDeep;
    }

    @Unique
    private static void optimizationsAndTweaks$setBlockSoundIfNeeded(Block oreDeep) {
        boolean saltyModOre = oreDeep.getClass().getName().toLowerCase().contains("saltymod");
        if (oreDeep.field_149762_H == Block.field_149769_e || saltyModOre) {
            Utils.setBlockSound((Block)oreDeep, (Block.SoundType)ModSounds.soundDeepslate);
        }
    }

    @Unique
    private static ItemStack optimizationsAndTweaks$getItemStack(Block block, int meta) {
        if (block == null) {
            System.err.println("[OptimizationsAndTweaks] Cannot create ItemStack, block is null");
            return null;
        }
        return new ItemStack(block, 1, meta);
    }

    @Unique
    private static boolean optimizationsAndTweaks$addSmeltingRecipeIfNeeded(ItemStack stackNorm, ItemStack stackDeep) {
        if (stackNorm == null) {
            System.err.println("[OptimizationsAndTweaks] Cannot add smelting recipe: stackNorm is null.");
            return false;
        }
        if (stackDeep == null) {
            System.err.println("[OptimizationsAndTweaks] Cannot add smelting recipe: stackDeep is null.");
            return false;
        }
        try {
            ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(stackNorm);
            if (smeltingResult == null) {
                System.err.println("[OptimizationsAndTweaks] No smelting result found for stackNorm: " + stackNorm);
                return false;
            }
            GameRegistry.addSmelting((ItemStack)stackDeep, (ItemStack)smeltingResult, (float)FurnaceRecipes.func_77602_a().func_151398_b(stackNorm));
        }
        catch (Exception e) {
            System.err.println("[OptimizationsAndTweaks] Exception occurred while adding smelting recipe: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Shadow
    public static Map<RegistryMapping<Block>, RegistryMapping<Block>> getOreMap() {
        return deepslateOres;
    }
}

