/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.thaumcraft;

import cpw.mods.fml.common.IWorldGenerator;
import fr.iamacat.optimizationsandtweaks.utilsformods.thaumcraft.Thaumcraft;
import fr.iamacat.optimizationsandtweaks.utilsformods.thaumcraft.ThaumcraftWorldGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraftforge.common.BiomeDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.WorldGenCustomFlowers;
import thaumcraft.common.lib.world.WorldGenEldritchRing;
import thaumcraft.common.lib.world.WorldGenGreatwoodTrees;
import thaumcraft.common.lib.world.WorldGenHilltopStones;
import thaumcraft.common.lib.world.WorldGenMound;
import thaumcraft.common.lib.world.WorldGenSilverwoodTrees;
import thaumcraft.common.lib.world.biomes.BiomeHandler;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.lib.world.dim.MazeThread;
import thaumcraft.common.tiles.TileNode;

@Mixin(value={thaumcraft.common.lib.world.ThaumcraftWorldGenerator.class})
public abstract class MixinFixCascadingWorldGenFromThaumcraftWorldGenerator
implements IWorldGenerator {
    @Shadow
    public static BiomeGenBase biomeTaint;
    @Shadow
    public static BiomeGenBase biomeMagicalForest;
    @Shadow
    static Collection<Aspect> c;
    @Shadow
    static ArrayList<Aspect> basicAspects;
    @Shadow
    static ArrayList<Aspect> complexAspects;
    @Shadow
    public static HashMap<Integer, Integer> dimensionBlacklist;
    @Shadow
    public static HashMap<Integer, Integer> biomeBlacklist;
    @Unique
    HashMap<Integer, Boolean> optimizationsAndTweaks$structureNode = new HashMap();

    @Overwrite(remap=false)
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.worldGeneration(random, chunkX, chunkZ, world, true);
    }

    @Overwrite(remap=false)
    public void worldGeneration(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (world.field_73011_w.field_76574_g == Config.dimensionOuterId) {
            MazeHandler.generateEldritch((World)world, (Random)random, (int)chunkX, (int)chunkZ);
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        } else {
            switch (world.field_73011_w.field_76574_g) {
                case -1: {
                    this.generateNether(world, random, chunkX, chunkZ, newGen);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.generateSurface(world, random, chunkX, chunkZ, newGen);
                }
            }
            if (!newGen) {
                world.func_72964_e(chunkX, chunkZ).func_76630_e();
            }
        }
    }

    @Overwrite(remap=false)
    private void generateNether(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        boolean auraGen = false;
        if (!world.func_72912_H().func_76067_t().func_77127_a().startsWith("flat") && (newGen || Config.regenStructure)) {
            this.optimizationsAndTweaks$generateGreatwoodgenerateTotem(world, random, chunkX, chunkZ, auraGen, newGen);
        }
        if (newGen || Config.regenAura) {
            this.optimizationsAndTweaks$generateWildNodes(world, random, chunkX, chunkZ, auraGen);
        }
    }

    @Overwrite(remap=false)
    private void generateSurface(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        boolean auraGen = false;
        int blacklist = MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$getDimBlacklist(world.field_73011_w.field_76574_g);
        if (blacklist == -1 && Config.genTrees && !world.func_72912_H().func_76067_t().func_77127_a().startsWith("flat") && (newGen || Config.regenTrees)) {
            this.optimizationsAndTweaks$generateVegetation(world, random, chunkX, chunkZ);
        }
        if (blacklist != 0 && blacklist != 2) {
            this.optimizationsAndTweaks$generateOres(world, random, chunkX, chunkZ, newGen);
        }
        if (blacklist != 0 && blacklist != 2 && Config.genAura && (newGen || Config.regenAura)) {
            ChunkPosition var7 = new MapGenScatteredFeature().func_151545_a(world, chunkX * 16 + 8, world.func_72976_f(chunkX * 16 + 8, chunkZ * 16 + 8), chunkZ * 16 + 8);
            if (var7 != null && !this.optimizationsAndTweaks$structureNode.containsKey(var7.hashCode())) {
                auraGen = true;
                this.optimizationsAndTweaks$structureNode.put(var7.hashCode(), true);
                MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createRandomNodeAt(world, var7.field_151329_a, world.func_72976_f(var7.field_151329_a, var7.field_151328_c) + 3, var7.field_151328_c, random, false, false, false);
            }
            auraGen = this.optimizationsAndTweaks$generateWildNodes(world, random, chunkX, chunkZ, auraGen);
        }
        if (blacklist == -1 && Config.genStructure && world.field_73011_w.field_76574_g == 0 && !world.func_72912_H().func_76067_t().func_77127_a().startsWith("flat") && (newGen || Config.regenStructure)) {
            int randPosZ;
            int randPosX = chunkX * 16 + random.nextInt(16);
            int randPosY = world.func_72976_f(randPosX, randPosZ = chunkZ * 16 + random.nextInt(16)) - 9;
            if (randPosY < world.func_72940_L()) {
                WorldGenHilltopStones hilltopStones;
                world.func_72938_d(MathHelper.func_76128_c((double)randPosX), MathHelper.func_76128_c((double)randPosZ));
                WorldGenMound mound = new WorldGenMound();
                if (random.nextInt(150) == 0) {
                    if (mound.func_76484_a(world, random, randPosX, randPosY, randPosZ)) {
                        auraGen = true;
                        MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createRandomNodeAt(world, randPosX + 9, randPosY + 8, randPosZ + 9, random, false, true, false);
                    }
                } else if (random.nextInt(66) == 0) {
                    WorldGenEldritchRing stonering = new WorldGenEldritchRing();
                    randPosY += 8;
                    int w = 11 + random.nextInt(6) * 2;
                    int h = 11 + random.nextInt(6) * 2;
                    stonering.chunkX = chunkX;
                    stonering.chunkZ = chunkZ;
                    stonering.width = w;
                    stonering.height = h;
                    if (stonering.func_76484_a(world, random, randPosX, randPosY, randPosZ)) {
                        auraGen = true;
                        MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createRandomNodeAt(world, randPosX, randPosY + 2, randPosZ, random, false, true, false);
                        Thread t = new Thread((Runnable)new MazeThread(chunkX, chunkZ, w, h, random.nextLong()));
                        t.start();
                    }
                } else if (random.nextInt(40) == 0 && (hilltopStones = new WorldGenHilltopStones()).func_76484_a(world, random, randPosX, randPosY += 9, randPosZ)) {
                    auraGen = true;
                    MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createRandomNodeAt(world, randPosX, randPosY + 5, randPosZ, random, false, true, false);
                }
            }
            this.optimizationsAndTweaks$generateGreatwoodgenerateTotem(world, random, chunkX, chunkZ, auraGen, newGen);
        }
    }

    @Overwrite
    public static void createRandomNodeAt(World world, int x, int y, int z, Random random, boolean silverwood, boolean eerie, boolean small) {
        ArrayList<Aspect> complexAspects = new ArrayList<Aspect>();
        ArrayList<Aspect> basicAspects = new ArrayList<Aspect>();
        MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$sortAspects(c, complexAspects, basicAspects);
        NodeType type = MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$determineNodeType(random, silverwood, eerie);
        NodeModifier modifier = MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$determineNodeModifier(random);
        BiomeGenBase bg = world.func_72807_a(x, z);
        Thaumcraft.BiomeAuraResult result = MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$calculateBiomeAura(bg, type, silverwood, small, random);
        int baura = result.getBaura();
        type = result.getType();
        AspectList al = MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$generateAspectList(random, complexAspects, basicAspects, bg, type);
        int value = random.nextInt(baura / 2) + baura / 2;
        MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$applyThresholds(world, x, y, z, random, value, type, modifier);
        MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createNodeAt(world, x, y, z, type, modifier, al);
    }

    @Unique
    private static void optimizationsAndTweaks$sortAspects(Collection<Aspect> aspects, List<Aspect> complexAspects, List<Aspect> basicAspects) {
        for (Aspect as : aspects) {
            if (as.getComponents() != null) {
                complexAspects.add(as);
                continue;
            }
            basicAspects.add(as);
        }
    }

    @Unique
    private static NodeType optimizationsAndTweaks$determineNodeType(Random random, boolean silverwood, boolean eerie) {
        NodeType type = NodeType.NORMAL;
        if (silverwood) {
            type = NodeType.PURE;
        } else if (eerie) {
            type = NodeType.DARK;
        } else if (random.nextInt(Config.specialNodeRarity) == 0) {
            int randomType = random.nextInt(10);
            switch (randomType) {
                case 0: 
                case 1: 
                case 2: {
                    type = NodeType.DARK;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    type = NodeType.UNSTABLE;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    type = NodeType.PURE;
                    break;
                }
                case 9: {
                    type = NodeType.HUNGRY;
                }
            }
        }
        return type;
    }

    @Unique
    private static NodeModifier optimizationsAndTweaks$determineNodeModifier(Random random) {
        NodeModifier modifier = null;
        if (random.nextInt(Config.specialNodeRarity / 2) == 0) {
            int randomModifier = random.nextInt(3);
            switch (randomModifier) {
                case 0: {
                    modifier = NodeModifier.BRIGHT;
                    break;
                }
                case 1: {
                    modifier = NodeModifier.PALE;
                    break;
                }
                case 2: {
                    modifier = NodeModifier.FADING;
                }
            }
        }
        return modifier;
    }

    @Unique
    private static Thaumcraft.BiomeAuraResult optimizationsAndTweaks$calculateBiomeAura(BiomeGenBase bg, NodeType type, boolean silverwood, boolean small, Random random) {
        int baura = BiomeHandler.getBiomeAura((BiomeGenBase)bg);
        if (type != NodeType.PURE && bg.field_76756_M == MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.biomeTaint.field_76756_M) {
            baura = (int)((float)baura * 1.5f);
            if (random.nextBoolean()) {
                type = NodeType.TAINTED;
                baura = (int)((float)baura * 1.5f);
            }
        }
        if (silverwood || small) {
            baura /= 4;
        }
        return new Thaumcraft.BiomeAuraResult(baura, type);
    }

    @Unique
    private static AspectList optimizationsAndTweaks$generateAspectList(Random random, List<Aspect> complexAspects, List<Aspect> basicAspects, BiomeGenBase bg, NodeType type) {
        AspectList al = new AspectList();
        Aspect ra = BiomeHandler.getRandomBiomeTag((int)bg.field_76756_M, (Random)random);
        if (ra != null) {
            al.add(ra, 2);
        } else {
            Aspect aa = complexAspects.get(random.nextInt(complexAspects.size()));
            al.add(aa, 1);
            aa = basicAspects.get(random.nextInt(basicAspects.size()));
            al.add(aa, 1);
        }
        for (int water = 0; water < 3; ++water) {
            Aspect aa;
            if (!random.nextBoolean()) continue;
            if (random.nextInt(Config.specialNodeRarity) == 0) {
                aa = complexAspects.get(random.nextInt(complexAspects.size()));
                al.merge(aa, 1);
                continue;
            }
            aa = basicAspects.get(random.nextInt(basicAspects.size()));
            al.merge(aa, 1);
        }
        if (type == NodeType.HUNGRY) {
            al.merge(Aspect.HUNGER, 2);
            if (random.nextBoolean()) {
                al.merge(Aspect.GREED, 1);
            }
        } else if (type == NodeType.PURE) {
            if (random.nextBoolean()) {
                al.merge(Aspect.LIFE, 2);
            } else {
                al.merge(Aspect.ORDER, 2);
            }
        } else if (type == NodeType.DARK) {
            if (random.nextBoolean()) {
                al.merge(Aspect.DEATH, 1);
            }
            if (random.nextBoolean()) {
                al.merge(Aspect.UNDEAD, 1);
            }
            if (random.nextBoolean()) {
                al.merge(Aspect.ENTROPY, 1);
            }
            if (random.nextBoolean()) {
                al.merge(Aspect.DARKNESS, 1);
            }
        }
        return al;
    }

    @Unique
    private static void optimizationsAndTweaks$applyThresholds(World world, int x, int y, int z, Random random, int value, NodeType type, NodeModifier modifier) {
        ThaumcraftWorldGenerator.applyThresholds(world, x, y, z, random, value, type, modifier);
    }

    @Overwrite
    public static void createNodeAt(World world, int x, int y, int z, NodeType nt, NodeModifier nm, AspectList al) {
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        if (!chunk.field_76636_d) {
            return;
        }
        if (MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$isAirBlock(world, x, y, z)) {
            MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$setBlockAiry(world, x, y, z);
            MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$updateTileEntity(world, x, y, z, nt, nm, al);
            MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$markBlockForUpdate(world, x, y, z);
        }
    }

    @Unique
    private static boolean optimizationsAndTweaks$isAirBlock(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z);
    }

    @Unique
    private static void optimizationsAndTweaks$setBlockAiry(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, ConfigBlocks.blockAiry, 0, 0);
    }

    @Unique
    private static void optimizationsAndTweaks$updateTileEntity(World world, int x, int y, int z, NodeType nt, NodeModifier nm, AspectList al) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileNode) {
            ((TileNode)te).setNodeType(nt);
            ((TileNode)te).setNodeModifier(nm);
            ((TileNode)te).setAspects(al);
        }
    }

    @Unique
    private static void optimizationsAndTweaks$markBlockForUpdate(World world, int x, int y, int z) {
        world.func_147471_g(x, y, z);
    }

    @Unique
    private boolean optimizationsAndTweaks$generateWildNodes(World world, Random random, int chunkX, int chunkZ, boolean auraGen) {
        if (Config.genAura && random.nextInt(Config.nodeRarity) == 0 && !auraGen) {
            int z;
            int x = chunkX * 16 + random.nextInt(16);
            int q = Utils.getFirstUncoveredY((World)world, (int)x, (int)(z = chunkZ * 16 + random.nextInt(16)));
            if (q < 2) {
                q = world.field_73011_w.func_76557_i() + random.nextInt(64) - 32 + Utils.getFirstUncoveredY((World)world, (int)x, (int)z);
            }
            if (q < 2) {
                q = 32 + random.nextInt(64);
            }
            if (world.func_147437_c(x, q + 1, z)) {
                ++q;
            }
            int p = random.nextInt(4);
            Block b = world.func_147439_a(x, q + p, z);
            if (world.func_147437_c(x, q + p, z) || b.isReplaceable((IBlockAccess)world, x, q + p, z)) {
                q += p;
            }
            if (q > world.func_72940_L()) {
                return false;
            }
            MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createRandomNodeAt(world, x, q, z, random, false, false, false);
            return true;
        }
        return false;
    }

    @Unique
    private boolean optimizationsAndTweaks$generateGreatwoodgenerateTotem(World world, Random random, int chunkX, int chunkZ, boolean auraGen, boolean newGen) {
        if (Config.genStructure && (world.field_73011_w.field_76574_g == 0 || world.field_73011_w.field_76574_g == 1) && newGen && !auraGen && random.nextInt(Config.nodeRarity * 10) == 0) {
            int topy;
            int x = chunkX * 16 + random.nextInt(16);
            int z = chunkZ * 16 + random.nextInt(16);
            int n = topy = world.field_73011_w.field_76574_g == -1 ? Utils.getFirstUncoveredY((World)world, (int)x, (int)z) - 1 : world.func_72976_f(x, z) - 1;
            if (topy > world.func_72940_L()) {
                return false;
            }
            if (world.func_147439_a(x, topy, z) != null && world.func_147439_a(x, topy, z).isLeaves((IBlockAccess)world, x, topy, z)) {
                while (world.func_147439_a(x, --topy, z) != Blocks.field_150349_c && topy > 40) {
                }
            }
            if (world.func_147439_a(x, topy, z) == Blocks.field_150431_aC || world.func_147439_a(x, topy, z) == Blocks.field_150329_H) {
                --topy;
            }
            if (world.func_147439_a(x, topy, z) == Blocks.field_150349_c || world.func_147439_a(x, topy, z) == Blocks.field_150354_m || world.func_147439_a(x, topy, z) == Blocks.field_150346_d || world.func_147439_a(x, topy, z) == Blocks.field_150348_b || world.func_147439_a(x, topy, z) == Blocks.field_150424_aL) {
                int count;
                for (count = 1; (world.func_147437_c(x, topy + count, z) || world.func_147439_a(x, topy + count, z) == Blocks.field_150431_aC || world.func_147439_a(x, topy + count, z) == Blocks.field_150329_H) && count < 3; ++count) {
                }
                if (count >= 2) {
                    world.func_147465_d(x, topy, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                    count = 1;
                    while ((world.func_147437_c(x, topy + count, z) || world.func_147439_a(x, topy + count, z) == Blocks.field_150431_aC || world.func_147439_a(x, topy + count, z) == Blocks.field_150329_H) && count < 5) {
                        world.func_147465_d(x, topy + count, z, ConfigBlocks.blockCosmeticSolid, 0, 3);
                        if (count > 1 && random.nextInt(4) == 0) {
                            world.func_147465_d(x, topy + count, z, ConfigBlocks.blockCosmeticSolid, 8, 3);
                            MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createRandomNodeAt(world, x, topy + count, z, random, false, true, false);
                            count = 5;
                            auraGen = true;
                        }
                        if (++count < 5 || auraGen) continue;
                        world.func_147465_d(x, topy + 5, z, ConfigBlocks.blockCosmeticSolid, 8, 3);
                        MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.createRandomNodeAt(world, x, topy + 5, z, random, false, true, false);
                    }
                }
            }
        }
        return false;
    }

    @Unique
    private static int optimizationsAndTweaks$getDimBlacklist(int dim) {
        return dimensionBlacklist.getOrDefault(dim, -1);
    }

    @Unique
    private void optimizationsAndTweaks$generateVegetation(World world, Random random, int chunkX, int chunkZ) {
        BiomeGenBase bgb = world.func_72807_a(chunkX * 16 + 8, chunkZ * 16 + 8);
        if (MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$getBiomeBlacklist(bgb.field_76756_M) == -1) {
            int randPosZ;
            int randPosX;
            int randPosY;
            if (random.nextInt(60) == 3) {
                MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$generateSilverwood(world, random, chunkX, chunkZ);
            }
            if (random.nextInt(25) == 7) {
                MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$generateGreatwood(world, random, chunkX, chunkZ);
            }
            if ((randPosY = world.func_72976_f(randPosX = chunkX * 16 + random.nextInt(16), randPosZ = chunkZ * 16 + random.nextInt(16))) <= world.func_72940_L() && world.func_72807_a((int)randPosX, (int)randPosZ).field_76752_A == Blocks.field_150354_m && world.func_72807_a((int)randPosX, (int)randPosZ).field_76750_F > 1.0f && random.nextInt(30) == 0) {
                MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$generateFlowers(world, random, randPosX, randPosY, randPosZ);
            }
        }
    }

    @Unique
    private static boolean optimizationsAndTweaks$generateGreatwood(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = world.func_72976_f(x, z);
        int bio = world.func_72807_a((int)x, (int)z).field_76756_M;
        if (BiomeHandler.getBiomeSupportsGreatwood((int)bio) > random.nextFloat()) {
            return new WorldGenGreatwoodTrees(false).generate(world, random, x, y, z, random.nextInt(8) == 0);
        }
        return false;
    }

    @Unique
    private static void optimizationsAndTweaks$generateFlowers(World world, Random random, int x, int y, int z) {
        WorldGenCustomFlowers flowers = new WorldGenCustomFlowers(ConfigBlocks.blockCustomPlant, 3);
        flowers.func_76484_a(world, random, x, y, z);
    }

    @Unique
    private void optimizationsAndTweaks$generateOres(World world, Random random, int chunkX, int chunkZ, boolean newGen) {
        BiomeGenBase bgb = world.func_72807_a(chunkX * 16 + 8, chunkZ * 16 + 8);
        if (MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$getBiomeBlacklist(bgb.field_76756_M) != 0 && MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$getBiomeBlacklist(bgb.field_76756_M) != 2) {
            Block block;
            int randPosY;
            int randPosZ;
            int randPosX;
            int i;
            if (Config.genCinnibar && (newGen || Config.regenCinnibar)) {
                for (i = 0; i < 18; ++i) {
                    randPosX = chunkX * 16 + random.nextInt(16);
                    block = world.func_147439_a(randPosX, randPosZ = random.nextInt(world.func_72800_K() / 5), randPosY = chunkZ * 16 + random.nextInt(16));
                    if (block == null || !block.isReplaceableOreGen(world, randPosX, randPosZ, randPosY, Blocks.field_150348_b)) continue;
                    world.func_147465_d(randPosX, randPosZ, randPosY, ConfigBlocks.blockCustomOre, 0, 0);
                }
            }
            if (Config.genAmber && (newGen || Config.regenAmber)) {
                for (i = 0; i < 20; ++i) {
                    randPosX = chunkX * 16 + random.nextInt(16);
                    block = world.func_147439_a(randPosX, randPosY = world.func_72976_f(randPosX, randPosZ = chunkZ * 16 + random.nextInt(16)) - random.nextInt(25), randPosZ);
                    if (block == null || !block.isReplaceableOreGen(world, randPosX, randPosY, randPosZ, Blocks.field_150348_b)) continue;
                    world.func_147465_d(randPosX, randPosY, randPosZ, ConfigBlocks.blockCustomOre, 7, 2);
                }
            }
            if (Config.genInfusedStone && (newGen || Config.regenInfusedStone)) {
                for (i = 0; i < 8; ++i) {
                    randPosX = chunkX * 16 + random.nextInt(16);
                    randPosZ = chunkZ * 16 + random.nextInt(16);
                    randPosY = random.nextInt(Math.max(5, world.func_72976_f(randPosX, randPosZ) - 5));
                    int md = random.nextInt(6) + 1;
                    if (random.nextInt(3) == 0) {
                        Aspect tag = BiomeHandler.getRandomBiomeTag((int)world.func_72807_a((int)randPosX, (int)randPosZ).field_76756_M, (Random)random);
                        if (tag == null) {
                            md = 1 + random.nextInt(6);
                        } else if (tag == Aspect.AIR) {
                            md = 1;
                        } else if (tag == Aspect.FIRE) {
                            md = 2;
                        } else if (tag == Aspect.WATER) {
                            md = 3;
                        } else if (tag == Aspect.EARTH) {
                            md = 4;
                        } else if (tag == Aspect.ORDER) {
                            md = 5;
                        } else if (tag == Aspect.ENTROPY) {
                            md = 6;
                        }
                    }
                    new WorldGenMinable(ConfigBlocks.blockCustomOre, md, 6, Blocks.field_150348_b).func_76484_a(world, random, randPosX, randPosY, randPosZ);
                }
            }
        }
    }

    @Unique
    private static int optimizationsAndTweaks$getBiomeBlacklist(int biome) {
        return biomeBlacklist.getOrDefault(biome, -1);
    }

    @Unique
    private static void optimizationsAndTweaks$generateSilverwood(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = world.func_72976_f(x, z);
        BiomeGenBase bio = world.func_72807_a(x, z);
        if (MixinFixCascadingWorldGenFromThaumcraftWorldGenerator.optimizationsAndTweaks$shouldGenerateSilverwoodTree(bio)) {
            new WorldGenSilverwoodTrees(false, 7, 4).func_76484_a(world, random, x, y, z);
        }
    }

    @Unique
    private static boolean optimizationsAndTweaks$shouldGenerateSilverwoodTree(BiomeGenBase bio) {
        return !bio.equals(biomeMagicalForest) && !bio.equals(biomeTaint) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) && bio.field_76756_M != BiomeGenBase.field_76785_t.field_76756_M && bio.field_76756_M != BiomeGenBase.field_150582_Q.field_76756_M;
    }
}

