/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.linear;

import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.analysis.function.Sqrt;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.linear.AbstractRealMatrix;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.linear.ArrayRealVector;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.linear.NonSquareOperatorException;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.linear.RealLinearOperator;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.linear.RealVector;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.util.MathArrays;

public class JacobiPreconditioner
extends RealLinearOperator {
    private final ArrayRealVector diag;

    public JacobiPreconditioner(double[] diag, boolean deep) {
        this.diag = new ArrayRealVector(diag, deep);
    }

    public static JacobiPreconditioner create(RealLinearOperator a) throws NonSquareOperatorException {
        int n = a.getColumnDimension();
        if (a.getRowDimension() != n) {
            throw new NonSquareOperatorException(a.getRowDimension(), n);
        }
        double[] diag = new double[n];
        if (a instanceof AbstractRealMatrix) {
            AbstractRealMatrix m = (AbstractRealMatrix)a;
            for (int i = 0; i < n; ++i) {
                diag[i] = m.getEntry(i, i);
            }
        } else {
            ArrayRealVector x = new ArrayRealVector(n);
            for (int i = 0; i < n; ++i) {
                x.set(0.0);
                x.setEntry(i, 1.0);
                diag[i] = a.operate(x).getEntry(i);
            }
        }
        return new JacobiPreconditioner(diag, false);
    }

    @Override
    public int getColumnDimension() {
        return this.diag.getDimension();
    }

    @Override
    public int getRowDimension() {
        return this.diag.getDimension();
    }

    @Override
    public RealVector operate(RealVector x) {
        return new ArrayRealVector(MathArrays.ebeDivide(x.toArray(), this.diag.toArray()), false);
    }

    public RealLinearOperator sqrt() {
        final ArrayRealVector sqrtDiag = this.diag.map(new Sqrt());
        return new RealLinearOperator(){

            @Override
            public RealVector operate(RealVector x) {
                return new ArrayRealVector(MathArrays.ebeDivide(x.toArray(), sqrtDiag.toArray()), false);
            }

            @Override
            public int getRowDimension() {
                return sqrtDiag.getDimension();
            }

            @Override
            public int getColumnDimension() {
                return sqrtDiag.getDimension();
            }
        };
    }
}

