/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.collections.maps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TreeSetThreadSafe<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private transient NavigableMap<E, Object> m;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    TreeSetThreadSafe(NavigableMap<E, Object> m) {
        this.m = m;
    }

    public TreeSetThreadSafe() {
        this(new TreeMap());
    }

    public TreeSetThreadSafe(Comparator<? super E> comparator) {
        this(new TreeMap(comparator));
    }

    public TreeSetThreadSafe(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public TreeSetThreadSafe(SortedSet<E> s) {
        this(s.comparator());
        this.addAll(s);
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.readLock().lock();
        try {
            Iterator iterator = new TreeSetThreadSafe(this.m.keySet()).iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<E> descendingIterator() {
        this.lock.readLock().lock();
        try {
            Iterator<E> iterator = this.m.descendingKeySet().iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new TreeSetThreadSafe<E>(this.m.descendingMap());
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.m.containsKey(o);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.m.put(e, PRESENT) == null;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.m.remove(o) == PRESENT;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.m.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.writeLock().lock();
        try {
            if (this.m.isEmpty() && !c.isEmpty() && c instanceof SortedSet) {
                TreeMap<E, Object> map = new TreeMap<E, Object>(this.m.comparator());
                for (E element : c) {
                    map.put(element, PRESENT);
                }
                this.m = map;
                boolean bl = true;
                return bl;
            }
            boolean bl = super.addAll(c);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new TreeSetThreadSafe<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new TreeSetThreadSafe<E>(this.m.headMap(toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new TreeSetThreadSafe<E>(this.m.tailMap(fromElement, inclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public E lower(E e) {
        return this.m.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.m.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.m.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.m.higherKey(e);
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> e = this.m.pollFirstEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> e = this.m.pollLastEntry();
        return e == null ? null : (E)e.getKey();
    }

    public Object clone() {
        TreeSetThreadSafe clone;
        try {
            clone = (TreeSetThreadSafe)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        clone.m = new TreeMap<E, Object>(this.m);
        return clone;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.m.comparator());
        s.writeInt(this.m.size());
        for (Object e : this.m.keySet()) {
            s.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Comparator c = (Comparator)s.readObject();
        TreeMap<E, Object> tm = new TreeMap<E, Object>(c);
        this.m = tm;
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object element = s.readObject();
            tm.put(element, PRESENT);
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }
}

