/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.org.pcollections;

import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.AbstractUnmodifiableSequentialList;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.PStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class ConsPStack<E>
extends AbstractUnmodifiableSequentialList<E>
implements PStack<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ConsPStack<Object> EMPTY = new ConsPStack();
    private final E first;
    private final ConsPStack<E> rest;
    private final int size;

    public static <E> ConsPStack<E> empty() {
        return EMPTY;
    }

    public static <E> ConsPStack<E> singleton(E e) {
        return ConsPStack.empty().plus((Object)e);
    }

    public static <E> ConsPStack<E> from(Collection<? extends E> list) {
        if (list instanceof ConsPStack) {
            return (ConsPStack)list;
        }
        return ConsPStack.from(list.iterator());
    }

    private static <E> ConsPStack<E> from(Iterator<? extends E> i) {
        if (!i.hasNext()) {
            return ConsPStack.empty();
        }
        E e = i.next();
        return ConsPStack.from(i).plus((Object)e);
    }

    private ConsPStack() {
        if (EMPTY != null) {
            throw new RuntimeException("empty constructor should only be used once");
        }
        this.size = 0;
        this.first = null;
        this.rest = null;
    }

    private ConsPStack(E first, ConsPStack<E> rest) {
        this.first = first;
        this.rest = Objects.requireNonNull(rest, "rest is null");
        this.size = 1 + rest.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new ListIterator<E>(){
            int i;
            ConsPStack<E> next;
            {
                this.i = index;
                this.next = ConsPStack.this.subList(index);
            }

            @Override
            public boolean hasNext() {
                return this.next.size > 0;
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object e = this.next.first;
                this.next = this.next.rest;
                ++this.i;
                return e;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.next = ConsPStack.this.subList(--this.i);
                return this.next.first;
            }

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ConsPStack<E> subList(int start, int end) {
        if (start < 0 || end > this.size || start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return ConsPStack.empty();
        }
        if (start > 0) {
            return ((ConsPStack)this.subList(start)).subList(0, end - start);
        }
        if (end == this.size) {
            return this;
        }
        PStack<E> reversed = ConsPStack.empty();
        for (Object e : this) {
            if (reversed.size == end) break;
            reversed = reversed.plus(e);
        }
        return this.empty().plusAll((Collection)reversed);
    }

    @Override
    public ConsPStack<E> plus(E e) {
        return new ConsPStack<E>(e, this);
    }

    @Override
    public ConsPStack<E> plusAll(Collection<? extends E> list) {
        PStack<E> result = this;
        for (E e : list) {
            result = result.plus((Object)e);
        }
        return result;
    }

    @Override
    public ConsPStack<E> plus(int i, E e) {
        return this.plusAll(i, ConsPStack.singleton(e));
    }

    @Override
    public ConsPStack<E> plusAll(int i, Collection<? extends E> list) {
        if (i < 0 || i > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (list.isEmpty()) {
            return this;
        }
        PStack<E> reversed = ConsPStack.empty();
        ConsPStack<E> suffix = this;
        while (reversed.size < i) {
            reversed = reversed.plus((Object)suffix.first);
            suffix = suffix.rest;
        }
        return ((ConsPStack)suffix.plusAll((Collection)list)).plusAll(reversed);
    }

    @Override
    public ConsPStack<E> minus(Object e) {
        int i = this.indexOf(e);
        if (i == -1) {
            return this;
        }
        return this.minus(i);
    }

    @Override
    public ConsPStack<E> minus(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + i + "; size: " + this.size);
        }
        PStack<E> reversed = ConsPStack.empty();
        ConsPStack<E> suffix = this;
        while (reversed.size <= i) {
            reversed = reversed.plus((Object)suffix.first);
            suffix = suffix.rest;
        }
        return suffix.plusAll((Collection)reversed.rest);
    }

    @Override
    public ConsPStack<E> minusAll(Collection<?> list) {
        if (list.isEmpty()) {
            return this;
        }
        PStack<E> kept = ConsPStack.empty();
        ConsPStack<E> searching = this;
        ConsPStack<E> reversed = kept;
        ConsPStack<E> suffix = searching;
        while (searching.size > 0) {
            E e = searching.first;
            searching = searching.rest;
            if (list.contains(e)) {
                reversed = kept;
                suffix = searching;
                continue;
            }
            kept = kept.plus((Object)e);
        }
        return suffix.plusAll((Collection)reversed);
    }

    @Override
    public ConsPStack<E> with(int i, E e) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        PStack<E> reversed = ConsPStack.empty();
        ConsPStack<E> suffix = this;
        while (reversed.size <= i) {
            reversed = reversed.plus((Object)suffix.first);
            suffix = suffix.rest;
        }
        return ((ConsPStack)suffix.plus((Object)e)).plusAll(reversed.rest);
    }

    @Override
    public ConsPStack<E> subList(int start) {
        if (start < 0 || start > this.size) {
            throw new IndexOutOfBoundsException();
        }
        ConsPStack<E> s = this;
        while (start > 0) {
            s = s.rest;
            --start;
        }
        return s;
    }
}

