/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.org.pcollections;

import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.AbstractUnmodifiableMap;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.AbstractUnmodifiableSet;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.KVTree;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.PSortedMap;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.PSortedSet;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.TreePSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class TreePMap<K, V>
extends AbstractUnmodifiableMap<K, V>
implements PSortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final KVTree<K, V> tree;
    private final Comparator<? super K> ltrComparator;
    private final boolean isLeftToRight;

    private TreePMap(KVTree<K, V> tree, Comparator<? super K> ltrComparator, boolean isLeftToRight) {
        this.tree = Objects.requireNonNull(tree, "tree is null");
        this.ltrComparator = Objects.requireNonNull(ltrComparator, "comparator is null");
        this.isLeftToRight = isLeftToRight;
    }

    public static <K extends Comparable<? super K>, V> TreePMap<K, V> empty() {
        return TreePMap.empty(Comparator.naturalOrder());
    }

    public static <K, V> TreePMap<K, V> empty(Comparator<? super K> comparator) {
        return new TreePMap(KVTree.empty(), comparator, true);
    }

    public static <K extends Comparable<? super K>, V> TreePMap<K, V> from(Map<? extends K, ? extends V> map) {
        return TreePMap.from(Comparator.naturalOrder(), map);
    }

    public static <K, V> TreePMap<K, V> from(Comparator<? super K> comparator, Map<? extends K, ? extends V> map) {
        return TreePMap.empty(comparator).plusAll((Map)map);
    }

    public static <K, V> TreePMap<K, V> fromSortedMap(SortedMap<K, ? extends V> map) {
        Objects.requireNonNull(map, "map is null");
        if (map instanceof TreePMap) {
            return (TreePMap)TreePMap.sneakilyDowncast(map);
        }
        KVTree<K, V> tree = KVTree.fromEntryIterator(map.entrySet().iterator());
        Iterator<Map.Entry<K, V>> treeIterator = tree.entryIterator(true);
        while (treeIterator.hasNext()) {
            Map.Entry<K, V> entry = treeIterator.next();
            Objects.requireNonNull(entry.getKey(), "map contains null key");
        }
        Comparator thatComparator = map.comparator();
        Comparator comparator = thatComparator == null ? (Comparator)TreePMap.sneakilyDowncast(Comparator.naturalOrder()) : thatComparator;
        return new TreePMap<K, V>(tree, comparator, true);
    }

    public static <K extends Comparable<? super K>, V> TreePMap<K, V> singleton(K key, V value) {
        return TreePMap.singleton(Comparator.naturalOrder(), key, value);
    }

    public static <K, V> TreePMap<K, V> singleton(Comparator<? super K> comparator, K key, V value) {
        return TreePMap.empty(comparator).plus((Object)key, (Object)value);
    }

    public static <T, K extends Comparable<? super K>, V> Collector<T, ?, TreePMap<K, V>> toTreePMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return TreePMap.toTreePMap(Comparator.naturalOrder(), keyMapper, valueMapper);
    }

    public static <T, K, V> Collector<T, ?, TreePMap<K, V>> toTreePMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        BinaryOperator mergeFunction = (oldValue, newValue) -> {
            throw new IllegalStateException("duplicate key");
        };
        return TreePMap.toTreePMap(comparator, keyMapper, valueMapper, mergeFunction);
    }

    public static <T, K extends Comparable<? super K>, V> Collector<T, ?, TreePMap<K, V>> toTreePMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        return TreePMap.toTreePMap(Comparator.naturalOrder(), keyMapper, valueMapper, mergeFunction);
    }

    public static <T, K, V> Collector<T, ?, TreePMap<K, V>> toTreePMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        Objects.requireNonNull(mergeFunction, "mergeFunction is null");
        Supplier<TreeMap> treeMapSupplier = () -> new TreeMap(comparator);
        BiConsumer<TreeMap, Object> accumulator = (treeMap, element) -> {
            Object key = Objects.requireNonNull(keyMapper.apply(element), "key is null");
            Object value = valueMapper.apply(element);
            if (treeMap.containsKey(key)) {
                treeMap.put(key, mergeFunction.apply(treeMap.get(key), value));
            } else {
                treeMap.put(key, value);
            }
        };
        BinaryOperator combiner = (treeMap1, treeMap2) -> {
            for (Map.Entry entry : treeMap2.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (treeMap1.containsKey(key)) {
                    treeMap1.put(key, mergeFunction.apply(treeMap1.get(key), value));
                    continue;
                }
                treeMap1.put(key, value);
            }
            return treeMap1;
        };
        Function<TreeMap, TreePMap> finisher = TreePMap::fromSortedMap;
        return Collector.of(treeMapSupplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.search(key, KVTree.SearchType.GE, KVTree.SearchType.LE).orNullIfEmpty();
    }

    @Override
    public K ceilingKey(K key) {
        return this.search(key, KVTree.SearchType.GE, KVTree.SearchType.LE).getKey();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.isLeftToRight ? this.ltrComparator : this.ltrComparator.reversed();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.search(TreePMap.sneakilyDowncast(key), KVTree.SearchType.EQ, KVTree.SearchType.EQ) != KVTree.empty();
    }

    @Override
    public PSortedSet<K> descendingKeySet() {
        return new TreePSet<K>(this.tree, this.ltrComparator, !this.isLeftToRight);
    }

    @Override
    public TreePMap<K, V> descendingMap() {
        return new TreePMap<K, V>(this.tree, this.ltrComparator, !this.isLeftToRight);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractUnmodifiableSet<Map.Entry<K, V>>(){

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object k = e.getKey();
                if (!TreePMap.this.containsKey(k)) {
                    return false;
                }
                return Objects.equals(TreePMap.this.get(k), e.getValue());
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return TreePMap.this.tree.entryIterator(TreePMap.this.isLeftToRight);
            }

            @Override
            public int size() {
                return TreePMap.this.tree.size();
            }
        };
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return (this.isLeftToRight ? this.tree.getLeftmost() : this.tree.getRightmost()).orNullIfEmpty();
    }

    @Override
    public K firstKey() {
        return (this.isLeftToRight ? this.tree.getLeftmost() : this.tree.getRightmost()).getKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.search(key, KVTree.SearchType.LE, KVTree.SearchType.GE).orNullIfEmpty();
    }

    @Override
    public K floorKey(K key) {
        return this.search(key, KVTree.SearchType.LE, KVTree.SearchType.GE).getKey();
    }

    @Override
    public V get(Object key) {
        return this.search(TreePMap.sneakilyDowncast(key), KVTree.SearchType.EQ, KVTree.SearchType.EQ).getValue();
    }

    @Override
    public TreePMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public TreePMap<K, V> headMap(K toKey, boolean inclusive) {
        Objects.requireNonNull(toKey, "toKey is null");
        if (this.isLeftToRight) {
            return this.withTree(this.tree.rangeToLeft((K)toKey, inclusive, this.ltrComparator));
        }
        return this.withTree(this.tree.rangeToRight((K)toKey, inclusive, this.ltrComparator));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.search(key, KVTree.SearchType.GT, KVTree.SearchType.LT).orNullIfEmpty();
    }

    @Override
    public K higherKey(K key) {
        return this.search(key, KVTree.SearchType.GT, KVTree.SearchType.LT).getKey();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public TreePSet<K> keySet() {
        return new TreePSet<K>(this.tree, this.ltrComparator, this.isLeftToRight);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return (this.isLeftToRight ? this.tree.getRightmost() : this.tree.getLeftmost()).orNullIfEmpty();
    }

    @Override
    public K lastKey() {
        return (this.isLeftToRight ? this.tree.getRightmost() : this.tree.getLeftmost()).getKey();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.search(key, KVTree.SearchType.LT, KVTree.SearchType.GT).orNullIfEmpty();
    }

    @Override
    public K lowerKey(K key) {
        return this.search(key, KVTree.SearchType.LT, KVTree.SearchType.GT).getKey();
    }

    @Override
    public TreePMap<K, V> minus(Object key) {
        return this.withTree(this.tree.minus((K)TreePMap.sneakilyDowncast(Objects.requireNonNull(key, "key is null")), this.ltrComparator));
    }

    @Override
    public TreePMap<K, V> minusAll(Collection<?> keys) {
        KVTree<? super K, V> updatedTree = this.tree;
        for (Object key : Objects.requireNonNull(keys, "keys is null")) {
            updatedTree = updatedTree.minus((K)TreePMap.sneakilyDowncast(Objects.requireNonNull(key, "keys contains null element")), this.ltrComparator);
        }
        return this.withTree(updatedTree);
    }

    @Override
    public TreePMap<K, V> minusFirstEntry() {
        return this.withTree(this.isLeftToRight ? this.tree.minusLeftmost() : this.tree.minusRightmost());
    }

    @Override
    public TreePMap<K, V> minusLastEntry() {
        return this.withTree(this.isLeftToRight ? this.tree.minusRightmost() : this.tree.minusLeftmost());
    }

    @Override
    public TreePSet<K> navigableKeySet() {
        return this.keySet();
    }

    @Override
    public TreePMap<K, V> plus(K key, V value) {
        return this.withTree(this.tree.plus((K)Objects.requireNonNull(key), value, this.ltrComparator));
    }

    @Override
    public TreePMap<K, V> plusAll(Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map, "map is null");
        KVTree<? super K, V> updatedTree = this.tree;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            updatedTree = updatedTree.plus((K)Objects.requireNonNull(entry.getKey(), "map contains null key"), entry.getValue(), this.ltrComparator);
        }
        return this.withTree(updatedTree);
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public TreePMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public TreePMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        Objects.requireNonNull(fromKey, "fromKey is null");
        Objects.requireNonNull(toKey, "toKey is null");
        if (this.comparator().compare(fromKey, toKey) > 0) {
            throw new IllegalArgumentException("fromKey > toKey");
        }
        if (this.isLeftToRight) {
            return this.withTree(this.tree.range((K)fromKey, fromInclusive, (K)toKey, toInclusive, this.ltrComparator));
        }
        return this.withTree(this.tree.range((K)toKey, toInclusive, (K)fromKey, fromInclusive, this.ltrComparator));
    }

    @Override
    public TreePMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public TreePMap<K, V> tailMap(K fromKey, boolean inclusive) {
        Objects.requireNonNull(fromKey, "fromKey is null");
        if (this.isLeftToRight) {
            return this.withTree(this.tree.rangeToRight((K)fromKey, inclusive, this.ltrComparator));
        }
        return this.withTree(this.tree.rangeToLeft((K)fromKey, inclusive, this.ltrComparator));
    }

    private KVTree<K, V> search(K key, KVTree.SearchType searchTypeIfLeftToRight, KVTree.SearchType searchTypeIfRightToLeft) {
        return this.tree.search((K)Objects.requireNonNull(key, "key is null"), this.ltrComparator, this.isLeftToRight ? searchTypeIfLeftToRight : searchTypeIfRightToLeft);
    }

    private TreePMap<K, V> withTree(KVTree<K, V> updatedTree) {
        return updatedTree == this.tree ? this : new TreePMap<K, V>(updatedTree, this.ltrComparator, this.isLeftToRight);
    }

    private static <T> T sneakilyDowncast(Object o) {
        return (T)o;
    }
}

