/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utilsformods.thaumcraft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.utils.Utils;

public class ThaumcraftCraftingManager2 {
    public static Set optimizationsAndTweaks$history2 = new HashSet();

    public static AspectList optimizationsAndTweaks$getTags(ItemStack itemstack) {
        AspectList tags;
        int meta;
        Item item;
        try {
            item = itemstack.func_77973_b();
            meta = itemstack.func_77960_j();
        }
        catch (Exception e) {
            return null;
        }
        if (optimizationsAndTweaks$history2.contains(itemstack)) {
            return null;
        }
        if (ThaumcraftApi.exists((Item)item, (int)meta)) {
            tags = ThaumcraftCraftingManager.getObjectTags((ItemStack)new ItemStack(item, 1, meta));
        } else {
            optimizationsAndTweaks$history2.add(itemstack);
            tags = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTagsFromRecipes(item, meta == Short.MAX_VALUE ? 0 : meta);
            optimizationsAndTweaks$history2.remove(itemstack);
            tags = ThaumcraftCraftingManager2.capAspects(tags, 64);
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item, 1, meta), (AspectList)tags);
        }
        return tags;
    }

    public static AspectList capAspects(AspectList sourcetags, int amount) {
        Aspect[] arr$;
        if (sourcetags == null) {
            return sourcetags;
        }
        AspectList out = new AspectList();
        for (Aspect aspect : arr$ = sourcetags.getAspects()) {
            out.merge(aspect, Math.min(amount, sourcetags.getAmount(aspect)));
        }
        return out;
    }

    public static AspectList optimizationsAndTweaks$generateTagsFromRecipes(Item item, int meta) {
        AspectList ret = null;
        block6: for (int recipeType = 0; ret == null && recipeType < 4; ++recipeType) {
            switch (recipeType) {
                case 0: {
                    ret = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTagsFromCrucibleRecipes(item, meta);
                    continue block6;
                }
                case 1: {
                    ret = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTagsFromArcaneRecipes(item, meta);
                    continue block6;
                }
                case 2: {
                    ret = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTagsFromInfusionRecipes(item, meta);
                    continue block6;
                }
                case 3: {
                    ret = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTagsFromCraftingRecipes(item, meta);
                    continue block6;
                }
            }
        }
        return ret;
    }

    public static AspectList optimizationsAndTweaks$generateTagsFromCrucibleRecipes(Item item, int meta) {
        CrucibleRecipe cr = ThaumcraftApi.getCrucibleRecipe((ItemStack)new ItemStack(item, 1, meta));
        if (cr != null) {
            AspectList ot = cr.aspects.copy();
            int ss = cr.getRecipeOutput().field_77994_a;
            ItemStack cat = null;
            if (cr.catalyst instanceof ItemStack) {
                cat = (ItemStack)cr.catalyst;
            } else if (cr.catalyst instanceof ArrayList && !((ArrayList)cr.catalyst).isEmpty()) {
                cat = (ItemStack)((ArrayList)cr.catalyst).get(0);
            }
            assert (cat != null);
            AspectList ot2 = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTags(cat.func_77973_b(), cat.func_77960_j());
            AspectList out = new AspectList();
            if (ot2 != null && ot2.size() > 0) {
                for (Aspect as : ot2.getAspects()) {
                    out.add(as, ot2.getAmount(as));
                }
            }
            for (Aspect as : ot.getAspects()) {
                int amt = (int)(Math.sqrt(ot.getAmount(as)) / (double)ss);
                out.add(as, amt);
            }
            for (Aspect as : out.getAspects()) {
                if (out.getAmount(as) > 0) continue;
                out.remove(as);
            }
            return out;
        }
        return null;
    }

    public static AspectList optimizationsAndTweaks$generateTagsFromArcaneRecipes(Item item, int meta) {
        AspectList ret = null;
        List recipeList = ThaumcraftApi.getCraftingRecipes();
        block2: for (Object o : recipeList) {
            IArcaneRecipe recipe;
            if (!(o instanceof IArcaneRecipe) || (recipe = (IArcaneRecipe)o).getRecipeOutput() == null) continue;
            int idR = recipe.getRecipeOutput().func_77960_j() == Short.MAX_VALUE ? 0 : recipe.getRecipeOutput().func_77960_j();
            int idS = Math.max(meta, 0);
            if (recipe.getRecipeOutput().func_77973_b() != item || idR != idS) continue;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            new AspectList();
            try {
                ItemStack is;
                int i;
                if (o instanceof ShapedArcaneRecipe) {
                    int width = ((ShapedArcaneRecipe)o).width;
                    Object[] items = ((ShapedArcaneRecipe)o).getInput();
                    for (i = 0; i < width && i < 3; ++i) {
                        block4: for (int j = 0; j < i; ++j) {
                            ItemStack it;
                            if (items[i + j * width] == null) continue;
                            if (items[i + j * width] instanceof ArrayList) {
                                for (Object object : (ArrayList)items[i + j * width]) {
                                    it = (ItemStack)object;
                                    if (Utils.isEETransmutionItem((Item)it.func_77973_b())) continue block2;
                                    AspectList obj = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTags(it.func_77973_b(), it.func_77960_j());
                                    if (obj == null || obj.size() <= 0) continue;
                                    is = it.func_77946_l();
                                    is.field_77994_a = 1;
                                    ingredients.add(is);
                                    continue block4;
                                }
                                continue;
                            }
                            is = (ItemStack)items[i + j * width];
                            if (Utils.isEETransmutionItem((Item)is.func_77973_b())) continue block2;
                            it = is.func_77946_l();
                            it.field_77994_a = 1;
                            ingredients.add(it);
                        }
                    }
                } else if (o instanceof ShapelessArcaneRecipe) {
                    ArrayList items = ((ShapelessArcaneRecipe)o).getInput();
                    block6: for (int i2 = 0; i2 < items.size() && i2 < 9; ++i2) {
                        ItemStack it;
                        if (items.get(i2) == null) continue;
                        if (items.get(i2) instanceof ArrayList) {
                            for (Object object : (ArrayList)items.get(i2)) {
                                it = (ItemStack)object;
                                if (Utils.isEETransmutionItem((Item)it.func_77973_b())) continue block2;
                                AspectList obj = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTags(it.func_77973_b(), it.func_77960_j());
                                if (obj == null || obj.size() <= 0) continue;
                                is = it.func_77946_l();
                                is.field_77994_a = 1;
                                ingredients.add(is);
                                continue block6;
                            }
                            continue;
                        }
                        it = (ItemStack)items.get(i2);
                        if (Utils.isEETransmutionItem((Item)it.func_77973_b())) continue block2;
                        it = it.func_77946_l();
                        it.field_77994_a = 1;
                        ingredients.add(it);
                    }
                }
                AspectList ph = ThaumcraftCraftingManager2.optimizationsAndTweaks$getAspectsFromIngredients(ingredients, recipe.getRecipeOutput());
                if (recipe.getAspects() != null) {
                    for (Aspect as : recipe.getAspects().getAspects()) {
                        ph.add(as, (int)(Math.sqrt(recipe.getAspects().getAmount(as)) / (double)recipe.getRecipeOutput().field_77994_a));
                    }
                }
                Aspect[] arr$ = ph.copy().getAspects();
                i = arr$.length;
                for (int i$ = 0; i$ < i; ++i$) {
                    Aspect as;
                    as = arr$[i$];
                    if (ph.getAmount(as) > 0) continue;
                    ph.remove(as);
                }
                ret = ph;
            }
            catch (Exception var22) {
                var22.printStackTrace();
            }
        }
        return ret;
    }

    public static AspectList optimizationsAndTweaks$generateTags(Item item, int meta) {
        int tmeta = meta;
        try {
            tmeta = !Objects.requireNonNull(new ItemStack(item, 1, meta).func_77973_b()).func_77645_m() && Objects.requireNonNull(new ItemStack(item, 1, meta).func_77973_b()).func_77614_k() ? meta : Short.MAX_VALUE;
        }
        catch (Exception exception) {
            // empty catch block
        }
        optimizationsAndTweaks$history2.add(item);
        optimizationsAndTweaks$history2.add(tmeta);
        if (ThaumcraftApi.exists((Item)item, (int)tmeta)) {
            return ThaumcraftCraftingManager2.optimizationsAndTweaks$getTags(new ItemStack(item, 1, tmeta));
        }
        if (optimizationsAndTweaks$history2.contains(item) && optimizationsAndTweaks$history2.contains(tmeta)) {
            return null;
        }
        AspectList ret = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTagsFromRecipes(item, tmeta == Short.MAX_VALUE ? 0 : meta);
        ret = ThaumcraftCraftingManager2.capAspects(ret, 64);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(item, 1, tmeta), (AspectList)ret);
        return ret;
    }

    public static AspectList optimizationsAndTweaks$getAspectsFromIngredients(ArrayList<ItemStack> ingredients, ItemStack recipeOut) {
        Aspect[] aspectArray;
        Aspect[] midAspects;
        AspectList out = new AspectList();
        AspectList mid = new AspectList();
        for (ItemStack itemStack : ingredients) {
            Aspect[] objAspects;
            int n;
            Aspect[] containerAspects;
            AspectList obj = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTags(itemStack.func_77973_b(), itemStack.func_77960_j());
            if (Objects.requireNonNull(itemStack.func_77973_b()).func_77668_q() != null && itemStack.func_77973_b().func_77668_q() != itemStack.func_77973_b()) {
                AspectList objC = ThaumcraftCraftingManager2.optimizationsAndTweaks$generateTags(itemStack.func_77973_b().func_77668_q(), Short.MAX_VALUE);
                assert (objC != null);
                Aspect[] aspectArray2 = containerAspects = objC.getAspects();
                n = aspectArray2.length;
                for (int i = 0; i < n; ++i) {
                    Aspect as = aspectArray2[i];
                    out.reduce(as, objC.getAmount(as));
                }
            }
            if (obj == null) continue;
            containerAspects = objAspects = obj.getAspects();
            int n2 = containerAspects.length;
            for (n = 0; n < n2; ++n) {
                Aspect as = containerAspects[n];
                if (as == null) continue;
                mid.add(as, obj.getAmount(as));
            }
        }
        for (Aspect as : midAspects = mid.getAspects()) {
            if (as == null) continue;
            out.add(as, (int)((float)mid.getAmount(as) * 0.75f / (float)recipeOut.field_77994_a));
        }
        for (Aspect as : aspectArray = out.getAspects()) {
            if (out.getAmount(as) > 0) continue;
            out.remove(as);
        }
        return out;
    }

    public static AspectList optimizationsAndTweaks$generateTagsFromInfusionRecipes(Item item, int meta) {
        Aspect[] outAspects;
        Aspect[] aspectArray;
        Aspect[] aspectsFromOt2;
        ItemStack[] components;
        InfusionRecipe cr = ThaumcraftApi.getInfusionRecipe((ItemStack)new ItemStack(item, 1, meta));
        if (cr == null) {
            return null;
        }
        AspectList ot = cr.getAspects().copy();
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack is = cr.getRecipeInput().func_77946_l();
        is.field_77994_a = 1;
        ingredients.add(is);
        for (ItemStack itemStack : components = cr.getComponents()) {
            ItemStack is2 = itemStack.func_77946_l();
            is2.field_77994_a = 1;
            ingredients.add(is2);
        }
        AspectList out = new AspectList();
        AspectList ot2 = ThaumcraftCraftingManager2.optimizationsAndTweaks$getAspectsFromIngredients(ingredients, (ItemStack)cr.getRecipeOutput());
        for (Aspect as : aspectsFromOt2 = ot2.getAspects()) {
            out.add(as, ot2.getAmount(as));
        }
        for (Aspect as : aspectArray = ot.getAspects()) {
            int amt = (int)(Math.sqrt(ot.getAmount(as)) / (double)((ItemStack)cr.getRecipeOutput()).field_77994_a);
            out.add(as, amt);
        }
        for (Aspect as : outAspects = out.getAspects()) {
            if (out.getAmount(as) > 0) continue;
            out.remove(as);
        }
        return out;
    }

    public static AspectList optimizationsAndTweaks$generateTagsFromCraftingRecipes(Item item, int meta) {
        AspectList ret = new AspectList();
        int minValue = Integer.MAX_VALUE;
        List<IRecipe> recipeList = Collections.unmodifiableList(new ArrayList(CraftingManager.func_77594_a().func_77592_b()));
        for (IRecipe object : recipeList) {
            if (!ThaumcraftCraftingManager2.optimizationsAndTweaks$isValidRecipe(object, item, meta)) continue;
            try {
                AspectList ph = ThaumcraftCraftingManager2.optimizationsAndTweaks$processRecipeAndGetAspects(object);
                ThaumcraftCraftingManager2.optimizationsAndTweaks$refineAndSetMinValueAspect(ph, minValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private static boolean optimizationsAndTweaks$isValidRecipe(IRecipe recipe, Item item, int meta) {
        if (recipe == null || recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() == null) {
            return false;
        }
        ItemStack outputStack = recipe.func_77571_b().func_77946_l();
        ItemStack comparisonStack = new ItemStack(item, 1, meta);
        return ItemStack.func_77989_b((ItemStack)outputStack, (ItemStack)comparisonStack);
    }

    private static AspectList optimizationsAndTweaks$processRecipeAndGetAspects(IRecipe recipe) {
        AspectList aspectList = new AspectList();
        try {
            if (recipe instanceof ShapedRecipes) {
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processShapedRecipe((ShapedRecipes)recipe, aspectList);
            } else if (recipe instanceof ShapelessRecipes) {
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processShapelessRecipe((ShapelessRecipes)recipe, aspectList);
            } else if (recipe instanceof ShapedOreRecipe) {
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processShapedOreRecipe((ShapedOreRecipe)recipe, aspectList);
            } else if (recipe instanceof ShapelessOreRecipe) {
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processShapelessOreRecipe((ShapelessOreRecipe)recipe, aspectList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aspectList;
    }

    private static void optimizationsAndTweaks$processShapedRecipe(ShapedRecipes recipe, AspectList aspectList) {
        if (recipe == null || recipe.field_77574_d == null || recipe.field_77574_d.length == 0) {
            return;
        }
        int width = recipe.field_77576_b;
        ItemStack[] items = recipe.field_77574_d;
        int calculatedWidth = Math.min(width, (int)Math.sqrt(items.length));
        for (int i = 0; i < calculatedWidth; ++i) {
            for (int j = 0; j < calculatedWidth; ++j) {
                int index = i + j * calculatedWidth;
                if (index < 0 || index >= items.length) continue;
                ItemStack stack = items[index];
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processItemStack(stack, aspectList);
            }
        }
    }

    private static void optimizationsAndTweaks$processShapelessRecipe(ShapelessRecipes recipe, AspectList aspectList) {
        List<List> items = Collections.singletonList(recipe.field_77579_b);
        for (List item : items) {
            if (item instanceof ItemStack) {
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processItemStack((ItemStack)item, aspectList);
                continue;
            }
            if (!(item instanceof List)) continue;
            for (Object stack : item) {
                if (!(stack instanceof ItemStack)) continue;
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processItemStack((ItemStack)stack, aspectList);
            }
        }
    }

    private static void optimizationsAndTweaks$processShapedOreRecipe(ShapedOreRecipe recipe, AspectList aspectList) {
        Object[] input = recipe.getInput();
        if (input != null) {
            Object[] items;
            for (Object item : items = input) {
                if (item instanceof ItemStack) {
                    ThaumcraftCraftingManager2.optimizationsAndTweaks$processItemStack((ItemStack)item, aspectList);
                    continue;
                }
                if (!(item instanceof ArrayList)) continue;
                for (Object o : (ArrayList)item) {
                    if (!(o instanceof ItemStack)) continue;
                    ThaumcraftCraftingManager2.optimizationsAndTweaks$processItemStack((ItemStack)o, aspectList);
                }
            }
        }
    }

    private static void optimizationsAndTweaks$processShapelessOreRecipe(ShapelessOreRecipe recipe, AspectList aspectList) {
        List<ArrayList> items = Collections.singletonList(recipe.getInput());
        for (ArrayList item : items) {
            if (item instanceof ItemStack) {
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processItemStack((ItemStack)item, aspectList);
                continue;
            }
            if (!(item instanceof ArrayList)) continue;
            for (Object o : item) {
                if (!(o instanceof ItemStack)) continue;
                ThaumcraftCraftingManager2.optimizationsAndTweaks$processItemStack((ItemStack)o, aspectList);
            }
        }
    }

    private static void optimizationsAndTweaks$refineAndSetMinValueAspect(AspectList ph, int minValue) {
        if (ph != null && ph.visSize() > 0) {
            ArrayList<Aspect> aspectsToRemove = new ArrayList<Aspect>();
            for (Aspect aspect : ph.getAspects()) {
                if (ph.getAmount(aspect) > 0) continue;
                aspectsToRemove.add(aspect);
            }
            for (Aspect aspect : aspectsToRemove) {
                ph.remove(aspect);
            }
            if (ph.visSize() < minValue) {
                ph.copy();
                ph.visSize();
            }
        }
    }

    private static void optimizationsAndTweaks$processItemStack(ItemStack stack, AspectList aspectList) {
        AspectList aspects;
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if (!Utils.isEETransmutionItem((Item)stack.func_77973_b()) && (aspects = ThaumcraftCraftingManager2.optimizationsAndTweaks$getTags(stack)) != null && aspects.size() > 0) {
            ItemStack clonedStack = stack.func_77946_l();
            if (clonedStack.field_77994_a != 1) {
                clonedStack.field_77994_a = 1;
            }
            aspectList.merge(aspects);
        }
    }
}

