/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.client.core;

import ibxm.IBXM;
import ibxm.Module;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.codecs.CodecIBXM;

@Mixin(value={CodecIBXM.class})
public abstract class MixinCodecIBXM
implements ICodec {
    @Shadow
    private static final boolean XXX = false;
    @Shadow
    private AudioFormat myAudioFormat = null;
    @Shadow
    private static final boolean GET = false;
    @Shadow
    private static final boolean SET = true;
    @Shadow
    private SoundSystemLogger logger;
    @Shadow
    private Module module;
    @Shadow
    private boolean endOfStream = false;
    @Shadow
    private boolean reverseBytes = false;
    @Shadow
    private int songDuration;
    @Shadow
    private int playPosition;
    @Shadow
    private IBXM ibxm;

    @Shadow
    private void errorMessage(String message) {
        this.logger.errorMessage("CodecWav", message, 0);
    }

    @Overwrite
    private static byte[] appendByteArrays(byte[] arrayOne, byte[] arrayTwo, int length) {
        if (arrayOne == null && arrayTwo == null) {
            return new byte[0];
        }
        if (arrayOne == null) {
            return Arrays.copyOf(arrayTwo, length);
        }
        if (arrayTwo == null) {
            return Arrays.copyOf(arrayOne, arrayOne.length);
        }
        byte[] newArray = Arrays.copyOf(arrayOne, arrayOne.length + length);
        System.arraycopy(arrayTwo, 0, newArray, arrayOne.length, length);
        return newArray;
    }

    public SoundBuffer readAll() {
        if (this.module == null) {
            this.errorMessage("Module null in method 'readAll'");
            return null;
        }
        if (this.myAudioFormat == null) {
            this.errorMessage("Audio Format null in method 'readAll'");
            return null;
        }
        int bufferFrameSize = SoundSystemConfig.getFileChunkSize() / 4;
        byte[] outputBuffer = new byte[bufferFrameSize * 4];
        byte[] fullBuffer = null;
        int totalBytes = 0;
        while (!this.endOfStream(false, false) && totalBytes < SoundSystemConfig.getMaxFileSize()) {
            int frames = Math.min(this.songDuration - this.playPosition, bufferFrameSize);
            this.ibxm.get_audio(outputBuffer, frames);
            totalBytes += frames * 4;
            fullBuffer = MixinCodecIBXM.appendByteArrays(fullBuffer, outputBuffer, frames * 4);
            this.playPosition += frames;
            if (this.playPosition < this.songDuration) continue;
            this.endOfStream(true, true);
        }
        if (this.reverseBytes) {
            MixinCodecIBXM.reverseBytes(fullBuffer, 0, totalBytes);
        }
        return new SoundBuffer(fullBuffer, this.myAudioFormat);
    }

    @Shadow
    private synchronized boolean endOfStream(boolean action, boolean value) {
        if (action) {
            this.endOfStream = value;
        }
        return this.endOfStream;
    }

    @Shadow
    public static void reverseBytes(byte[] buffer, int offset, int size) {
        for (int i = offset; i < offset + size; i += 2) {
            byte b = buffer[i];
            buffer[i] = buffer[i + 1];
            buffer[i + 1] = b;
        }
    }
}

