/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import fr.iamacat.optimizationsandtweaks.utils.trove.map.hash.THashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringTranslate;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LanguageRegistry.class})
public class MixinLanguageRegistry {
    @Shadow
    private static final LanguageRegistry INSTANCE = new LanguageRegistry();
    @Unique
    private THashMap<String, Properties> optimizationsAndTweaks$modLanguageData = new THashMap();
    @Shadow
    private static final Pattern assetENUSLang = Pattern.compile("assets/(.*)/lang/(?:.+/|)([\\w_-]+).lang");

    @Shadow
    public static LanguageRegistry instance() {
        return INSTANCE;
    }

    @Shadow
    public String getStringLocalization(String key) {
        return this.getStringLocalization(key, FMLCommonHandler.instance().getCurrentLanguage());
    }

    @Overwrite(remap=false)
    public String getStringLocalization(String key, String lang) {
        String localizedString = "";
        Properties langPack = this.optimizationsAndTweaks$modLanguageData.get(lang);
        if (langPack != null && langPack.getProperty(key) != null) {
            localizedString = langPack.getProperty(key);
        }
        return localizedString;
    }

    @Overwrite(remap=false)
    @Deprecated
    public void addStringLocalization(String key, String value) {
        this.addStringLocalization(key, "en_US", value);
    }

    @Overwrite(remap=false)
    @Deprecated
    public void addStringLocalization(String key, String lang, String value) {
        Properties langPack = this.optimizationsAndTweaks$modLanguageData.get(lang);
        if (langPack == null) {
            langPack = new Properties();
            this.optimizationsAndTweaks$modLanguageData.put(lang, langPack);
        }
        langPack.put(key, value);
    }

    @Shadow
    @Deprecated
    public void addStringLocalization(Properties langPackAdditions) {
        this.addStringLocalization(langPackAdditions, "en_US");
    }

    @Overwrite(remap=false)
    @Deprecated
    public void addStringLocalization(Properties langPackAdditions, String lang) {
        Properties langPack = this.optimizationsAndTweaks$modLanguageData.get(lang);
        if (langPack == null) {
            langPack = new Properties();
            this.optimizationsAndTweaks$modLanguageData.put(lang, langPack);
        }
        if (langPackAdditions != null) {
            langPack.putAll((Map<?, ?>)langPackAdditions);
        }
    }

    @Shadow
    @Deprecated
    public void addNameForObject(Object objectToName, String lang, String name) {
        String objectName;
        if (objectToName instanceof Item) {
            objectName = ((Item)objectToName).func_77658_a();
        } else if (objectToName instanceof Block) {
            objectName = ((Block)objectToName).func_149739_a();
        } else if (objectToName instanceof ItemStack) {
            objectName = Objects.requireNonNull(((ItemStack)objectToName).func_77973_b()).func_77667_c((ItemStack)objectToName);
        } else {
            throw new IllegalArgumentException(String.format("Illegal object for naming %s", objectToName));
        }
        objectName = objectName + ".name";
        this.addStringLocalization(objectName, lang, name);
    }

    @Shadow
    @Deprecated
    public static void addName(Object objectToName, String name) {
        MixinLanguageRegistry.instance().addNameForObject(objectToName, "en_US", name);
    }

    @Overwrite(remap=false)
    @Deprecated
    public void mergeLanguageTable(Map field_135032_a, String lang) {
        Properties usPack;
        Properties langPack = this.optimizationsAndTweaks$modLanguageData.get(lang);
        if (langPack != null) {
            this.mergeWithoutOverwrite(langPack, field_135032_a);
        }
        if ((usPack = this.optimizationsAndTweaks$modLanguageData.get("en_US")) != null) {
            this.mergeWithoutOverwrite(usPack, field_135032_a);
        }
    }

    @Shadow
    @Deprecated
    private <K, V> void mergeWithoutOverwrite(Map<? extends K, ? extends V> from, Map<K, V> to) {
        for (Map.Entry<K, V> e : from.entrySet()) {
            if (to.containsKey(e.getKey())) continue;
            to.put(e.getKey(), e.getValue());
        }
    }

    @Shadow
    @Deprecated
    public void loadLocalization(String localizationFile, String lang, boolean isXML) {
        URL urlResource = this.getClass().getResource(localizationFile);
        if (urlResource != null) {
            this.loadLocalization(urlResource, lang, isXML);
        } else {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            if (activeModContainer != null) {
                FMLLog.log((String)activeModContainer.getModId(), (Level)Level.ERROR, (String)"The language resource %s cannot be located on the classpath. This is a programming error.", (Object[])new Object[]{localizationFile});
            } else {
                FMLLog.log((Level)Level.ERROR, (String)"The language resource %s cannot be located on the classpath. This is a programming error.", (Object[])new Object[]{localizationFile});
            }
        }
    }

    @Overwrite(remap=false)
    @Deprecated
    public void loadLocalization(URL localizationFile, String lang, boolean isXML) {
        Properties langPack = new Properties();
        try (InputStream langStream = localizationFile.openStream();){
            if (isXML) {
                langPack.loadFromXML(langStream);
            } else {
                langPack.load(new InputStreamReader(langStream, StandardCharsets.UTF_8));
            }
            this.addStringLocalization(langPack, lang);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to load localization from file %s", (Object[])new Object[]{localizationFile});
        }
    }

    @Overwrite(remap=false)
    public void injectLanguage(String language, HashMap<String, String> parsedLangFile) {
        Properties p = this.optimizationsAndTweaks$modLanguageData.get(language);
        if (p == null) {
            p = new Properties();
            this.optimizationsAndTweaks$modLanguageData.put(language, p);
        }
        p.putAll((Map<?, ?>)parsedLangFile);
    }

    @Shadow
    public void loadLanguagesFor(ModContainer container, Side side) {
        File source = container.getSource();
        try {
            if (source.isDirectory()) {
                this.searchDirForLanguages(source, "", side);
            } else {
                this.searchZipForLanguages(source, side);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Shadow
    private void searchZipForLanguages(File source, Side side) throws IOException {
        ZipFile zf = new ZipFile(source);
        ArrayList added = Lists.newArrayList();
        for (ZipEntry zipEntry : Collections.list(zf.entries())) {
            Matcher matcher = assetENUSLang.matcher(zipEntry.getName());
            if (!matcher.matches()) continue;
            String lang = matcher.group(2);
            added.add(lang);
            LanguageRegistry.instance().injectLanguage(lang, StringTranslate.parseLangFile((InputStream)zf.getInputStream(zipEntry)));
            if (!"en_US".equals(lang) || side != Side.SERVER) continue;
            StringTranslate.inject((InputStream)zf.getInputStream(zipEntry));
        }
        if (!added.isEmpty()) {
            FMLLog.fine((String)"Found translations in %s [%s]", (Object[])new Object[]{source.getName(), Joiner.on((String)", ").join((Iterable)added)});
        }
        zf.close();
    }

    @Overwrite(remap=false)
    private void searchDirForLanguages(File source, String path, Side side) throws IOException {
        for (File file : Objects.requireNonNull(source.listFiles())) {
            Matcher matcher;
            String currPath = path + file.getName();
            if (file.isDirectory()) {
                this.searchDirForLanguages(file, currPath + '/', side);
            }
            if (!(matcher = assetENUSLang.matcher(currPath)).matches()) continue;
            String lang = matcher.group(2);
            FMLLog.fine((String)"Injecting found translation assets for lang %s at %s into language system", (Object[])new Object[]{lang, currPath});
            LanguageRegistry.instance().injectLanguage(lang, StringTranslate.parseLangFile((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
            if (!"en_US".equals(lang) || side != Side.SERVER) continue;
            StringTranslate.inject((InputStream)new FileInputStream(file));
        }
    }
}

