/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.ganysnether;

import ganymedes01.ganysnether.GanysNether;
import ganymedes01.ganysnether.ModBlocks;
import ganymedes01.ganysnether.core.utils.Utils;
import ganymedes01.ganysnether.tileentities.TileEntityUndertaker;
import ganymedes01.ganysnether.world.NetherWorldGen;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ChestGenHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={NetherWorldGen.class})
public class MixinNetherWorldGenGanys {
    @Overwrite(remap=false)
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Chunk chunk = world.func_72964_e(chunkX >>= 4, chunkZ >>= 4);
        if (!chunk.field_76636_d) {
            return;
        }
        if (world.field_73011_w.field_76575_d) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 20; y < 84; ++y) {
                    block10: for (int z = 0; z < 16; ++z) {
                        int blockX = chunkX * 16 + x;
                        int blockY = y + 1;
                        int blockZ = chunkZ * 16 + z;
                        if (GanysNether.shouldGenerateUndertakers && rand.nextInt(GanysNether.undertakerRate) == 0 && this.shouldGenerate(world, blockX, blockY, blockZ)) {
                            this.generateUndertakerWithRandomContents(world, blockX, blockY, blockZ, rand);
                            continue;
                        }
                        if (!GanysNether.shouldGenerateCrops || rand.nextInt(GanysNether.netherCropRate) != 0 || !this.shouldGenerate(world, blockX, blockY, blockZ) || !this.hasLavaNearby(world, blockX, blockY - 1, blockZ)) continue;
                        switch (rand.nextInt(6)) {
                            case 0: {
                                if (!GanysNether.shouldGenerateGlowingReed) continue block10;
                                world.func_147449_b(blockX, blockY - 1, blockZ, Blocks.field_150424_aL);
                                world.func_147449_b(blockX, blockY, blockZ, ModBlocks.glowingReed);
                                if (rand.nextInt(10) != 5) continue block10;
                                world.func_147449_b(blockX, blockY + 1, blockZ, ModBlocks.glowingReed);
                                continue block10;
                            }
                            case 1: {
                                if (!GanysNether.shouldGenerateSpectreWheat) continue block10;
                                world.func_147449_b(blockX, blockY - 1, blockZ, ModBlocks.tilledNetherrack);
                                world.func_147465_d(blockX, blockY, blockZ, ModBlocks.spectreWheat, rand.nextInt(7), 2);
                                continue block10;
                            }
                            case 2: {
                                if (!GanysNether.shouldGenerateQuarzBerryBush) continue block10;
                                world.func_147449_b(blockX, blockY - 1, blockZ, ModBlocks.tilledNetherrack);
                                world.func_147465_d(blockX, blockY, blockZ, ModBlocks.quarzBerryBush, rand.nextInt(7), 2);
                                continue block10;
                            }
                            case 3: {
                                if (!GanysNether.shouldGenerateWitherShrub || rand.nextInt(GanysNether.witherShrubRate) != 0) continue block10;
                                world.func_147449_b(blockX, blockY - 1, blockZ, ModBlocks.tilledNetherrack);
                                world.func_147465_d(blockX, blockY, blockZ, ModBlocks.witherShrub, rand.nextInt(6), 2);
                                world.func_147449_b(blockX, blockY + 1, blockZ, Blocks.field_150426_aN);
                                continue block10;
                            }
                            case 4: {
                                if (!GanysNether.shouldGenerateBlazingCactoid) continue block10;
                                world.func_147449_b(blockX, blockY - 1, blockZ, Blocks.field_150424_aL);
                                world.func_147449_b(blockX, blockY, blockZ, ModBlocks.blazingCactoid);
                                if (rand.nextInt(10) != 5) continue block10;
                                world.func_147449_b(blockX, blockY + 1, blockZ, ModBlocks.blazingCactoid);
                                continue block10;
                            }
                            case 5: {
                                if (!GanysNether.shouldGenerateHellBush) continue block10;
                                world.func_147449_b(blockX, blockY - 1, blockZ, ModBlocks.tilledNetherrack);
                                world.func_147465_d(blockX, blockY, blockZ, ModBlocks.hellBush, rand.nextInt(7), 2);
                            }
                        }
                    }
                }
            }
        }
    }

    @Overwrite(remap=false)
    private boolean hasLavaNearby(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x + 1, y, z);
        if (block != null && block.func_149688_o() == Material.field_151587_i) {
            return true;
        }
        block = world.func_147439_a(x - 1, y, z);
        if (block != null && block.func_149688_o() == Material.field_151587_i) {
            return true;
        }
        block = world.func_147439_a(x, y, z + 1);
        if (block != null && block.func_149688_o() == Material.field_151587_i) {
            return true;
        }
        block = world.func_147439_a(x, y, z - 1);
        return block != null && block.func_149688_o() == Material.field_151587_i;
    }

    @Shadow
    private boolean shouldGenerate(World world, int x, int y, int z) {
        return y >= 25 && !world.func_147437_c(x, y - 1, z) && world.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151587_i && world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z) && world.func_147437_c(x, y + 2, z);
    }

    @Shadow
    private void generateUndertakerWithRandomContents(World world, int x, int y, int z, Random rand) {
        world.func_147449_b(x, y, z, ModBlocks.undertaker);
        TileEntityUndertaker undertaker = (TileEntityUndertaker)Utils.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityUndertaker.class);
        if (undertaker != null) {
            ChestGenHooks info = ChestGenHooks.getInfo((String)"ganysnether.undertaker");
            WeightedRandomChestContent.func_76293_a((Random)world.field_73012_v, (WeightedRandomChestContent[])info.getItems(world.field_73012_v), (IInventory)undertaker, (int)info.getCount(world.field_73012_v));
        }
    }
}

