/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.matmos;

import eu.ha3.matmos.data.scanners.Scan;
import eu.ha3.matmos.data.scanners.ScanAir;
import eu.ha3.matmos.data.scanners.ScanRaycast;
import eu.ha3.matmos.data.scanners.ScannerModule;
import eu.ha3.matmos.util.BlockPos;
import eu.ha3.matmos.util.MAtUtil;
import eu.ha3.matmos.util.Vec3d;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ScanRaycast.class})
public abstract class MixinScanRaycast
extends Scan {
    @Shadow
    private static final Random rnd = new Random();
    @Shadow
    int startX;
    @Shadow
    int startY;
    @Shadow
    int startZ;
    @Shadow
    Vec3d center;
    @Shadow
    int xSize;
    @Shadow
    int ySize;
    @Shadow
    int zSize;
    @Shadow
    int startNearness;
    @Shadow
    int maxRange;
    @Shadow
    int raysCast = 0;
    @Shadow
    int raysToCast;
    @Shadow
    int directScore;
    @Shadow
    int indirectScore;
    @Shadow
    int distanceSqSum;
    @Shadow
    private int THRESHOLD_SCORE;
    @Shadow
    private int THRESHOLD_INDIRECT_SCORE;
    @Shadow
    private Vec3d[] rays;
    @Shadow
    private Set<BlockPos> scanned;

    @Overwrite(remap=false)
    void initScan(int x, int y, int z, int xsizeIn, int ysizeIn, int zsizeIn, int opspercallIn) {
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.center = new Vec3d((double)this.startX + 0.5, (double)this.startY + 0.5, (double)this.startZ + 0.5);
        this.xSize = xsizeIn;
        this.ySize = ysizeIn;
        this.zSize = zsizeIn;
        this.raysToCast = this.opspercall * 20;
        this.raysCast = 0;
        this.distanceSqSum = 0;
        if (this.rays == null || this.rays.length != this.raysToCast) {
            rnd.setSeed(1L);
            this.rays = new Vec3d[this.raysToCast];
            for (int i = 0; i < this.raysToCast; ++i) {
                double squareDist;
                double vx = 0.0;
                double vy = 0.0;
                double vz = 0.0;
                while ((squareDist = vx * vx + vy * vy + vz * vz) < 0.01 || squareDist > 1.0) {
                    vx = 2.0 * (rnd.nextDouble() - 0.5);
                    vy = 2.0 * (rnd.nextDouble() - 0.5);
                    vz = 2.0 * (rnd.nextDouble() - 0.5);
                }
                this.rays[i] = new Vec3d(vx, vy, vz).normalize();
            }
        }
        if (this.scanned == null) {
            this.scanned = new HashSet<BlockPos>(this.raysToCast + 1, 1.0f);
        }
        this.finalProgress = 1;
        this.startNearness = 60;
        this.maxRange = 100;
        this.directScore = 0;
        this.indirectScore = 0;
        this.THRESHOLD_SCORE = 10000;
        this.THRESHOLD_INDIRECT_SCORE = 10;
        this.scanned.clear();
    }

    @Shadow
    private Vec3d getRay(int index) {
        return this.rays[index];
    }

    @Overwrite(remap=false)
    private Optional<Vec3d> getNormalVector(MovingObjectPosition result) {
        if (result == null) {
            return Optional.empty();
        }
        switch (result.field_72310_e) {
            case 0: {
                return Optional.of(new Vec3d(0.0, -1.0, 0.0));
            }
            case 1: {
                return Optional.of(new Vec3d(0.0, 1.0, 0.0));
            }
            case 2: {
                return Optional.of(new Vec3d(0.0, 0.0, 1.0));
            }
            case 3: {
                return Optional.of(new Vec3d(0.0, 0.0, -1.0));
            }
            case 4: {
                return Optional.of(new Vec3d(-1.0, 0.0, 0.0));
            }
            case 5: {
                return Optional.of(new Vec3d(1.0, 0.0, 0.0));
            }
        }
        return Optional.empty();
    }

    @Overwrite(remap=false)
    protected boolean doRoutine() {
        int ops = 0;
        while (ops < this.opspercall && this.raysCast < this.raysToCast) {
            this.castRay(this.getRay(this.raysCast));
            ++ops;
            ++this.raysCast;
        }
        if (this.raysCast >= this.raysToCast) {
            this.progress = 1;
            int isOutdoors = this.directScore > this.THRESHOLD_SCORE ? 1 : 0;
            int isNearSurfaceOwn = this.indirectScore > this.THRESHOLD_INDIRECT_SCORE ? 1 : 0;
            this.pipeline.setValue(".is_outdoors", isOutdoors);
            this.pipeline.setValue(".__score", this.directScore);
            this.pipeline.setValue(".__indirect_score", this.indirectScore);
            this.pipeline.setValue("._is_near_surface_own", isNearSurfaceOwn);
            this.pipeline.setValue(".spaciousness", this.distanceSqSum);
        }
        return true;
    }

    @Overwrite(remap=false)
    private int calculateWeight(int dx, int dy, int dz, int maxRange) {
        int distanceSquared = dx * dx + dy * dy + dz * dz;
        float distanceScale = 1.0f;
        float weight = MathHelper.func_76131_a((float)(1.0f / (1.0f + (float)distanceSquared / distanceScale)), (float)0.0f, (float)1.0f);
        return (int)(weight * 1000.0f);
    }

    @Overwrite(remap=false)
    public static MovingObjectPosition rayTraceNonSolid(Vec3d start, Vec3d end) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        MovingObjectPosition result = world.func_147447_a((Vec3)start, (Vec3)end, true, false, true);
        Vec3d delta = end.subtract(start);
        double infNorm = Math.max(Math.abs(delta.field_72450_a), Math.max(Math.abs(delta.field_72448_b), Math.abs(delta.field_72449_c)));
        delta = delta.scale(0.01 / infNorm);
        while (result != null && result.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && ScanAir.isTransparentToSound((Block)MAtUtil.getBlockAt((BlockPos)new BlockPos(result.field_72311_b, result.field_72312_c, result.field_72309_d)), (int)MAtUtil.getMetaAt((BlockPos)new BlockPos(result.field_72307_f), (int)-1), (World)world, (BlockPos)new BlockPos(result.field_72307_f), (boolean)true)) {
            result = world.func_147447_a((Vec3)delta.add(result.field_72307_f), (Vec3)end, true, true, true);
        }
        return result;
    }

    @Overwrite(remap=false)
    private boolean scanNearRayHit(MovingObjectPosition result, int scanDistance, boolean direct) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos hitBlock = new BlockPos(result.field_72311_b, result.field_72312_c, result.field_72309_d);
        this.distanceSqSum = (int)((double)this.distanceSqSum + hitBlock.distanceSq(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c));
        Block[] blockBuf = new Block[1];
        int[] metaBuf = new int[1];
        int[] pos = new int[3];
        boolean centerSolid = false;
        boolean foundSky = false;
        int airPenalty = 0;
        int solidPenalty = 55;
        for (int scanDir = 0; scanDir < 6; ++scanDir) {
            int nearness = this.startNearness;
            for (int offset = 0; offset <= scanDistance; ++offset) {
                boolean solid;
                if (offset == 0 && scanDir != 0) continue;
                int scanAxis = scanDir >= 3 ? scanDir - 3 : scanDir;
                pos[0] = hitBlock.getX();
                pos[1] = hitBlock.getY();
                pos[2] = hitBlock.getZ();
                int n = scanAxis;
                pos[n] = pos[n] + offset * (scanDir >= 3 ? -1 : 1);
                BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
                if (this.scanned.contains(blockPos)) continue;
                this.scanned.add(blockPos);
                int dx = this.startX - pos[0];
                int dy = this.startY - pos[1];
                int dz = this.startZ - pos[2];
                if (direct) {
                    ((ScannerModule)this.pipeline).inputAndReturnBlockMeta(pos[0], pos[1], pos[2], this.calculateWeight(dx, dy, dz, this.maxRange), blockBuf, metaBuf);
                } else {
                    blockBuf[0] = MAtUtil.getBlockAt((BlockPos)blockPos);
                    metaBuf[0] = MAtUtil.getMetaAt((BlockPos)blockPos, (int)-1);
                }
                Block block = blockBuf[0];
                AxisAlignedBB collisionBox = block.func_149668_a((World)world, blockPos.getX(), blockPos.getY(), blockPos.getZ());
                boolean bl = solid = collisionBox != null && !(block instanceof BlockLeaves);
                if (solid && offset == 0 && scanDir == 0) {
                    centerSolid = true;
                } else if (centerSolid && scanDir != 0 && offset == 1) {
                    nearness -= solidPenalty;
                }
                if ((nearness -= solid ? solidPenalty : airPenalty) <= 0 || !(block instanceof BlockAir) || !MAtUtil.canSeeSky((BlockPos)blockPos)) continue;
                if (direct) {
                    this.directScore += nearness;
                } else {
                    ++this.indirectScore;
                }
                foundSky = true;
            }
        }
        return foundSky;
    }

    @Overwrite(remap=false)
    private void castRay(Vec3d dir) {
        Vec3d end = this.center.add((Vec3)dir.scale((double)this.maxRange));
        MovingObjectPosition result = MixinScanRaycast.rayTraceNonSolid(this.center, end);
        if (result != null && result.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Vec3d normal;
            boolean foundSky = this.scanNearRayHit(result, 2, true);
            if (!foundSky && !(normal = this.getNormalVector(result).orElse(Vec3d.ZERO)).equals(Vec3d.ZERO)) {
                Vec3d otherSide = normal.scale(-1.1).add(result.field_72307_f);
                MovingObjectPosition continuedResult = MixinScanRaycast.rayTraceNonSolid(otherSide, end);
                if (continuedResult != null) {
                    this.scanNearRayHit(continuedResult, 1, false);
                } else if (dir.field_72448_b > 0.0) {
                    this.indirectScore += 7;
                }
            }
        } else {
            Vec3d rayEnd;
            BlockPos rayEndBlockPos;
            this.distanceSqSum += this.maxRange * this.maxRange;
            if (dir.field_72448_b > 0.0 && MAtUtil.canSeeSky((BlockPos)(rayEndBlockPos = new BlockPos((Vec3)(rayEnd = this.center.add((Vec3)dir.scale((double)this.maxRange))))))) {
                this.directScore += this.startNearness * 13;
            }
        }
    }
}

