/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.thaumcraft;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.world.WorldGenEldritchRing;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.tiles.TileBanner;
import thaumcraft.common.tiles.TileEldritchAltar;

@Mixin(value={WorldGenEldritchRing.class})
public abstract class MixinWorldGenEldritchRing
extends WorldGenerator {
    @Shadow
    public int chunkX;
    @Shadow
    public int chunkZ;
    @Shadow
    public int width;
    @Shadow
    public int height = 0;

    @Overwrite(remap=false)
    protected Block[] GetValidSpawnBlocks() {
        return new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150403_cj, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150346_d};
    }

    @Overwrite(remap=false)
    public boolean LocationIsValidSpawn(World world, int i, int j, int k) {
        Block checkID;
        int distanceToAir;
        for (distanceToAir = 0; distanceToAir <= 2 && (checkID = world.func_147439_a(i, j + distanceToAir, k)) != Blocks.field_150350_a; ++distanceToAir) {
        }
        if (distanceToAir <= 2) {
            Block[] validSpawnBlocks;
            Block blockID = world.func_147439_a(i, j += distanceToAir - 1, k);
            Block blockIDAbove = world.func_147439_a(i, j + 1, k);
            Block blockIDBelow = world.func_147439_a(i, j - 1, k);
            for (Block x : validSpawnBlocks = this.GetValidSpawnBlocks()) {
                if (blockIDAbove != Blocks.field_150350_a) {
                    return false;
                }
                if (blockID != x && (blockID != Blocks.field_150431_aC && blockID != Blocks.field_150329_H || blockIDBelow != x)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        if (this.LocationIsValidSpawn(world, i - 3, j, k - 3) && this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 3, j, k) && this.LocationIsValidSpawn(world, i + 3, j, k + 3) && this.LocationIsValidSpawn(world, i, j, k + 3) && !MazeHandler.mazesInRange((int)this.chunkX, (int)this.chunkZ, (int)this.width, (int)this.height)) {
            Block replaceBlock = world.func_72807_a((int)i, (int)k).field_76752_A;
            for (int x = i - 3; x <= i + 3; ++x) {
                for (int z = k - 3; z <= k + 3; ++z) {
                    int r;
                    if ((x == i - 3 || x == i + 3) && (z == k - 3 || z == k + 3)) continue;
                    for (r = -4; r < 5; ++r) {
                        Block bb = world.func_147439_a(x, j + r, z);
                        if (r <= 0 || bb.isReplaceable((IBlockAccess)world, x, j + r, z) || !bb.func_149688_o().func_76230_c() || bb.isFoliage((IBlockAccess)world, x, j + r, z)) {
                            if (rand.nextInt(4) == 0) {
                                world.func_147449_b(x, j + r, z, Blocks.field_150343_Z);
                            } else {
                                world.func_147465_d(x, j + r, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                            }
                        }
                        if (r <= 0) continue;
                        world.func_147468_f(x, j + r, z);
                    }
                    if (x == i && z == k) {
                        world.func_147465_d(x, j + 1, z, ConfigBlocks.blockEldritch, 0, 3);
                        world.func_147465_d(x, j, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                        r = rand.nextInt(10);
                        TileEntity te = world.func_147438_o(x, j + 1, z);
                        if (te != null && te instanceof TileEldritchAltar) {
                            switch (r) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    ((TileEldritchAltar)te).setSpawner(true);
                                    ((TileEldritchAltar)te).setSpawnType((byte)0);
                                    for (int a = 2; a < 6; ++a) {
                                        ForgeDirection dir = ForgeDirection.getOrientation((int)a);
                                        world.func_147465_d(x - dir.offsetX * 3, j + 1, z + dir.offsetZ * 3, ConfigBlocks.blockWoodenDevice, 8, 3);
                                        te = world.func_147438_o(x - dir.offsetX * 3, j + 1, z + dir.offsetZ * 3);
                                        if (te == null || !(te instanceof TileBanner)) continue;
                                        int face = 0;
                                        switch (a) {
                                            case 2: {
                                                face = 8;
                                                break;
                                            }
                                            case 3: {
                                                face = 0;
                                                break;
                                            }
                                            case 4: {
                                                face = 12;
                                                break;
                                            }
                                            case 5: {
                                                face = 4;
                                            }
                                        }
                                        ((TileBanner)te).setFacing((byte)face);
                                    }
                                }
                                default: {
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    ((TileEldritchAltar)te).setSpawner(true);
                                    ((TileEldritchAltar)te).setSpawnType((byte)1);
                                }
                            }
                        }
                        world.func_147465_d(x, j + 3, z, ConfigBlocks.blockEldritch, 1, 3);
                        world.func_147465_d(x, j + 4, z, ConfigBlocks.blockEldritch, 2, 3);
                        world.func_147465_d(x, j + 5, z, ConfigBlocks.blockEldritch, 2, 3);
                        world.func_147465_d(x, j + 6, z, ConfigBlocks.blockEldritch, 2, 3);
                        world.func_147465_d(x, j + 7, z, ConfigBlocks.blockEldritch, 2, 3);
                        continue;
                    }
                    if ((x != i - 3 && x != i + 3 || Math.abs((z - k) % 2) != 1) && (z != k - 3 && z != k + 3 || Math.abs((x - i) % 2) != 1) || Math.abs(x - i) == Math.abs(z - k)) continue;
                    world.func_147465_d(x, j, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                    world.func_147465_d(x, j + 1, z, ConfigBlocks.blockEldritch, 3, 3);
                }
            }
            return true;
        }
        return false;
    }
}

