/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.thaumcraft;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.world.WorldGenGreatwoodTrees;

@Mixin(value={WorldGenGreatwoodTrees.class})
public abstract class MixinWorldGenGreatwoodTrees
extends WorldGenAbstractTree {
    @Shadow
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    @Shadow
    Random rand = new Random();
    @Shadow
    World worldObj;
    @Shadow
    int[] basePos = new int[]{0, 0, 0};
    @Shadow
    int heightLimit = 0;
    @Shadow
    int height;
    @Shadow
    double heightAttenuation = 0.618;
    @Shadow
    double branchDensity = 1.0;
    @Shadow
    double branchSlope = 0.38;
    @Shadow
    double scaleWidth = 1.2;
    @Shadow
    double leafDensity = 0.9;
    @Shadow
    int trunkSize = 2;
    @Shadow
    int heightLimitLimit = 11;
    @Shadow
    int leafDistanceLimit = 4;
    @Shadow
    int[][] leafNodes;

    public MixinWorldGenGreatwoodTrees(boolean par1) {
        super(par1);
    }

    @Overwrite(remap=false)
    public int checkBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger) {
        byte var5;
        int[] var3 = this.optimizationsAndTweaks$initializeArray();
        if (var3[var5 = this.optimizationsAndTweaks$findLargestDifference(par1ArrayOfInteger, par2ArrayOfInteger, var3)] == 0) {
            return -1;
        }
        return this.optimizationsAndTweaks$checkBlocksAlongLine(par1ArrayOfInteger, var3, var5);
    }

    @Unique
    private int[] optimizationsAndTweaks$initializeArray() {
        return new int[]{0, 0, 0};
    }

    @Unique
    private int optimizationsAndTweaks$checkBlocksAlongLine(int[] par1, int[] var3, byte var5) {
        int var14;
        byte var6 = otherCoordPairs[var5];
        byte var7 = otherCoordPairs[var5 + 3];
        byte var8 = (byte)(var3[var5] > 0 ? 1 : -1);
        double var9 = (double)var3[var6] / (double)var3[var5];
        double var11 = (double)var3[var7] / (double)var3[var5];
        int[] var13 = new int[]{0, 0, 0};
        int var15 = var3[var5] + var8;
        for (var14 = 0; var14 != var15; var14 += var8) {
            var13[var5] = par1[var5] + var14;
            var13[var6] = MathHelper.func_76128_c((double)((double)par1[var6] + (double)var14 * var9));
            var13[var7] = MathHelper.func_76128_c((double)((double)par1[var7] + (double)var14 * var11));
            if (!this.optimizationsAndTweaks$checkBlockAtPosition(var13)) break;
        }
        return var14 == var15 ? -1 : Math.abs(var14);
    }

    @Unique
    private boolean optimizationsAndTweaks$checkBlockAtPosition(int[] position) {
        int x = position[0];
        int y = position[1];
        int z = position[2];
        if (y >= 0 && y < 256) {
            Chunk chunk = this.worldObj.func_72938_d(x, z);
            Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
            return block != null && (block.isAir((IBlockAccess)this.worldObj, x, y, z) || block == ConfigBlocks.blockMagicalLeaves);
        }
        return false;
    }

    @Overwrite(remap=false)
    public void generateLeafNodeList() {
        int var1;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((var1 = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            var1 = 1;
        }
        int[][] var2 = new int[var1 * this.heightLimit][4];
        int var3 = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int var4 = 1;
        int var5 = this.basePos[1] + this.height;
        int var6 = var3 - this.basePos[1];
        var2[0][0] = this.basePos[0];
        var2[0][1] = var3--;
        var2[0][2] = this.basePos[2];
        var2[0][3] = var5;
        while (var6 >= 0) {
            float var8 = this.layerSize(var6);
            if (!(var8 < 0.0f)) {
                double var9 = 0.5;
                for (int var7 = 0; var7 < var1; ++var7) {
                    int[] var18;
                    int var16;
                    double var13;
                    double var11 = this.scaleWidth * (double)var8 * ((double)this.rand.nextFloat() + 0.328);
                    int var15 = MathHelper.func_76128_c((double)(var11 * Math.sin(var13 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + var9));
                    int[] var17 = new int[]{var15, var3, var16 = MathHelper.func_76128_c((double)(var11 * Math.cos(var13) + (double)this.basePos[2] + var9))};
                    if (this.checkBlockLine(var17, var18 = new int[]{var15, var3 + this.leafDistanceLimit, var16}) != -1) continue;
                    int[] var19 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                    double var20 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - var17[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - var17[2]), 2.0));
                    double var22 = var20 * this.branchSlope;
                    var19[1] = (double)var17[1] - var22 > (double)var5 ? var5 : (int)((double)var17[1] - var22);
                    if (this.checkBlockLine(var19, var17) != -1) continue;
                    var2[var4][0] = var15;
                    var2[var4][1] = var3;
                    var2[var4][2] = var16;
                    var2[var4][3] = var19[1];
                    ++var4;
                }
            }
            --var3;
            --var6;
        }
        this.leafNodes = new int[var4][4];
        System.arraycopy(var2, 0, this.leafNodes, 0, var4);
    }

    @Overwrite(remap=false)
    public boolean generate(World par1World, Random par2Random, int par3, int par4, int par5, boolean spiders) {
        int a;
        int chunkX = par3 >> 4;
        int chunkZ = par5 >> 4;
        Chunk chunk = par1World.func_72964_e(chunkX, chunkZ);
        if (!chunk.field_76636_d) {
            return false;
        }
        this.worldObj = par1World;
        long var6 = par2Random.nextLong();
        this.rand.setSeed(var6);
        this.basePos[0] = par3;
        this.basePos[1] = par4;
        this.basePos[2] = par5;
        if (this.heightLimit == 0) {
            this.heightLimit = this.heightLimitLimit + this.rand.nextInt(this.heightLimitLimit);
        }
        boolean valid = false;
        block0: for (a = -1; a < 2; ++a) {
            block1: for (a = -1; a < 2; ++a) {
                for (int x = 0; x < this.trunkSize; ++x) {
                    for (int z = 0; z < this.trunkSize; ++z) {
                        if (!this.validTreeLocation(x + a, z + a)) continue block1;
                    }
                }
                valid = true;
                this.basePos[0] = this.basePos[0] + a;
                this.basePos[2] = this.basePos[2] + a;
                break block0;
            }
        }
        if (!valid) {
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.generateTrunk();
        this.scaleWidth = 1.66;
        this.basePos[0] = par3;
        this.basePos[1] = par4 + this.height;
        this.basePos[2] = par5;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.generateTrunk();
        if (spiders) {
            this.worldObj.func_147465_d(par3, par4 - 1, par5, Blocks.field_150474_ac, 0, 3);
            TileEntityMobSpawner var14 = (TileEntityMobSpawner)par1World.func_147438_o(par3, par4 - 1, par5);
            if (var14 != null) {
                var14.func_145881_a().func_98272_a("CaveSpider");
                for (a = 0; a < 50; ++a) {
                    int zz;
                    int yy;
                    int xx = par3 - 7 + par2Random.nextInt(14);
                    if (!par1World.func_147437_c(xx, yy = par4 + par2Random.nextInt(10), zz = par5 - 7 + par2Random.nextInt(14)) || !BlockUtils.isBlockTouching((IBlockAccess)par1World, (int)xx, (int)yy, (int)zz, (Block)ConfigBlocks.blockMagicalLeaves) && !BlockUtils.isBlockTouching((IBlockAccess)par1World, (int)xx, (int)yy, (int)zz, (Block)ConfigBlocks.blockMagicalLog)) continue;
                    this.worldObj.func_147465_d(xx, yy, zz, Blocks.field_150321_G, 0, 3);
                }
                par1World.func_147465_d(par3, par4 - 2, par5, (Block)Blocks.field_150486_ae, 0, 3);
                TileEntityChest var16 = (TileEntityChest)par1World.func_147438_o(par3, par4 - 2, par5);
                if (var16 != null) {
                    ChestGenHooks loot = ChestGenHooks.getInfo((String)"dungeonChest");
                    WeightedRandomChestContent.func_76293_a((Random)this.rand, (WeightedRandomChestContent[])loot.getItems(this.rand), (IInventory)var16, (int)loot.getCount(this.rand));
                }
            }
        }
        return true;
    }

    @Overwrite(remap=false)
    float layerSize(int par1) {
        if ((double)par1 < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float var2 = (float)this.heightLimit / 2.0f;
        float var3 = (float)this.heightLimit / 2.0f - (float)par1;
        float var4 = var3 == 0.0f ? var2 : (Math.abs(var3) >= var2 ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(var2), 2.0) - Math.pow(Math.abs(var3), 2.0)));
        return var4 *= 0.5f;
    }

    @Shadow
    boolean validTreeLocation(int x, int z) {
        int[] var1 = new int[]{this.basePos[0] + x, this.basePos[1], this.basePos[2] + z};
        int[] var2 = new int[]{this.basePos[0] + x, this.basePos[1] + this.heightLimit - 1, this.basePos[2] + z};
        try {
            Block var3 = this.worldObj.func_147439_a(this.basePos[0] + x, this.basePos[1] - 1, this.basePos[2] + z);
            boolean isSoil = var3.canSustainPlant((IBlockAccess)this.worldObj, this.basePos[0] + x, this.basePos[1] - 1, this.basePos[2] + z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (!isSoil) {
                return false;
            }
            int var4 = this.checkBlockLine(var1, var2);
            if (var4 == -1) {
                return true;
            }
            if (var4 < 6) {
                return false;
            }
            this.heightLimit = var4;
            return true;
        }
        catch (Exception var8) {
            return false;
        }
    }

    @Shadow
    void generateLeaves() {
        int var2 = this.leafNodes.length;
        for (int var1 = 0; var1 < var2; ++var1) {
            int var3 = this.leafNodes[var1][0];
            int var4 = this.leafNodes[var1][1];
            int var5 = this.leafNodes[var1][2];
            this.generateLeafNode(var3, var4, var5);
        }
    }

    @Shadow
    void generateLeafNode(int par1, int par2, int par3) {
        int var5 = par2 + this.leafDistanceLimit;
        for (int var4 = par2; var4 < var5; ++var4) {
            float var6 = this.leafSize(var4 - par2);
            this.genTreeLayer(par1, var4, par3, var6, (byte)1, ConfigBlocks.blockMagicalLeaves);
        }
    }

    @Shadow
    float leafSize(int par1) {
        return par1 >= 0 && par1 < this.leafDistanceLimit ? (par1 != 0 && par1 != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    @Overwrite(remap=false)
    void genTreeLayer(int par1, int par2, int par3, float par4, byte par5, Block par6) {
        int chunkX = par1 >> 4;
        int chunkZ = par3 >> 4;
        Chunk chunk = this.worldObj.func_72964_e(chunkX, chunkZ);
        if (!chunk.field_76636_d) {
            return;
        }
        int var7 = (int)((double)par4 + 0.618);
        byte var8 = otherCoordPairs[par5];
        byte var9 = otherCoordPairs[par5 + 3];
        int[] var10 = new int[]{par1, par2, par3};
        int[] var11 = new int[]{0, 0, 0};
        var11[par5] = var10[par5];
        for (int var12 = -var7; var12 <= var7; ++var12) {
            var11[var8] = var10[var8] + var12;
            for (int var13 = -var7; var13 <= var7; ++var13) {
                double var15 = Math.pow((double)Math.abs(var12) + 0.5, 2.0) + Math.pow((double)Math.abs(var13) + 0.5, 2.0);
                if (!(var15 <= (double)(par4 * par4))) continue;
                try {
                    var11[var9] = var10[var9] + var13;
                    Block block = this.worldObj.func_147439_a(var11[0], var11[1], var11[2]);
                    if (block != Blocks.field_150350_a && block != ConfigBlocks.blockMagicalLeaves || block != null && !block.canBeReplacedByLeaves((IBlockAccess)this.worldObj, var11[0], var11[1], var11[2])) continue;
                    this.func_150516_a(this.worldObj, var11[0], var11[1], var11[2], par6, 0);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Shadow
    void generateLeafNodeBases() {
        int var2 = this.leafNodes.length;
        int[] var3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int var1 = 0; var1 < var2; ++var1) {
            int[] var4 = this.leafNodes[var1];
            int[] var5 = new int[]{var4[0], var4[1], var4[2]};
            var3[1] = var4[3];
            int var6 = var3[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(var6)) continue;
            this.placeBlockLine(var3, var5, ConfigBlocks.blockMagicalLog);
        }
    }

    @Overwrite(remap=false)
    boolean leafNodeNeedsBase(int par1) {
        return (double)par1 >= (double)this.heightLimit * 0.2;
    }

    @Overwrite(remap=false)
    void placeBlockLine(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger, Block par3) {
        int[] var4 = new int[]{0, 0, 0};
        byte var6 = this.optimizationsAndTweaks$findLargestDifference(par1ArrayOfInteger, par2ArrayOfInteger, var4);
        if (var4[var6] != 0) {
            byte var7 = otherCoordPairs[var6];
            byte var8 = otherCoordPairs[var6 + 3];
            byte var9 = (byte)(var4[var6] > 0 ? 1 : -1);
            double var10 = (double)var4[var7] / (double)var4[var6];
            double var12 = (double)var4[var8] / (double)var4[var6];
            int[] var14 = new int[]{0, 0, 0};
            int var16 = var4[var6] + var9;
            for (int var15 = 0; var15 != var16; var15 += var9) {
                var14[var6] = MathHelper.func_76128_c((double)((double)(par1ArrayOfInteger[var6] + var15) + 0.5));
                var14[var7] = MathHelper.func_76128_c((double)((double)par1ArrayOfInteger[var7] + (double)var15 * var10 + 0.5));
                var14[var8] = MathHelper.func_76128_c((double)((double)par1ArrayOfInteger[var8] + (double)var15 * var12 + 0.5));
                byte var17 = this.optimizationsAndTweaks$calculateDirection(var14, par1ArrayOfInteger);
                this.func_150516_a(this.worldObj, var14[0], var14[1], var14[2], par3, var17);
            }
        }
    }

    @Unique
    byte optimizationsAndTweaks$findLargestDifference(int[] par1ArrayOfInteger, int[] par2ArrayOfInteger, int[] var4) {
        int var6 = 0;
        for (int var5 = 0; var5 < 3; var5 = (int)((byte)(var5 + 1))) {
            var4[var5] = par2ArrayOfInteger[var5] - par1ArrayOfInteger[var5];
            if (Math.abs(var4[var5]) <= Math.abs(var4[var6])) continue;
            var6 = var5;
        }
        return (byte)var6;
    }

    @Unique
    byte optimizationsAndTweaks$calculateDirection(int[] var14, int[] par1ArrayOfInteger) {
        int var19;
        int var17 = 0;
        int var18 = Math.abs(var14[0] - par1ArrayOfInteger[0]);
        int var20 = Math.max(var18, var19 = Math.abs(var14[2] - par1ArrayOfInteger[2]));
        if (var20 > 0) {
            if (var18 == var20) {
                var17 = 4;
            } else if (var19 == var20) {
                var17 = 8;
            }
        }
        return (byte)var17;
    }

    @Shadow
    void generateTrunk() {
        int var1 = this.basePos[0];
        int var2 = this.basePos[1];
        int var3 = this.basePos[1] + this.height;
        int var4 = this.basePos[2];
        int[] var5 = new int[]{var1, var2, var4};
        int[] var6 = new int[]{var1, var3, var4};
        this.placeBlockLine(var5, var6, ConfigBlocks.blockMagicalLog);
        if (this.trunkSize == 2) {
            int n = var5[0];
            var5[0] = n + 1;
            int var10002 = n;
            int n2 = var6[0];
            var6[0] = n2 + 1;
            var10002 = n2;
            this.placeBlockLine(var5, var6, ConfigBlocks.blockMagicalLog);
            int n3 = var5[2];
            var5[2] = n3 + 1;
            var10002 = n3;
            int n4 = var6[2];
            var6[2] = n4 + 1;
            var10002 = n4;
            this.placeBlockLine(var5, var6, ConfigBlocks.blockMagicalLog);
            var5[0] = var5[0] + -1;
            var6[0] = var6[0] + -1;
            this.placeBlockLine(var5, var6, ConfigBlocks.blockMagicalLog);
        }
    }
}

