/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.org.pcollections;

import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.AbstractUnmodifiableMap;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.AbstractUnmodifiableSet;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.Empty;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.PMap;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.PSortedMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OrderedPMap<K, V>
extends AbstractUnmodifiableMap<K, V>
implements PMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final OrderedPMap<Object, Object> EMPTY = new OrderedPMap(Empty.map(), Empty.sortedMap());
    private final PMap<K, Long> ids;
    private final PSortedMap<Long, Map.Entry<K, V>> entries;

    public static <K, V> OrderedPMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> OrderedPMap<K, V> from(Map<? extends K, ? extends V> map) {
        if (map instanceof OrderedPMap) {
            return (OrderedPMap)map;
        }
        return OrderedPMap.empty().plusAll((Map)map);
    }

    public static <K, V> OrderedPMap<K, V> singleton(K k, V v) {
        return OrderedPMap.empty().plus((Object)k, (Object)v);
    }

    private OrderedPMap(PMap<K, Long> ids, PSortedMap<Long, Map.Entry<K, V>> entries) {
        this.ids = ids;
        this.entries = entries;
    }

    @Override
    public V get(Object k) {
        Long id = (Long)this.ids.get(k);
        if (id == null) {
            return null;
        }
        return ((Map.Entry)this.entries.get(id)).getValue();
    }

    @Override
    public OrderedPMap<K, V> plus(K k, V v) {
        PMap<K, Long> newIds;
        Long id = (Long)this.ids.get(k);
        if (id == null) {
            id = this.entries.isEmpty() ? Long.MIN_VALUE : (Long)this.entries.lastKey() + 1L;
            newIds = this.ids.plus(k, id);
        } else {
            newIds = this.ids;
        }
        return new OrderedPMap<K, V>(newIds, this.entries.plus((Object)id, new AbstractMap.SimpleImmutableEntry<K, V>(k, v)));
    }

    @Override
    public OrderedPMap<K, V> plusAll(Map<? extends K, ? extends V> map) {
        PMap<K, V> m = this;
        for (Map.Entry<K, V> e : map.entrySet()) {
            m = m.plus((Object)e.getKey(), (Object)e.getValue());
        }
        return m;
    }

    @Override
    public OrderedPMap<K, V> minus(Object k) {
        Long id = (Long)this.ids.get(k);
        if (id == null) {
            return this;
        }
        return new OrderedPMap<K, V>(this.ids.minus(k), this.entries.minus(id));
    }

    @Override
    public OrderedPMap<K, V> minusAll(Collection<?> keys) {
        PMap<K, V> m = this;
        for (Object k : keys) {
            m = m.minus(k);
        }
        return m;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractUnmodifiableSet<Map.Entry<K, V>>(){

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object k = e.getKey();
                if (!OrderedPMap.this.containsKey(k)) {
                    return false;
                }
                return Objects.equals(OrderedPMap.this.get(k), e.getValue());
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return OrderedPMap.this.entries.values().iterator();
            }

            @Override
            public int size() {
                return OrderedPMap.this.ids.size();
            }
        };
    }

    @Override
    public int size() {
        return this.ids.size();
    }
}

