/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.eventshandler;

import com.falsepattern.lib.compat.ChunkPos;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.Object2ObjectHashMap;
import fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.tidychunkbackport.TidyChunkBackportWorldContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class TidyChunkBackportEventHandler {
    public static final Object2ObjectHashMap<Integer, TidyChunkBackportWorldContext> worldData = new Object2ObjectHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldUnload(WorldEvent.Unload evt) {
        World w = evt.world;
        if (!w.field_72995_K) {
            TidyChunkBackportEventHandler.getWorldContext(w).searchAndDestroy(w);
            worldData.remove(w.field_73011_w.field_76574_g);
        }
    }

    @SubscribeEvent
    public void onChunkPopulate(PopulateChunkEvent.Pre evt) {
        TidyChunkBackportWorldContext ctx = TidyChunkBackportEventHandler.getWorldContext(evt.world);
        ChunkPos pos = new ChunkPos(evt.chunkX, evt.chunkZ);
        ctx.add(pos, evt.world);
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent evt) {
        Entity entity = evt.entity;
        World world = entity.field_70170_p;
        if (world == null || world.field_72995_K || !TidyChunkBackportWorldContext.isTargetEntity(entity)) {
            return;
        }
        EntityItem itemEntity = (EntityItem)entity;
        TidyChunkBackportWorldContext ctx = TidyChunkBackportEventHandler.getWorldContext(world);
        if (ctx.isContained((Entity)itemEntity)) {
            ctx.removeEntity(entity, world);
            evt.setCanceled(true);
        }
    }

    private static TidyChunkBackportWorldContext createWorldContext(World w) {
        TidyChunkBackportWorldContext ctx = new TidyChunkBackportWorldContext();
        worldData.put(w.field_73011_w.field_76574_g, ctx);
        return ctx;
    }

    private static TidyChunkBackportWorldContext getWorldContext(World w) {
        return worldData.computeIfAbsent(w.field_73011_w.field_76574_g, k -> TidyChunkBackportEventHandler.createWorldContext(w));
    }

    public static void injectInWorldTick(World world) {
        TidyChunkBackportWorldContext ctx = TidyChunkBackportEventHandler.getWorldContext(world);
        if (ctx != null) {
            ctx.searchAndDestroy(world);
            ctx.removeOldContext(world);
        }
    }
}

