/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.client.core;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FontRenderer.class})
public class MixinFontRenderer {
    @Shadow
    public int field_78288_b = 9;
    @Shadow
    public Random field_78289_c = new Random();
    @Shadow
    private int field_78304_r;
    @Shadow
    private boolean field_78293_l;
    @Shadow
    private boolean field_78294_m;
    @Shadow
    private float field_78291_n;
    @Shadow
    private float field_78292_o;
    @Shadow
    private float field_78306_p;
    @Shadow
    private float field_78305_q;
    @Shadow
    private boolean field_78303_s;
    @Shadow
    private boolean field_78302_t;
    @Shadow
    private boolean field_78301_u;
    @Shadow
    private boolean field_78300_v;
    @Shadow
    private boolean field_78299_w;
    @Shadow
    private static final ResourceLocation[] field_111274_c = new ResourceLocation[256];
    @Shadow
    protected int[] field_78286_d = new int[256];
    @Shadow
    private final TextureManager field_78298_i;
    @Shadow
    private int[] field_78285_g = new int[32];
    @Shadow
    protected final ResourceLocation field_111273_g;
    @Shadow
    protected float field_78295_j;
    @Shadow
    protected float field_78296_k;
    @Shadow
    protected byte[] field_78287_e = new byte[65536];
    @Unique
    private static final String SPECIAL_CHARACTERS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    @Unique
    private static final Set<Character> SPECIAL_CHARACTERS_SET = new HashSet<Character>();

    public MixinFontRenderer(TextureManager p_i1035_3_, ResourceLocation p_i1035_2_) {
        this.field_111273_g = p_i1035_2_;
        this.field_78298_i = p_i1035_3_;
    }

    @Unique
    public float renderCharAtPos(int p_78278_1_, char p_78278_2_, boolean p_78278_3_) {
        if (p_78278_2_ == ' ') {
            return 4.0f;
        }
        boolean isSpecialCharacter = SPECIAL_CHARACTERS_SET.contains(Character.valueOf(p_78278_2_)) && !this.field_78293_l;
        return isSpecialCharacter ? this.renderDefaultChar(p_78278_1_, p_78278_3_) : this.renderUnicodeChar(p_78278_2_, p_78278_3_);
    }

    @Unique
    public float renderDefaultChar(int p_78266_1_, boolean p_78266_2_) {
        float f = p_78266_1_ % 16 * 8;
        float f1 = p_78266_1_ / 16 * 8;
        float f2 = p_78266_2_ ? 1.0f : 0.0f;
        float f3 = (float)this.field_78286_d[p_78266_1_] - 0.01f;
        float[] texCoords = new float[]{f / 128.0f, f1 / 128.0f, f / 128.0f, (f1 + 7.99f) / 128.0f, (f + f3 - 1.0f) / 128.0f, f1 / 128.0f, (f + f3 - 1.0f) / 128.0f, (f1 + 7.99f) / 128.0f};
        float[] vertices = new float[]{this.field_78295_j + f2, this.field_78296_k, 0.0f, this.field_78295_j - f2, this.field_78296_k + 7.99f, 0.0f, this.field_78295_j + f3 - 1.0f + f2, this.field_78296_k, 0.0f, this.field_78295_j + f3 - 1.0f - f2, this.field_78296_k + 7.99f, 0.0f};
        this.bindTexture(this.field_111273_g);
        GL11.glBegin((int)5);
        for (int i = 0; i < 4; ++i) {
            GL11.glTexCoord2f((float)texCoords[i * 2], (float)texCoords[i * 2 + 1]);
            GL11.glVertex3f((float)vertices[i * 3], (float)vertices[i * 3 + 1], (float)vertices[i * 3 + 2]);
        }
        GL11.glEnd();
        return this.field_78286_d[p_78266_1_];
    }

    @Unique
    public float renderUnicodeChar(char p_78277_1_, boolean p_78277_2_) {
        if (this.field_78287_e[p_78277_1_] == 0) {
            return 0.0f;
        }
        int i = p_78277_1_ / 256;
        this.func_78257_a(i);
        int j = this.field_78287_e[p_78277_1_] >>> 4;
        int k = this.field_78287_e[p_78277_1_] & 0xF;
        float f1 = k + 1;
        float f2 = (float)(p_78277_1_ % 16 * 16) + (float)j;
        float f3 = (float)(p_78277_1_ & 0xFF) / 16.0f * 16.0f;
        float f4 = f1 - (float)j - 0.02f;
        float f5 = p_78277_2_ ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f5), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j - f5), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 / 2.0f + f5), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 / 2.0f - f5), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f1 - (float)j) / 2.0f + 1.0f;
    }

    @Shadow
    protected void bindTexture(ResourceLocation location) {
        this.field_78298_i.func_110577_a(location);
    }

    @Shadow
    private void func_78257_a(int p_78257_1_) {
        this.bindTexture(this.getUnicodePageLocation(p_78257_1_));
    }

    @Unique
    public ResourceLocation getUnicodePageLocation(int p_111271_1_) {
        if (field_111274_c[p_111271_1_] == null) {
            MixinFontRenderer.field_111274_c[p_111271_1_] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", p_111271_1_));
        }
        return field_111274_c[p_111271_1_];
    }

    public int drawStringWithShadow(String text, int x, int y, int color) {
        return this.drawString(text, x, y, color, true);
    }

    public int drawString(String text, int x, int y, int color) {
        return this.drawString(text, x, y, color, false);
    }

    public int drawString(String text, int x, int y, int color, boolean dropShadow) {
        int l;
        this.enableAlpha();
        this.func_78265_b();
        if (dropShadow) {
            l = this.renderString(text, x + 1, y + 1, color, true);
            l = Math.max(l, this.renderString(text, x, y, color, false));
        } else {
            l = this.renderString(text, x, y, color, false);
        }
        return l;
    }

    @Overwrite
    public int func_78263_a(char p_78263_1_) {
        if (p_78263_1_ == '\u00a7') {
            return -1;
        }
        if (p_78263_1_ == ' ') {
            return 4;
        }
        int i = SPECIAL_CHARACTERS.indexOf(p_78263_1_);
        if (p_78263_1_ > '\u0000' && i != -1 && !this.field_78293_l) {
            return this.field_78286_d[i];
        }
        if (this.field_78287_e[p_78263_1_] != 0) {
            int j = this.field_78287_e[p_78263_1_] >>> 4;
            int k = this.field_78287_e[p_78263_1_] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            return (++k - j) / 2 + 1;
        }
        return 0;
    }

    @Overwrite
    public int func_78256_a(String p_78256_1_) {
        if (p_78256_1_ == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < p_78256_1_.length(); ++j) {
            char c0 = p_78256_1_.charAt(j);
            int k = this.func_78263_a(c0);
            if (k < 0 && j < p_78256_1_.length() - 1) {
                if ((c0 = p_78256_1_.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag || k <= 0) continue;
            ++i;
        }
        return i;
    }

    @Unique
    private int renderStringAligned(String p_78274_1_, int p_78274_2_, int p_78274_3_, int p_78274_4_, int p_78274_5_, boolean p_78274_6_) {
        if (this.field_78294_m) {
            int i1 = this.func_78256_a(this.func_147647_b(p_78274_1_));
            p_78274_2_ = p_78274_2_ + p_78274_4_ - i1;
        }
        return this.renderString(p_78274_1_, p_78274_2_, p_78274_3_, p_78274_5_, p_78274_6_);
    }

    @Unique
    public int renderString(String p_78258_1_, int p_78258_2_, int p_78258_3_, int p_78258_4_, boolean p_78258_5_) {
        if (p_78258_1_ == null) {
            return 0;
        }
        if (this.field_78294_m) {
            p_78258_1_ = this.func_147647_b(p_78258_1_);
        }
        if ((p_78258_4_ & 0xFC000000) == 0) {
            p_78258_4_ |= 0xFF000000;
        }
        if (p_78258_5_) {
            p_78258_4_ = (p_78258_4_ & 0xFCFCFC) >> 2 | p_78258_4_ & 0xFF000000;
        }
        this.field_78291_n = (float)(p_78258_4_ >> 16 & 0xFF) / 255.0f;
        this.field_78292_o = (float)(p_78258_4_ >> 8 & 0xFF) / 255.0f;
        this.field_78306_p = (float)(p_78258_4_ & 0xFF) / 255.0f;
        this.field_78305_q = (float)(p_78258_4_ >> 24 & 0xFF) / 255.0f;
        this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
        this.field_78295_j = p_78258_2_;
        this.field_78296_k = p_78258_3_;
        this.renderStringAtPos(p_78258_1_, p_78258_5_);
        return (int)this.field_78295_j;
    }

    @Unique
    public void renderStringAtPos(String p_78255_1_, boolean p_78255_2_) {
        for (int i = 0; i < p_78255_1_.length(); ++i) {
            boolean flag1;
            int k;
            int j;
            char c0 = p_78255_1_.charAt(i);
            if (c0 == '\u00a7' && i + 1 < p_78255_1_.length()) {
                j = "0123456789abcdefklmnor".indexOf(p_78255_1_.toLowerCase().charAt(i + 1));
                if (j < 16) {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    if (j < 0) {
                        j = 15;
                    }
                    if (p_78255_2_) {
                        j += 16;
                    }
                    this.field_78304_r = k = this.field_78285_g[j];
                    this.setColor((float)(k >> 16) / 255.0f, (float)(k >> 8 & 0xFF) / 255.0f, (float)(k & 0xFF) / 255.0f, this.field_78305_q);
                } else if (j == 16) {
                    this.field_78303_s = true;
                } else if (j == 17) {
                    this.field_78302_t = true;
                } else if (j == 18) {
                    this.field_78299_w = true;
                } else if (j == 19) {
                    this.field_78300_v = true;
                } else if (j == 20) {
                    this.field_78301_u = true;
                } else {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
                }
                ++i;
                continue;
            }
            j = SPECIAL_CHARACTERS.indexOf(c0);
            if (this.field_78303_s && j != -1) {
                while (this.field_78286_d[j] != this.field_78286_d[k = this.field_78289_c.nextInt(this.field_78286_d.length)]) {
                }
                j = k;
            }
            float f1 = this.field_78293_l ? 0.5f : 1.0f;
            boolean bl = flag1 = (c0 == '\u0000' || j == -1 || this.field_78293_l) && p_78255_2_;
            if (flag1) {
                this.field_78295_j -= f1;
                this.field_78296_k -= f1;
            }
            float f = this.renderCharAtPos(j, c0, this.field_78301_u);
            if (flag1) {
                this.field_78295_j += f1;
                this.field_78296_k += f1;
            }
            if (this.field_78302_t) {
                this.field_78295_j += f1;
                if (flag1) {
                    this.field_78295_j -= f1;
                    this.field_78296_k -= f1;
                }
                this.renderCharAtPos(j, c0, this.field_78301_u);
                this.field_78295_j -= f1;
                if (flag1) {
                    this.field_78295_j += f1;
                    this.field_78296_k += f1;
                }
                f += 1.0f;
            }
            this.doDraw(f);
        }
    }

    @Overwrite(remap=false)
    public void doDraw(float f) {
        Tessellator tessellator;
        if (this.field_78299_w) {
            tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78377_a((double)this.field_78295_j, (double)this.field_78296_k + (double)this.field_78288_b / 2.0, 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)this.field_78296_k + (double)this.field_78288_b / 2.0, 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)this.field_78296_k + (double)this.field_78288_b / 2.0 - 1.0, 0.0);
            tessellator.func_78377_a((double)this.field_78295_j, (double)this.field_78296_k + (double)this.field_78288_b / 2.0 - 1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        if (this.field_78300_v) {
            tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int l = this.field_78300_v ? -1 : 0;
            tessellator.func_78377_a((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0);
            tessellator.func_78377_a((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        this.field_78295_j += (float)((int)f);
    }

    @Overwrite
    public String func_147647_b(String p_147647_1_) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(p_147647_1_), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicshapingexception) {
            return p_147647_1_;
        }
    }

    @Shadow
    protected void enableAlpha() {
        GL11.glEnable((int)3008);
    }

    @Shadow
    private void func_78265_b() {
        this.field_78303_s = false;
        this.field_78302_t = false;
        this.field_78301_u = false;
        this.field_78300_v = false;
        this.field_78299_w = false;
    }

    @Shadow
    protected void setColor(float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    static {
        for (char c : SPECIAL_CHARACTERS.toCharArray()) {
            SPECIAL_CHARACTERS_SET.add(Character.valueOf(c));
        }
    }
}

