/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.client.davincivessels;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.archimedes.ArchimedesShipMod;
import darkevilmac.archimedes.client.control.ShipKeyHandler;
import darkevilmac.archimedes.common.ArchimedesConfig;
import darkevilmac.archimedes.common.entity.EntityShip;
import darkevilmac.archimedes.common.network.ArchimedesShipsMessage;
import darkevilmac.archimedes.common.network.ClientOpenGuiMessage;
import darkevilmac.movingworld.MovingWorld;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.network.MovingWorldClientActionMessage;
import darkevilmac.movingworld.common.network.MovingWorldMessage;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@SideOnly(value=Side.CLIENT)
@Mixin(value={ShipKeyHandler.class})
public class MixinShipKeyHandler {
    @Shadow
    private ArchimedesConfig config;
    @Shadow
    private boolean kbShipGuiPrevState;
    @Shadow
    private boolean kbDisassemblePrevState;

    public MixinShipKeyHandler(ArchimedesConfig cfg) {
        this.config = cfg;
        this.kbDisassemblePrevState = false;
        this.kbShipGuiPrevState = false;
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public void updateControl(TickEvent.PlayerTickEvent e) {
        if (!this.optimizationsAndTweaks$isValidUpdateEvent(e)) {
            return;
        }
        this.optimizationsAndTweaks$handleShipGuiKeyPress();
        this.optimizationsAndTweaks$handleDisassembleKeyPress(e);
        EntityShip ship = (EntityShip)e.player.field_70154_o;
        int heightControl = this.optimizationsAndTweaks$calculateHeightControl();
        this.optimizationsAndTweaks$updateShipControl(ship, e.player, heightControl);
    }

    @Unique
    private boolean optimizationsAndTweaks$isValidUpdateEvent(TickEvent.PlayerTickEvent e) {
        return e.phase == TickEvent.Phase.START && e.side == Side.CLIENT && e.player == FMLClientHandler.instance().getClientPlayerEntity() && e.player.field_70154_o instanceof EntityShip;
    }

    @Unique
    private void optimizationsAndTweaks$handleShipGuiKeyPress() {
        boolean shipGuiKeyPressed = this.config.kbShipInv.func_151470_d();
        if (shipGuiKeyPressed && !this.kbShipGuiPrevState) {
            ClientOpenGuiMessage msg = new ClientOpenGuiMessage(2);
            ArchimedesShipMod.instance.network.sendToServer((ArchimedesShipsMessage)msg);
        }
        this.kbShipGuiPrevState = shipGuiKeyPressed;
    }

    @Unique
    private void optimizationsAndTweaks$handleDisassembleKeyPress(TickEvent.PlayerTickEvent e) {
        if (!(e.player instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = e.player;
        boolean disassembleKeyPressed = this.config.kbDisassemble.func_151470_d();
        if (disassembleKeyPressed && !this.kbDisassemblePrevState && player.field_70154_o instanceof EntityShip) {
            EntityShip ship = (EntityShip)player.field_70154_o;
            MovingWorldClientActionMessage msg = new MovingWorldClientActionMessage((EntityMovingWorld)ship, MovingWorldClientActionMessage.Action.DISASSEMBLE);
            MovingWorld.instance.network.sendToServer((MovingWorldMessage)msg);
        }
        this.kbDisassemblePrevState = disassembleKeyPressed;
    }

    @Unique
    private int optimizationsAndTweaks$calculateHeightControl() {
        if (this.config.kbAlign.func_151470_d()) {
            return 4;
        }
        if (this.config.kbBrake.func_151470_d()) {
            return 3;
        }
        int vert = 0;
        vert += this.config.kbUp.func_151470_d() ? 1 : 0;
        return (vert += this.config.kbDown.func_151470_d() ? -1 : 0) < 0 ? 1 : (vert > 0 ? 2 : 0);
    }

    @Unique
    private void optimizationsAndTweaks$updateShipControl(EntityShip ship, EntityPlayer player, int heightControl) {
        if (heightControl != ship.getController().getShipControl()) {
            ship.getController().updateControl(ship, player, heightControl);
        }
    }
}

