/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.client.extrautilities;

import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.tileentity.enderquarry.BlockBreakingRegistry;
import com.rwtema.extrautils.tileentity.enderquarry.BlockDummy;
import fr.iamacat.optimizationsandtweaks.utilsformods.extrautilities.ClassBytesCache;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockBreakingRegistry.class})
public class MixinBlockBreakingRegistry {
    @Shadow
    public static BlockBreakingRegistry instance = new BlockBreakingRegistry();
    @Shadow
    public static HashMap<Block, BlockBreakingRegistry.entry> entries = new HashMap();
    @Shadow
    public static Set<String> methodNames = null;
    @Shadow
    public static Map<String, Boolean> names = new HashMap<String, Boolean>();
    @Shadow
    public static LaunchClassLoader cl = (LaunchClassLoader)BlockBreakingRegistry.class.getClassLoader();

    @Shadow
    public static boolean blackList(Block id) {
        return MixinBlockBreakingRegistry.entries.get((Object)id).blackList;
    }

    @Shadow
    public static boolean isSpecial(Block id) {
        return MixinBlockBreakingRegistry.entries.get((Object)id).isSpecial;
    }

    @Shadow
    public static boolean isFence(Block id) {
        return MixinBlockBreakingRegistry.entries.get((Object)id).isFence;
    }

    @Shadow
    public static boolean isFluid(Block id) {
        return MixinBlockBreakingRegistry.entries.get((Object)id).isFluid;
    }

    @Overwrite(remap=false)
    public void setupBreaking() {
        if (methodNames == null) {
            methodNames = new HashSet<String>();
            for (Method m : BlockDummy.class.getDeclaredMethods()) {
                methodNames.add(m.getName());
            }
            for (Block block : Block.field_149771_c) {
                entries.put(block, new BlockBreakingRegistry.entry());
            }
            MixinBlockBreakingRegistry.entries.get((Object)Blocks.field_150478_aa).blackList = true;
            for (Block block : Block.field_149771_c) {
                BlockBreakingRegistry.entry e = entries.get(block);
                String name = block.func_149739_a() != null ? block.func_149739_a() : block.getClass().getName();
                try {
                    name = Block.field_149771_c.func_148750_c((Object)block);
                }
                catch (Exception ignored) {
                    LogHelper.error((Object)("Error getting name for block " + name), (Object[])new Object[0]);
                }
                e.isFence = false;
                try {
                    int renderType = block.func_149645_b();
                    e.isFence = renderType == 11 || block instanceof BlockFence;
                }
                catch (Exception | NoClassDefFoundError exception) {
                    LogHelper.error((Object)("Error checking block class code: Exception calling getRenderType() on block " + name), (Object[])new Object[0]);
                    exception.printStackTrace();
                    if (exception instanceof NoClassDefFoundError) {
                        throw new RuntimeException("Serious error calling getRenderType() on block " + name + " : Likely cause is client-side code is being called server-side", exception);
                    }
                    throw new RuntimeException("Serious error calling getRenderType() on block " + name, exception);
                }
                if (!(block instanceof BlockLiquid) && !(block instanceof IFluidBlock)) continue;
                e.blackList = true;
                e.isFluid = true;
            }
        }
    }

    @Overwrite(remap=false)
    public boolean hasSpecialBreaking(Class clazz) {
        if (clazz != null && !clazz.equals(Block.class)) {
            if (names.containsKey(clazz.getName())) {
                return names.get(clazz.getName());
            }
            LogHelper.fine((Object)("Checking class for special block breaking code: " + clazz.getName()), (Object[])new Object[0]);
            try {
                byte[] bytes = ClassBytesCache.getClassBytes(clazz.getClassLoader(), clazz.getName());
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)classNode, 0);
                for (MethodNode method : classNode.methods) {
                    if (!methodNames.contains(method.name)) continue;
                    LogHelper.fine((Object)("Detected special block breaking code in class: " + clazz.getName()), (Object[])new Object[0]);
                    names.put(clazz.getName(), true);
                    return true;
                }
            }
            catch (Throwable var8) {
                try {
                    Method[] arr$;
                    for (Method m : arr$ = clazz.getDeclaredMethods()) {
                        if (!methodNames.contains(m.getName())) continue;
                        LogHelper.fine((Object)("Detected special block breaking code in class: " + clazz.getName()), (Object[])new Object[0]);
                        names.put(clazz.getName(), true);
                        return true;
                    }
                }
                catch (Throwable var7) {
                    LogHelper.error((Object)("Error checking block class code: " + clazz.getName()), (Object[])new Object[0]);
                    var8.printStackTrace();
                    var7.printStackTrace();
                    names.put(clazz.getName(), true);
                    return true;
                }
            }
            boolean result = this.hasSpecialBreaking(clazz.getSuperclass());
            names.put(clazz.getName(), result);
            return result;
        }
        return false;
    }
}

