/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.atum;

import com.teammetallurgy.atum.blocks.AtumBlocks;
import com.teammetallurgy.atum.blocks.tileentity.chests.TileEntityPharaohChest;
import com.teammetallurgy.atum.items.AtumLoot;
import com.teammetallurgy.atum.world.decorators.WorldGenPyramid;
import fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.mixins.Classers;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={WorldGenPyramid.class})
public abstract class MixinWorldGenPyramid
extends WorldGenerator {
    @Overwrite(remap=false)
    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int dz;
        int dx;
        int x;
        int chunkX = i >> 4;
        int chunkZ = k >> 4;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        if (!chunk.field_76636_d) {
            return false;
        }
        if ((double)random.nextFloat() > 0.3) {
            j -= 8;
        }
        int width = 17;
        int depth = 17;
        boolean[][] maze = new boolean[17][17];
        new ArrayList();
        int zIn = 9;
        maze[0][zIn] = true;
        this.generateMaze(maze, random, 1, zIn);
        for (x = -6; x < 10; ++x) {
            for (dx = x; dx <= width - x; ++dx) {
                for (dz = x; dz <= depth - x; ++dz) {
                    Block id = world.func_147439_a(dx + i, x + j + 3, dz + k);
                    if (id == null || id == AtumBlocks.BLOCK_SAND) {
                        world.func_147468_f(dx + i, x + j + 3, dz + k);
                    }
                    world.func_147449_b(dx + i, x + j + 3, dz + k, AtumBlocks.BLOCK_LARGEBRICK);
                }
            }
        }
        for (x = -3; x < width + 3; ++x) {
            for (dx = -3; dx < depth + 3; ++dx) {
                Block temp;
                if (x < 0 || x >= width || dx < 0 || dx >= depth) continue;
                world.func_147468_f(x + i, j, dx + k);
                world.func_147449_b(x + i, j - 1, dx + k, AtumBlocks.BLOCK_STONE);
                if (!maze[x][dx]) {
                    if (random.nextFloat() > 0.1f) {
                        world.func_147449_b(x + i, j, dx + k, AtumBlocks.BLOCK_LARGEBRICK);
                        temp = world.func_147439_a(x + i, j + 1, dx + k);
                        if (temp != null) {
                            temp.func_149722_s();
                        }
                    } else {
                        this.placeTrap(world, x + i, j, dx + k);
                    }
                    world.func_147449_b(x + i, j + 1, dx + k, AtumBlocks.BLOCK_LARGEBRICK);
                    temp = world.func_147439_a(x + i, j + 1, dx + k);
                    if (temp != null) {
                        temp.func_149722_s();
                    }
                    world.func_147449_b(x + i, j + 2, dx + k, AtumBlocks.BLOCK_LARGEBRICK);
                    temp = world.func_147439_a(x + i, j + 2, dx + k);
                    if (temp != null) {
                        temp.func_149722_s();
                    }
                } else {
                    dz = random.nextInt(5);
                    world.func_147465_d(x + i, j, dx + k, AtumBlocks.BLOCK_SANDLAYERED, dz, 0);
                    world.func_147468_f(x + i, j + 1, dx + k);
                    world.func_147468_f(x + i, j + 2, dx + k);
                }
                world.func_147449_b(x + i, j + 3, dx + k, AtumBlocks.BLOCK_LARGEBRICK);
                temp = world.func_147439_a(x + i, j + 3, dx + k);
                if (temp == null) continue;
                temp.func_149722_s();
            }
        }
        world.func_147468_f(i - 1, j, k + zIn);
        world.func_147468_f(i - 1, j + 1, k + zIn);
        world.func_147468_f(i - 2, j, k + zIn);
        world.func_147468_f(i - 2, j + 1, k + zIn);
        world.func_147468_f(i - 3, j, k + zIn);
        world.func_147468_f(i - 3, j + 1, k + zIn);
        world.func_147468_f(i - 4, j, k + zIn);
        world.func_147468_f(i - 4, j + 1, k + zIn);
        for (x = 4; x < 8; ++x) {
            for (dx = 6; dx < 12; ++dx) {
                for (dz = 6; dz < 12; ++dz) {
                    world.func_147468_f(i + dx, j + x, k + dz);
                }
            }
        }
        world.func_147465_d(i + 11, j + 6, k + 7, Blocks.field_150478_aa, 2, 0);
        world.func_147465_d(i + 11, j + 6, k + 10, Blocks.field_150478_aa, 2, 0);
        world.func_147465_d(i + 10, j + 4, k + 8, AtumBlocks.BLOCK_PHARAOHCHEST, 0, 2);
        try {
            TileEntityPharaohChest te = (TileEntityPharaohChest)world.func_147438_o(i + 10, j + 4, k + 8);
            AtumLoot.fillChest((IInventory)te, (int)15, (float)0.9f);
        }
        catch (ClassCastException te) {
            // empty catch block
        }
        if (world.func_147437_c(i + 7, j + 1, k + 7)) {
            this.placeLadders(world, i + 7, j, k + 7, 4);
        } else {
            boolean found = false;
            block10: for (dx = -1; dx <= 1 && !found; ++dx) {
                for (dz = -1; dz <= 1; ++dz) {
                    if (!world.func_147437_c(i + 7 + dx, j + 1, k + 7 + dz)) continue;
                    this.placeLadders(world, i + 7 + dx, j, k + 7 + dz, 3);
                    found = true;
                    continue block10;
                }
            }
        }
        return false;
    }

    @Shadow
    public void placeTrap(World world, int x, int y, int z) {
        int meta = 0;
        if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
            meta = 3;
        }
        if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
            meta = 4;
        }
        if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
            meta = 5;
        }
        if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
            meta = 2;
        }
        world.func_147465_d(x, y, z, AtumBlocks.BLOCK_TRAPARROW, meta, 0);
    }

    @Shadow
    public void placeLadders(World world, int x, int y, int z, int height) {
        int meta = 0;
        if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
            meta = 2;
        }
        if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
            meta = 3;
        }
        if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
            meta = 4;
        }
        if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
            meta = 5;
        }
        for (int i = 0; i < height; ++i) {
            world.func_147465_d(x, y + i, z, Blocks.field_150468_ap, meta, 0);
        }
    }

    @Overwrite(remap=false)
    public void generateMaze(boolean[][] array, Random random, int x, int y) {
        ArrayList<Classers.Pair> choices = new ArrayList<Classers.Pair>();
        do {
            choices.clear();
            if (x + 2 < 16 && !array[x + 2][y]) {
                choices.add(new Classers.Pair(2, 0));
            }
            if (x - 2 >= 0 && !array[x - 2][y]) {
                choices.add(new Classers.Pair(-2, 0));
            }
            if (y + 2 < 16 && !array[x][y + 2]) {
                choices.add(new Classers.Pair(0, 2));
            }
            if (y - 2 >= 0 && !array[x][y - 2]) {
                choices.add(new Classers.Pair(0, -2));
            }
            if (choices.isEmpty()) continue;
            int i = random.nextInt(choices.size());
            Classers.Pair choice = (Classers.Pair)choices.get(i);
            choices.remove(i);
            array[choice.x + x][choice.y + y] = true;
            array[x + choice.x / 2][y + choice.y / 2] = true;
            this.generateMaze(array, random, x + choice.x, y + choice.y);
        } while (!choices.isEmpty());
    }
}

