/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.blocklings;

import com.blocklings.entity.EntityBlockling;
import com.blocklings.gui.InventoryBlockling;
import com.blocklings.main.Blocklings;
import com.blocklings.network.CreatePacketServerSide;
import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityBlockling.class})
public abstract class MixinEntityBlockling
extends EntityTameable
implements IInvBasic,
IRangedAttackMob {
    @Unique
    private EntityBlockling entityBlockling;
    @Shadow
    Random random = new Random();
    @Shadow
    public int currentXP = 0;
    @Shadow
    public int currentLevel = 1;
    @Shadow
    public int currentUpgradeTier = 1;
    @Shadow
    public int currentSpecialTier = 1;
    @Shadow
    public int requiredXP = 200;
    @Shadow
    public double maxHealth = 2.0;
    @Shadow
    public double attackDamage = 1.0;
    @Shadow
    public double moveSpeed = 0.2;
    @Shadow
    public float moveTimer = 0.0f;
    @Shadow
    public boolean moveTimerSwitch = true;
    @Shadow
    public float attackTimer = 0.0f;
    @Shadow
    public boolean attackTimerSwitch = true;
    @Shadow
    public boolean isAttacking = false;
    @Shadow
    public int swordID = 0;
    @Shadow
    public int regenTimer = 0;
    @Shadow
    public int image = 0;
    @Shadow
    public float field_70130_N = 0.5f;
    @Shadow
    public float field_70131_O = 0.55f;
    @Shadow
    public InventoryBlockling gear;
    @Shadow
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 20, 10.0f);
    @Shadow
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false);
    @Shadow
    private EntityAIPanic aiPanic = new EntityAIPanic((EntityCreature)this, 1.0);

    public MixinEntityBlockling(World p_i1604_1_, EntityBlockling entityBlockling) {
        super(p_i1604_1_);
        this.entityBlockling = entityBlockling;
    }

    @Shadow
    public void setXP(int currentXP) {
        this.currentXP = currentXP;
    }

    @Inject(method={"func_70636_d"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void func_70636_d(CallbackInfo ci) {
        if (OptimizationsandTweaksConfig.enableMixinEntityBlockling) {
            super.func_70636_d();
            World world = this.field_70170_p;
            boolean isRemote = world.field_72995_K;
            if (this.attackTimer > 0.0f) {
                this.attackTimer -= 1.0f;
            }
            if (this.attackTimer == 7.0f && !isRemote) {
                this.setXP((int)(this.attackDamage + (double)this.random.nextInt((int)(this.attackDamage * (double)Blocklings.xp)) + (double)this.currentXP));
            }
            if (this.currentSpecialTier >= 8 && !isRemote) {
                ++this.regenTimer;
            }
            if (this.regenTimer == 150 && !isRemote) {
                this.func_70691_i(1.0f);
                this.regenTimer = 0;
            }
            if (this.field_70128_L && !isRemote && this.func_70909_n()) {
                this.image = 0;
                Blocklings.itemBlockling.setBlockling(this.entityBlockling);
                world.func_72838_d((Entity)new EntityItem(world, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)Blocklings.itemBlockling)));
            }
            this.field_70178_ae = this.currentUpgradeTier >= 10;
            this.setEntitySize();
            this.setBlocklingLevel();
            this.calculateRequiredXP();
            this.checkUpgrades();
            this.checkSpecials();
            this.setMaxHealth();
            this.setAttackDamage();
            this.setMoveSpeed();
            if (!isRemote) {
                CreatePacketServerSide.sendS2CEntitySync((Entity)this);
            }
            ci.cancel();
        }
    }

    @Shadow
    public void setEntitySize() {
        if (this.currentLevel <= 10) {
            this.field_70130_N = (float)this.currentLevel * 0.14f + 0.35f;
            this.field_70131_O = (float)this.currentLevel * 0.14f + 0.4f;
        } else if (this.currentLevel > 10) {
            this.field_70130_N = 1.75f;
            this.field_70131_O = 1.8f;
        }
        this.func_70105_a(this.field_70130_N, this.field_70131_O);
    }

    @Shadow
    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        if (this.swordID == 6 && this.currentLevel >= 10) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    @Shadow
    public void calculateRequiredXP() {
        this.requiredXP = 50 * this.currentLevel * this.currentLevel + 150 * this.currentLevel;
    }

    @Shadow
    public void setBlocklingLevel() {
        if (this.currentXP >= this.requiredXP) {
            ++this.currentLevel;
            this.calculateRequiredXP();
            this.field_70170_p.func_72956_a((Entity)this, "random.levelup", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.currentXP = 0;
        }
    }

    @Unique
    private void checkUpgrades() {
        ItemStack itemstack1 = this.gear.func_70301_a(0);
        ItemStack itemstack2 = this.gear.func_70301_a(1);
        ItemStack itemstack3 = this.gear.func_70301_a(2);
        ItemStack itemstack4 = this.gear.func_70301_a(3);
        ItemStack itemstack5 = this.gear.func_70301_a(4);
        ItemStack itemstack6 = this.gear.func_70301_a(5);
        if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeWood && itemstack5 == null && this.currentLevel >= 2 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 2;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeCobblestone && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeWood && this.currentLevel >= 3 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 3;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeStone && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeCobblestone && this.currentLevel >= 4 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 4;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeIron && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeStone && this.currentLevel >= 5 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 5;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeLapis && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeIron && this.currentLevel >= 6 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 6;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeGold && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeLapis && this.currentLevel >= 7 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 7;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeDiamond && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeGold && this.currentLevel >= 8 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 8;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeEmerald && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeDiamond && this.currentLevel >= 9 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 9;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack3 != null && itemstack3.func_77973_b() == Blocklings.itemUpgradeObsidian && itemstack5 != null && itemstack5.func_77973_b() == Blocklings.itemUpgradeEmerald && this.currentLevel >= 10 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 10;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(4, new ItemStack(itemstack3.func_77973_b()));
            this.gear.func_70299_a(2, (ItemStack)null);
        } else if (itemstack5 == null && this.currentUpgradeTier <= 2 && !this.field_70170_p.field_72995_K) {
            this.currentUpgradeTier = 1;
        } else if (itemstack5 == null && this.currentUpgradeTier == 3 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeWood));
            this.currentUpgradeTier = 2;
        } else if (itemstack5 == null && this.currentUpgradeTier == 4 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeCobblestone));
            this.currentUpgradeTier = 3;
        } else if (itemstack5 == null && this.currentUpgradeTier == 5 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeStone));
            this.currentUpgradeTier = 4;
        } else if (itemstack5 == null && this.currentUpgradeTier == 6 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeIron));
            this.currentUpgradeTier = 5;
        } else if (itemstack5 == null && this.currentUpgradeTier == 7 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeLapis));
            this.currentUpgradeTier = 6;
        } else if (itemstack5 == null && this.currentUpgradeTier == 8 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeGold));
            this.currentUpgradeTier = 7;
        } else if (itemstack5 == null && this.currentUpgradeTier == 9 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeDiamond));
            this.currentUpgradeTier = 8;
        } else if (itemstack5 == null && this.currentUpgradeTier == 10 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(4, new ItemStack(Blocklings.itemUpgradeEmerald));
            this.currentUpgradeTier = 9;
        }
    }

    @Unique
    private void checkSpecials() {
        ItemStack itemstack1 = this.gear.func_70301_a(0);
        ItemStack itemstack2 = this.gear.func_70301_a(1);
        ItemStack itemstack3 = this.gear.func_70301_a(2);
        ItemStack itemstack4 = this.gear.func_70301_a(3);
        ItemStack itemstack5 = this.gear.func_70301_a(4);
        ItemStack itemstack6 = this.gear.func_70301_a(5);
        if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeHealth1 && itemstack6 == null && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 2;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeDamage1 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeHealth1 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 3;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeSpeed1 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeDamage1 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 4;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeHealth2 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeSpeed1 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 5;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeDamage2 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeHealth2 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 6;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeSpeed2 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeDamage2 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 7;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeHealth3 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeSpeed2 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 8;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeDamage3 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeHealth3 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 9;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack4 != null && itemstack4.func_77973_b() == Blocklings.itemUpgradeSpeed3 && itemstack6 != null && itemstack6.func_77973_b() == Blocklings.itemUpgradeDamage3 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 10;
            this.field_70170_p.func_72956_a((Entity)this, "random.anvil_use", 0.5f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.gear.func_70299_a(5, new ItemStack(itemstack4.func_77973_b()));
            this.gear.func_70299_a(3, (ItemStack)null);
        } else if (itemstack6 == null && this.currentSpecialTier <= 2 && !this.field_70170_p.field_72995_K) {
            this.currentSpecialTier = 1;
        } else if (itemstack6 == null && this.currentSpecialTier == 3 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeHealth1));
            this.currentSpecialTier = 2;
        } else if (itemstack6 == null && this.currentSpecialTier == 4 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeDamage1));
            this.currentSpecialTier = 3;
        } else if (itemstack6 == null && this.currentSpecialTier == 5 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeSpeed1));
            this.currentSpecialTier = 4;
        } else if (itemstack6 == null && this.currentSpecialTier == 6 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeHealth2));
            this.currentSpecialTier = 5;
        } else if (itemstack6 == null && this.currentSpecialTier == 7 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeDamage2));
            this.currentSpecialTier = 6;
        } else if (itemstack6 == null && this.currentSpecialTier == 8 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeSpeed2));
            this.currentSpecialTier = 7;
        } else if (itemstack6 == null && this.currentSpecialTier == 9 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeHealth3));
            this.currentSpecialTier = 8;
        } else if (itemstack6 == null && this.currentSpecialTier == 10 && !this.field_70170_p.field_72995_K) {
            this.gear.func_70299_a(5, new ItemStack(Blocklings.itemUpgradeDamage3));
            this.currentSpecialTier = 9;
        }
    }

    @Unique
    private void checkWeapon() {
        ItemStack itemstack1 = this.gear.func_70301_a(0);
        ItemStack itemstack2 = this.gear.func_70301_a(1);
        ItemStack itemstack3 = this.gear.func_70301_a(2);
        ItemStack itemstack4 = this.gear.func_70301_a(3);
        ItemStack itemstack5 = this.gear.func_70301_a(4);
        ItemStack itemstack6 = this.gear.func_70301_a(5);
        if (itemstack1 != null && this.currentLevel >= 10 && itemstack2 == null && !this.field_70170_p.field_72995_K) {
            if (itemstack1.func_77973_b() == Items.field_151041_m) {
                this.swordID = 1;
            } else if (itemstack1.func_77973_b() == Items.field_151052_q) {
                this.swordID = 2;
            } else if (itemstack1.func_77973_b() == Items.field_151040_l) {
                this.swordID = 3;
            } else if (itemstack1.func_77973_b() == Items.field_151010_B) {
                this.swordID = 4;
            } else if (itemstack1.func_77973_b() == Items.field_151048_u) {
                this.swordID = 5;
            }
        } else if (itemstack1 == null && itemstack2 == null && !this.field_70170_p.field_72995_K) {
            this.swordID = 0;
        }
        if (itemstack2 != null && this.currentLevel >= 10 && !this.field_70170_p.field_72995_K) {
            if (itemstack2.func_77973_b() == Blocklings.itemShuriken) {
                this.swordID = 6;
            }
        } else if (itemstack1 == null && itemstack2 == null && !this.field_70170_p.field_72995_K) {
            this.swordID = 0;
        }
        this.setCombatTask();
    }

    @Unique
    private void setupGear() {
        InventoryBlockling gear1 = this.gear;
        this.gear = new InventoryBlockling("Inventory", this.howManySlots());
        this.gear.func_110133_a(this.func_70005_c_());
        if (gear1 != null) {
            gear1.func_110132_b((IInvBasic)this);
            int i = Math.min(gear1.func_70302_i_(), this.gear.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = gear1.func_70301_a(j);
                if (itemstack == null) continue;
                this.gear.func_70299_a(j, itemstack.func_77946_l());
            }
            gear1 = null;
        }
        this.gear.func_110134_a((IInvBasic)this);
    }

    @Unique
    public int howManySlots() {
        return 6;
    }

    @Unique
    public void setMaxHealth() {
        double bonusHealth = this.currentUpgradeTier * 2;
        if (this.currentSpecialTier >= 2 && this.currentSpecialTier < 5) {
            bonusHealth = this.currentUpgradeTier * 2 + 5;
        }
        if (this.currentSpecialTier >= 5 && this.currentSpecialTier < 8) {
            bonusHealth = this.currentUpgradeTier * 2 + 11;
        }
        if (this.currentSpecialTier >= 8) {
            bonusHealth = this.currentUpgradeTier * 2 + 20;
        }
        if (this.currentLevel <= 10) {
            this.maxHealth = (double)(this.currentLevel * 2) + bonusHealth;
        } else if (this.currentLevel > 10) {
            this.maxHealth = 20.0 + bonusHealth;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.maxHealth);
        if ((double)this.func_110143_aJ() > this.maxHealth) {
            this.func_70691_i(0.0f);
        }
    }

    @Unique
    public void setAttackDamage() {
        double bonusDamage = this.currentUpgradeTier;
        if (this.swordID > 0 && this.swordID < 6) {
            bonusDamage = this.currentUpgradeTier + this.swordID * 2;
        }
        if (this.currentSpecialTier >= 3 && this.currentSpecialTier < 6) {
            bonusDamage = this.currentUpgradeTier + 3;
        }
        if (this.currentSpecialTier >= 6 && this.currentSpecialTier < 9) {
            bonusDamage = this.currentUpgradeTier + 6;
        }
        if (this.currentSpecialTier >= 9) {
            bonusDamage = this.currentUpgradeTier + 10;
        }
        if (this.currentSpecialTier >= 3 && this.currentSpecialTier < 6 && this.swordID > 0 && this.swordID < 6) {
            bonusDamage = this.currentUpgradeTier + this.swordID * 2 + 3;
        }
        if (this.currentSpecialTier >= 6 && this.currentSpecialTier < 9 && this.swordID > 0 && this.swordID < 6) {
            bonusDamage = this.currentUpgradeTier + this.swordID * 2 + 6;
        }
        if (this.currentSpecialTier >= 9 && this.swordID > 0 && this.swordID < 6) {
            bonusDamage = this.currentUpgradeTier + this.swordID * 2 + 10;
        }
        if (this.swordID == 6 && this.currentLevel >= 10) {
            this.attackDamage = 5.0;
        } else if (this.currentLevel <= 10) {
            this.attackDamage = (double)this.currentLevel + bonusDamage;
        } else if (this.currentLevel > 10) {
            this.attackDamage = 10.0 + bonusDamage;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.attackDamage);
    }

    @Unique
    public void setMoveSpeed() {
        double bonusSpeed = 0.0;
        if (this.currentSpecialTier >= 4 && this.currentSpecialTier < 7) {
            bonusSpeed = 0.05;
        }
        if (this.currentSpecialTier >= 7 && this.currentSpecialTier < 10) {
            bonusSpeed = 0.11;
        }
        if (this.currentSpecialTier >= 10) {
            bonusSpeed = 0.15;
        }
        if (this.currentLevel <= 10) {
            this.moveSpeed = 0.25 + (double)this.currentLevel / 200.0 + bonusSpeed;
        } else if (this.currentLevel > 10) {
            this.moveSpeed = 0.35 + bonusSpeed;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.moveSpeed);
    }
}

