/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.chromaticraft;

import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.World.IWG.DungeonGenerator;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Math.Noise.VoronoiNoiseGenerator;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import fr.iamacat.optimizationsandtweaks.utilsformods.chromaticraft.ChromaticraftUtils;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={DungeonGenerator.class})
public class MixinDungeonGenerator {
    @Shadow
    private EnumMap<ChromaStructures, VoronoiNoiseGenerator> structs = new EnumMap(ChromaStructures.class);
    @Unique
    private final Map<ChromaticraftUtils.WorldStructureKey, VoronoiNoiseGenerator> optimizationsAndTweaks$noiseCache = new WeakHashMap<ChromaticraftUtils.WorldStructureKey, VoronoiNoiseGenerator>();

    @Overwrite(remap=false)
    private void updateNoisemaps(World world) {
        ReikaWorldHelper.WorldID id = ReikaWorldHelper.getCurrentWorldID((World)world);
        for (ChromaStructures s : this.structs.keySet()) {
            ChromaticraftUtils.WorldStructureKey key = new ChromaticraftUtils.WorldStructureKey(id, s);
            VoronoiNoiseGenerator v = this.optimizationsAndTweaks$noiseCache.get(key);
            if (v == null) {
                long seed = this.calculateStructureSeed(world, id, s);
                v = this.createNewGenerator(s, seed);
                this.optimizationsAndTweaks$noiseCache.put(key, v);
            }
            this.structs.put(s, v);
        }
    }

    private long calculateStructureSeed(World world, ReikaWorldHelper.WorldID id, ChromaStructures s) {
        return world.func_72905_C() ^ (long)s.ordinal() * 41381L ^ (id.worldCreationTime ^ 0xFFFFFFFFFFFFFFFFL) ^ (long)ReikaFileReader.getRealPath((File)world.func_72860_G().func_75765_b()).hashCode();
    }

    private VoronoiNoiseGenerator createNewGenerator(ChromaStructures s, long seed) {
        VoronoiNoiseGenerator gen = (VoronoiNoiseGenerator)new VoronoiNoiseGenerator(seed).setFrequency(0.75 / (double)this.getNoiseScale(s));
        gen.randomFactor = 0.55;
        return gen;
    }

    @Shadow
    private int getNoiseScale(ChromaStructures s) {
        switch (s) {
            case DESERT: {
                return 440;
            }
            case OCEAN: {
                return 640;
            }
            case CAVERN: {
                return 144;
            }
            case BURROW: {
                return 240;
            }
            case SNOWSTRUCT: {
                return 480;
            }
            case BIOMEFRAG: {
                return 640;
            }
        }
        return 1;
    }
}

