/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.cofhcore.fixoredictcrash;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.core.util.oredict.OreDictionaryArbiterProxy;
import cofh.lib.util.ItemWrapper;
import cofh.lib.util.helpers.ItemHelper;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={OreDictionaryArbiter.class})
public class MixinOreDictionaryArbiter {
    @Shadow
    private static BiMap<String, Integer> oreIDs;
    @Shadow
    private static TMap<Integer, ArrayList<ItemStack>> oreStacks;
    @Shadow
    private static TMap<ItemWrapper, ArrayList<Integer>> stackIDs;
    @Shadow
    private static TMap<ItemWrapper, ArrayList<String>> stackNames;
    @Shadow
    private static String[] oreNames;
    @Unique
    private static boolean optimizationsAndTweaks$initialized;

    @Overwrite
    public static void initialize() {
        if (OptimizationsandTweaksConfig.enableMixinOreDictCofhFix && !optimizationsAndTweaks$initialized) {
            oreIDs = HashBiMap.create((int)32);
            oreStacks = new THashMap(32);
            stackIDs = new THashMap(32);
            stackNames = new THashMap(32);
            oreNames = OreDictionary.getOreNames();
            for (String oreName : oreNames) {
                ArrayList var1 = OreDictionary.getOres((String)oreName);
                for (ItemStack itemStack : var1) {
                    OreDictionaryArbiter.registerOreDictionaryEntry((ItemStack)itemStack, (String)oreName);
                }
            }
            for (ItemWrapper var4 : stackIDs.keySet()) {
                ItemWrapper var5;
                if (var4.metadata == Short.MAX_VALUE || !stackIDs.containsKey((Object)(var5 = new ItemWrapper(var4.item, Short.MAX_VALUE)))) continue;
                ((ArrayList)stackIDs.get((Object)var4)).addAll((Collection)stackIDs.get((Object)var5));
                ((ArrayList)stackNames.get((Object)var4)).addAll((Collection)stackNames.get((Object)var5));
            }
            ItemHelper.oreProxy = new OreDictionaryArbiterProxy();
            optimizationsAndTweaks$initialized = true;
        }
    }

    @Overwrite
    public static void registerOreDictionaryEntry(ItemStack var0, String var1) {
        if (OptimizationsandTweaksConfig.enableMixinOreDictCofhFix && var0 != null && var0.func_77973_b() != null && !Strings.isNullOrEmpty((String)var1)) {
            int var2 = OreDictionary.getOreID((String)var1);
            oreIDs.put((Object)var1, (Object)var2);
            if (oreStacks == null) {
                oreStacks = new THashMap(32);
            }
            if (stackIDs == null) {
                stackIDs = new THashMap(32);
            }
            if (stackNames == null) {
                stackNames = new THashMap(32);
            }
            try {
                if (!oreStacks.containsKey((Object)var2)) {
                    oreStacks.put((Object)var2, new ArrayList());
                }
                ((ArrayList)oreStacks.get((Object)var2)).add(var0);
                ItemWrapper var3 = ItemWrapper.fromItemStack((ItemStack)var0);
                if (!stackIDs.containsKey((Object)var3)) {
                    stackIDs.put((Object)var3, new ArrayList());
                    stackNames.put((Object)var3, new ArrayList());
                }
                ((ArrayList)stackIDs.get((Object)var3)).add(var2);
                ((ArrayList)stackNames.get((Object)var3)).add(var1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        optimizationsAndTweaks$initialized = false;
    }
}

