/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockLeaves.class})
public abstract class MixinBlockLeaves
extends BlockLeavesBase
implements IShearable {
    @Unique
    private static final int SEARCH_RADIUS = 4;
    @Unique
    private static final int AREA_SIZE = 9;

    protected MixinBlockLeaves(Material p_i45433_1_, boolean p_i45433_2_) {
        super(p_i45433_1_, p_i45433_2_);
    }

    @Inject(method={"updateTick"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateTick(World worldIn, int x, int y, int z, Random random, CallbackInfo ci) {
        if (worldIn.field_72995_K) {
            return;
        }
        int metadata = worldIn.func_72805_g(x, y, z);
        if (this.optimizationsAndTweaks$shouldUpdateLeaves(metadata)) {
            int areaSize = 9;
            int halfArea = 4;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (worldIn.func_72964_e(chunkX, chunkZ).func_76625_h() >= y >> 4) {
                int[] blockArray = this.optimizationsAndTweaks$initializeBlockArray(areaSize);
                this.optimizationsAndTweaks$populateBlockArray(worldIn, x, y, z, areaSize, halfArea, blockArray);
                for (int iteration = 1; iteration <= 4; ++iteration) {
                    this.optimizationsAndTweaks$propagateDecayIteration(blockArray, areaSize, halfArea, iteration);
                }
                int centralIndex = halfArea * areaSize * areaSize + halfArea * areaSize + halfArea;
                int centralBlockStatus = blockArray[centralIndex];
                this.optimizationsAndTweaks$updateWorld(metadata, worldIn, x, y, z, centralBlockStatus);
            }
        }
        ci.cancel();
    }

    @Unique
    private boolean optimizationsAndTweaks$shouldUpdateLeaves(int metadata) {
        return (metadata & 0xC) == 8 && (metadata & 4) == 0;
    }

    @Unique
    private int[] optimizationsAndTweaks$initializeBlockArray(int areaSize) {
        return new int[areaSize * areaSize * areaSize];
    }

    @Unique
    private void optimizationsAndTweaks$populateBlockArray(World worldIn, int x, int y, int z, int areaSize, int halfArea, int[] blockArray) {
        int cachedZ;
        int cachedY;
        int cachedX;
        int zOffset;
        int yOffset;
        int xOffset;
        int searchRadius = 4;
        Block[][][] cachedBlocks = new Block[2 * searchRadius + 1][2 * searchRadius + 1][2 * searchRadius + 1];
        for (xOffset = -searchRadius; xOffset <= searchRadius; ++xOffset) {
            for (yOffset = -searchRadius; yOffset <= searchRadius; ++yOffset) {
                for (zOffset = -searchRadius; zOffset <= searchRadius; ++zOffset) {
                    cachedX = xOffset + searchRadius;
                    cachedY = yOffset + searchRadius;
                    cachedZ = zOffset + searchRadius;
                    cachedBlocks[cachedX][cachedY][cachedZ] = worldIn.func_147439_a(x + xOffset, y + yOffset, z + zOffset);
                }
            }
        }
        for (xOffset = -searchRadius; xOffset <= searchRadius; ++xOffset) {
            for (yOffset = -searchRadius; yOffset <= searchRadius; ++yOffset) {
                for (zOffset = -searchRadius; zOffset <= searchRadius; ++zOffset) {
                    cachedX = xOffset + searchRadius;
                    cachedY = yOffset + searchRadius;
                    cachedZ = zOffset + searchRadius;
                    Block block = cachedBlocks[cachedX][cachedY][cachedZ];
                    int index = (xOffset + halfArea) * areaSize * areaSize + (yOffset + halfArea) * areaSize + zOffset + halfArea;
                    blockArray[index] = this.optimizationsAndTweaks$determineBlockArrayValue(block, worldIn, x + xOffset, y + yOffset, z + zOffset);
                }
            }
        }
    }

    @Unique
    private int optimizationsAndTweaks$determineBlockArrayValue(Block block, World worldIn, int x, int y, int z) {
        return block.isLeaves((IBlockAccess)worldIn, x, y, z) ? -2 : (block.canSustainLeaves((IBlockAccess)worldIn, x, y, z) ? 0 : -1);
    }

    @Unique
    private void optimizationsAndTweaks$propagateDecayIteration(int[] blockArray, int areaSize, int halfArea, int iteration) {
        int searchRadius = 4;
        for (int xOffset = -searchRadius; xOffset <= searchRadius; ++xOffset) {
            for (int yOffset = -searchRadius; yOffset <= searchRadius; ++yOffset) {
                for (int zOffset = -searchRadius; zOffset <= searchRadius; ++zOffset) {
                    int index = (xOffset + halfArea) * areaSize * areaSize + (yOffset + halfArea) * areaSize + zOffset + halfArea;
                    if (blockArray[index] != iteration - 1) continue;
                    this.optimizationsAndTweaks$propagateDecayToNeighbors(blockArray, index, areaSize, iteration);
                }
            }
        }
    }

    @Unique
    private void optimizationsAndTweaks$propagateDecayToNeighbors(int[] blockArray, int index, int areaSize, int iteration) {
        for (int offset : new int[]{-1, 1}) {
            this.optimizationsAndTweaks$propagateDecayToNeighbor(blockArray, index + offset, iteration);
            this.optimizationsAndTweaks$propagateDecayToNeighbor(blockArray, index + offset * areaSize, iteration);
            this.optimizationsAndTweaks$propagateDecayToNeighbor(blockArray, index + offset * areaSize * areaSize, iteration);
        }
    }

    @Unique
    private void optimizationsAndTweaks$propagateDecayToNeighbor(int[] blockArray, int index, int iteration) {
        if (index >= 0 && index < blockArray.length && blockArray[index] == -2) {
            blockArray[index] = iteration;
        }
    }

    @Unique
    private void optimizationsAndTweaks$updateWorld(int metadata, World worldIn, int x, int y, int z, int centralBlockStatus) {
        if (centralBlockStatus >= 0) {
            worldIn.func_72921_c(x, y, z, metadata & 0xFFFFFFF7, 4);
        } else {
            this.func_150126_e(worldIn, x, y, z);
        }
    }

    @Shadow
    private void func_150126_e(World p_150126_1_, int p_150126_2_, int p_150126_3_, int p_150126_4_) {
        this.func_149697_b(p_150126_1_, p_150126_2_, p_150126_3_, p_150126_4_, p_150126_1_.func_72805_g(p_150126_2_, p_150126_3_, p_150126_4_), 0);
        p_150126_1_.func_147468_f(p_150126_2_, p_150126_3_, p_150126_4_);
    }

    @Shadow
    public void func_149690_a(World worldIn, int x, int y, int z, int meta, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            ArrayList<ItemStack> items = this.getDrops(worldIn, x, y, z, meta, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                this.func_149642_a(worldIn, x, y, z, item);
            }
        }
    }

    @Shadow
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int chance = this.func_150123_b(metadata);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (world.field_73012_v.nextInt(chance) == 0) {
            ret.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), 1, this.func_149692_a(metadata)));
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        this.func_150124_c(world, x, y, z, metadata, chance);
        ret.addAll(this.captureDrops(false));
        return ret;
    }

    @Shadow
    protected int func_150123_b(int p_150123_1_) {
        return 20;
    }

    @Shadow
    protected void func_150124_c(World p_150124_1_, int p_150124_2_, int p_150124_3_, int p_150124_4_, int p_150124_5_, int p_150124_6_) {
    }
}

