/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeModContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ForgeHooksClient.class})
public class MixinForgeHooksClient {
    @Shadow
    private static int skyX;
    @Shadow
    private static int skyZ;
    @Shadow
    private static boolean skyInit;
    @Shadow
    private static int skyRGBMultiplier;

    @Overwrite
    public static int getSkyBlendColour(World world, int playerX, int playerY, int playerZ) {
        if (world == null) {
            System.err.println("[OptimizationsAndTweaks] World is null");
            return 0;
        }
        if (playerX == skyX && playerZ == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null) {
            System.err.println("[OptimizationsAndTweaks] Minecraft instance is null");
            return 0;
        }
        GameSettings settings = minecraft.field_71474_y;
        if (settings == null) {
            System.err.println("[OptimizationsAndTweaks] GameSettings is null");
            return 0;
        }
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Float temperature;
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                if (biome == null || (temperature = Float.valueOf(biome.func_150564_a(playerX + x, playerY, playerZ + z))) == null) continue;
                int colour = biome.func_76731_a(temperature.floatValue());
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                ++divider;
            }
        }
        if (divider == 0) {
            return 0;
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b / divider & 0xFF;
        skyX = playerX;
        skyZ = playerZ;
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }
}

