/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.DuplicateModsFoundException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.MCPDummyContainer;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MinecraftDummyContainer;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.functions.ArtifactVersionNameFunction;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ItemStackHolderInjector;
import cpw.mods.fml.common.registry.ObjectHolderRegistry;
import cpw.mods.fml.common.toposort.ModSorter;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.ModListHelper;
import cpw.mods.fml.relauncher.Side;
import fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.mixins.Classers;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Loader.class})
public class MixinLoader {
    @Unique
    private Loader optimizationsAndTweaks$loader;
    @Shadow
    public static final String MC_VERSION = "1.7.10";
    @Shadow
    private static final Splitter DEPENDENCYPARTSPLITTER = Splitter.on((String)":").omitEmptyStrings().trimResults();
    @Shadow
    private static final Splitter DEPENDENCYSPLITTER = Splitter.on((String)";").omitEmptyStrings().trimResults();
    @Unique
    private static MixinLoader optimizationsAndTweaks$instance;
    @Shadow
    private static String major;
    @Shadow
    private static String minor;
    @Shadow
    private static String rev;
    @Shadow
    private static String build;
    @Shadow
    private static String mccversion;
    @Shadow
    private static String mcpversion;
    @Shadow
    private ModClassLoader modClassLoader;
    @Shadow
    private List<ModContainer> mods;
    @Shadow
    private Map<String, ModContainer> namedMods;
    @Shadow
    private ListMultimap<String, String> reverseDependencies;
    @Shadow
    private File canonicalConfigDir;
    @Shadow
    private File canonicalModsDir;
    @Shadow
    private LoadController modController;
    @Shadow
    private MinecraftDummyContainer minecraft;
    @Shadow
    private MCPDummyContainer mcp;
    @Shadow
    private static File minecraftDir;
    @Shadow
    private static List<String> injectedContainers;
    @Shadow
    private ImmutableMap<String, String> fmlBrandingProperties;
    @Shadow
    private File forcedModFile;
    @Shadow
    private ModDiscoverer discoverer;
    @Shadow
    private ProgressManager.ProgressBar progressBar;
    @Shadow
    private ListMultimap<String, ArtifactVersion> injectedBefore = ArrayListMultimap.create();
    @Shadow
    private ListMultimap<String, ArtifactVersion> injectedAfter = ArrayListMultimap.create();

    @Unique
    private static MixinLoader optimizationsAndTweaks$instance() {
        if (optimizationsAndTweaks$instance == null) {
            optimizationsAndTweaks$instance = new MixinLoader();
        }
        return optimizationsAndTweaks$instance;
    }

    @Shadow
    public static void injectData(Object ... data) {
        major = (String)data[0];
        minor = (String)data[1];
        rev = (String)data[2];
        build = (String)data[3];
        mccversion = (String)data[4];
        mcpversion = (String)data[5];
        minecraftDir = (File)data[6];
        injectedContainers = (List)data[7];
    }

    private MixinLoader() {
        this.modClassLoader = new ModClassLoader(this.getClass().getClassLoader());
        if (!mccversion.equals(MC_VERSION)) {
            FMLLog.severe((String)"This version of FML is built for Minecraft %s, we have detected Minecraft %s in your minecraft jar file", (Object[])new Object[]{mccversion, MC_VERSION});
            throw new LoaderException(String.format("This version of FML is built for Minecraft %s, we have detected Minecraft %s in your minecraft jar file", mccversion, MC_VERSION));
        }
        this.minecraft = new MinecraftDummyContainer(MC_VERSION);
        this.mcp = new MCPDummyContainer(MetadataCollection.from((InputStream)this.getClass().getResourceAsStream("/mcpmod.info"), (String)"MCP").getMetadataForId("mcp", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    private void sortModList() {
        FMLLog.finer((String)"Verifying mod requirements are satisfied", (Object[])new Object[0]);
        try {
            HashBiMap modVersions = HashBiMap.create();
            for (ModContainer modContainer : Iterables.concat(this.getActiveModList(), (Iterable)ModAPIManager.INSTANCE.getAPIList())) {
                modVersions.put((Object)modContainer.getModId(), (Object)modContainer.getProcessedVersion());
            }
            ArrayListMultimap reqList = ArrayListMultimap.create();
            for (ModContainer mod : this.getActiveModList()) {
                if (!mod.acceptableMinecraftVersionRange().containsVersion(this.minecraft.getProcessedVersion())) {
                    FMLLog.severe((String)"The mod %s does not wish to run in Minecraft version %s. You will have to remove it to play.", (Object[])new Object[]{mod.getModId(), this.getMCVersionString()});
                    throw new WrongMinecraftVersionException(mod);
                }
                ImmutableMap names = Maps.uniqueIndex((Iterable)mod.getRequirements(), (Function)new ArtifactVersionNameFunction());
                HashSet versionMissingMods = Sets.newHashSet();
                Sets.SetView missingMods = Sets.difference(names.keySet(), (Set)modVersions.keySet());
                if (!missingMods.isEmpty()) {
                    FMLLog.severe((String)"The mod %s (%s) requires mods %s to be available", (Object[])new Object[]{mod.getModId(), mod.getName(), missingMods});
                    for (String modid : missingMods) {
                        versionMissingMods.add((ArtifactVersion)names.get(modid));
                    }
                    throw new MissingModsException((Set)versionMissingMods);
                }
                reqList.putAll((Object)mod.getModId(), names.keySet());
                ImmutableList allDeps = ImmutableList.builder().addAll((Iterable)mod.getDependants()).addAll((Iterable)mod.getDependencies()).build();
                for (ArtifactVersion v : allDeps) {
                    if (!modVersions.containsKey((Object)v.getLabel()) || v.containsVersion((ArtifactVersion)modVersions.get((Object)v.getLabel()))) continue;
                    versionMissingMods.add(v);
                }
                if (versionMissingMods.isEmpty()) continue;
                FMLLog.severe((String)"The mod %s (%s) requires mod versions %s to be available", (Object[])new Object[]{mod.getModId(), mod.getName(), versionMissingMods});
                throw new MissingModsException((Set)versionMissingMods);
            }
            FMLLog.finer((String)"All mod requirements are satisfied", (Object[])new Object[0]);
            this.reverseDependencies = (ListMultimap)Multimaps.invertFrom((Multimap)reqList, (Multimap)ArrayListMultimap.create());
            ModSorter modSorter = new ModSorter(this.getActiveModList(), this.namedMods);
            try {
                FMLLog.finer((String)"Sorting mods into an ordered list", (Object[])new Object[0]);
                List sortedMods = modSorter.sort();
                this.modController.getActiveModList().clear();
                this.modController.getActiveModList().addAll(sortedMods);
                this.mods.removeAll(sortedMods);
                sortedMods.addAll(this.mods);
                this.mods = sortedMods;
                FMLLog.finer((String)"Mod sorting completed successfully", (Object[])new Object[0]);
            }
            catch (ModSortingException sortException) {
                FMLLog.severe((String)"A dependency cycle was detected in the input mod set so an ordering cannot be determined", (Object[])new Object[0]);
                ModSortingException.SortingExceptionData exceptionData = sortException.getExceptionData();
                FMLLog.severe((String)"The first mod in the cycle is %s", (Object[])new Object[]{exceptionData.getFirstBadNode()});
                FMLLog.severe((String)"The mod cycle involves", (Object[])new Object[0]);
                for (ModContainer mc : exceptionData.getVisitedNodes()) {
                    FMLLog.severe((String)"%s : before: %s, after: %s", (Object[])new Object[]{mc.toString(), mc.getDependants(), mc.getDependencies()});
                }
                FMLLog.log((Level)Level.ERROR, (Throwable)sortException, (String)"The full error", (Object[])new Object[0]);
                throw sortException;
            }
        }
        catch (Throwable throwable) {
            FMLLog.fine((String)"Mod sorting data", (Object[])new Object[0]);
            int unprintedMods = this.mods.size();
            for (ModContainer mod : this.getActiveModList()) {
                if (mod.isImmutable()) continue;
                FMLLog.fine((String)"\t%s(%s:%s): %s (%s)", (Object[])new Object[]{mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName(), mod.getSortingRules()});
                --unprintedMods;
            }
            if (unprintedMods == this.mods.size()) {
                FMLLog.fine((String)"No user mods found to sort", (Object[])new Object[0]);
            }
            throw throwable;
        }
        FMLLog.fine((String)"Mod sorting data", (Object[])new Object[0]);
        int unprintedMods = this.mods.size();
        for (ModContainer modContainer : this.getActiveModList()) {
            if (modContainer.isImmutable()) continue;
            FMLLog.fine((String)"\t%s(%s:%s): %s (%s)", (Object[])new Object[]{modContainer.getModId(), modContainer.getName(), modContainer.getVersion(), modContainer.getSource().getName(), modContainer.getSortingRules()});
            --unprintedMods;
        }
        if (unprintedMods == this.mods.size()) {
            FMLLog.fine((String)"No user mods found to sort", (Object[])new Object[0]);
        }
    }

    @Shadow
    private ModDiscoverer identifyMods() {
        FMLLog.fine((String)"Building injected Mod Containers %s", (Object[])new Object[]{injectedContainers});
        this.mods.add((ModContainer)new InjectedModContainer((ModContainer)this.mcp, new File("minecraft.jar")));
        for (String cont : injectedContainers) {
            ModContainer mc;
            try {
                mc = (ModContainer)Class.forName(cont, true, (ClassLoader)this.modClassLoader).newInstance();
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"A problem occured instantiating the injected mod container %s", (Object[])new Object[]{cont});
                throw new LoaderException((Throwable)e);
            }
            this.mods.add((ModContainer)new InjectedModContainer(mc, mc.getSource()));
        }
        ModDiscoverer discoverer = new ModDiscoverer();
        FMLLog.fine((String)"Attempting to load mods contained in the minecraft jar file and associated classes", (Object[])new Object[0]);
        discoverer.findClasspathMods(this.modClassLoader);
        FMLLog.fine((String)"Minecraft jar mods loaded successfully", (Object[])new Object[0]);
        FMLLog.getLogger().log(Level.INFO, "Found {} mods from the command line. Injecting into mod discoverer", (Object)ModListHelper.additionalMods.size());
        FMLLog.info((String)"Searching %s for mods", (Object[])new Object[]{this.canonicalModsDir.getAbsolutePath()});
        discoverer.findModDirMods(this.canonicalModsDir, ModListHelper.additionalMods.values().toArray(new File[0]));
        File versionSpecificModsDir = new File(this.canonicalModsDir, mccversion);
        if (versionSpecificModsDir.isDirectory()) {
            FMLLog.info((String)"Also searching %s for mods", (Object[])new Object[]{versionSpecificModsDir});
            discoverer.findModDirMods(versionSpecificModsDir);
        }
        this.mods.addAll(discoverer.identifyMods());
        this.identifyDuplicates(this.mods);
        this.namedMods = Maps.uniqueIndex(this.mods, (Function)new ModIdFunction());
        FMLLog.info((String)"Forge Mod Loader has identified %d mod%s to load", (Object[])new Object[]{this.mods.size(), this.mods.size() != 1 ? "s" : ""});
        return discoverer;
    }

    @Shadow
    private void identifyDuplicates(List<ModContainer> mods) {
        TreeMultimap dupsearch = TreeMultimap.create((Comparator)new Classers.ModIdComparator(), (Comparator)Ordering.arbitrary());
        for (ModContainer mc : mods) {
            if (mc.getSource() == null) continue;
            dupsearch.put((Object)mc, (Object)mc.getSource());
        }
        ImmutableMultiset duplist = Multisets.copyHighestCountFirst((Multiset)dupsearch.keys());
        LinkedHashMultimap dupes = LinkedHashMultimap.create();
        for (Multiset.Entry e : duplist.entrySet()) {
            if (e.getCount() <= 1) continue;
            FMLLog.severe((String)"Found a duplicate mod %s at %s", (Object[])new Object[]{((ModContainer)e.getElement()).getModId(), dupsearch.get((Object)((ModContainer)e.getElement()))});
            dupes.putAll((Object)((ModContainer)e.getElement()), (Iterable)dupsearch.get((Object)((ModContainer)e.getElement())));
        }
        if (!dupes.isEmpty()) {
            throw new DuplicateModsFoundException((SetMultimap)dupes);
        }
    }

    @Shadow
    private void initializeLoader() {
        boolean dirMade;
        String canonicalConfigPath;
        String canonicalModsPath;
        File modsDir = new File(minecraftDir, "mods");
        File configDir = new File(minecraftDir, "config");
        try {
            canonicalModsPath = modsDir.getCanonicalPath();
            canonicalConfigPath = configDir.getCanonicalPath();
            this.canonicalConfigDir = configDir.getCanonicalFile();
            this.canonicalModsDir = modsDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            FMLLog.log((Level)Level.ERROR, (Throwable)ioe, (String)"Failed to resolve loader directories: mods : %s ; config %s", (Object[])new Object[]{this.canonicalModsDir.getAbsolutePath(), configDir.getAbsolutePath()});
            throw new LoaderException((Throwable)ioe);
        }
        if (!this.canonicalModsDir.exists()) {
            FMLLog.info((String)"No mod directory found, creating one: %s", (Object[])new Object[]{canonicalModsPath});
            dirMade = this.canonicalModsDir.mkdir();
            if (!dirMade) {
                FMLLog.severe((String)"Unable to create the mod directory %s", (Object[])new Object[]{canonicalModsPath});
                throw new LoaderException(String.format("Unable to create the mod directory %s", canonicalModsPath));
            }
            FMLLog.info((String)"Mod directory created successfully", (Object[])new Object[0]);
        }
        if (!this.canonicalConfigDir.exists()) {
            FMLLog.fine((String)"No config directory found, creating one: %s", (Object[])new Object[]{canonicalConfigPath});
            dirMade = this.canonicalConfigDir.mkdir();
            if (!dirMade) {
                FMLLog.severe((String)"Unable to create the config directory %s", (Object[])new Object[]{canonicalConfigPath});
                throw new LoaderException();
            }
            FMLLog.info((String)"Config directory created successfully", (Object[])new Object[0]);
        }
        if (!this.canonicalModsDir.isDirectory()) {
            FMLLog.severe((String)"Attempting to load mods from %s, which is not a directory", (Object[])new Object[]{canonicalModsPath});
            throw new LoaderException();
        }
        if (!configDir.isDirectory()) {
            FMLLog.severe((String)"Attempting to load configuration from %s, which is not a directory", (Object[])new Object[]{canonicalConfigPath});
            throw new LoaderException();
        }
        this.readInjectedDependencies();
    }

    @Shadow
    public List<ModContainer> getModList() {
        return MixinLoader.optimizationsAndTweaks$instance().mods != null ? ImmutableList.copyOf(MixinLoader.optimizationsAndTweaks$instance().mods) : ImmutableList.of();
    }

    @Overwrite(remap=false)
    public void loadMods() {
        this.progressBar = ProgressManager.push((String)"Loading", (int)7);
        this.progressBar.step("Constructing Mods");
        this.initializeLoader();
        this.mods = Lists.newArrayList();
        this.namedMods = Maps.newHashMap();
        this.modController = new LoadController(this.optimizationsAndTweaks$loader);
        this.modController.transition(LoaderState.LOADING, false);
        this.discoverer = this.identifyMods();
        ModAPIManager.INSTANCE.manageAPI(this.modClassLoader, this.discoverer);
        this.disableRequestedMods();
        this.modController.distributeStateMessage(FMLLoadEvent.class);
        this.sortModList();
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.modController.getActiveModList());
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.mods);
        this.mods = ImmutableList.copyOf(this.mods);
        for (File nonMod : this.discoverer.getNonModLibs()) {
            if (!nonMod.isFile()) continue;
            FMLLog.info((String)"FML has found a non-mod file %s in your mods directory. It will now be injected into your classpath. This could severe stability issues, it should be removed if possible.", (Object[])new Object[]{nonMod.getName()});
            try {
                this.modClassLoader.addFile(nonMod);
            }
            catch (MalformedURLException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Encountered a weird problem with non-mod file injection : %s", (Object[])new Object[]{nonMod.getName()});
            }
        }
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        this.modController.distributeStateMessage(LoaderState.CONSTRUCTING, new Object[]{this.modClassLoader, this.discoverer.getASMTable(), this.reverseDependencies});
        ArrayList mods = Lists.newArrayList();
        mods.addAll(this.getActiveModList());
        mods.sort(Comparator.comparing(ModContainer::getModId));
        FMLLog.fine((String)"Mod signature data", (Object[])new Object[0]);
        FMLLog.fine((String)" \tValid Signatures:", (Object[])new Object[0]);
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() == null) continue;
            FMLLog.fine((String)"\t\t(%s) %s\t(%s\t%s)\t%s", (Object[])new Object[]{CertificateHelper.getFingerprint((Certificate)mod.getSigningCertificate()), mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName()});
        }
        FMLLog.fine((String)" \tMissing Signatures:", (Object[])new Object[0]);
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() != null) continue;
            FMLLog.fine((String)"\t\t%s\t(%s\t%s)\t%s", (Object[])new Object[]{mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName()});
        }
        if (this.getActiveModList().isEmpty()) {
            FMLLog.fine((String)"No user mod signature data found", (Object[])new Object[0]);
        }
        this.progressBar.step("Initializing mods Phase 1");
        this.modController.transition(LoaderState.PREINITIALIZATION, false);
    }

    @Overwrite(remap=false)
    public void preinitializeMods() {
        if (!this.modController.isInState(LoaderState.PREINITIALIZATION)) {
            FMLLog.warning((String)"There were errors previously. Not beginning mod initialization phase", (Object[])new Object[0]);
            return;
        }
        ObjectHolderRegistry.INSTANCE.findObjectHolders(this.discoverer.getASMTable());
        ItemStackHolderInjector.INSTANCE.findHolders(this.discoverer.getASMTable());
        this.modController.distributeStateMessage(LoaderState.PREINITIALIZATION, new Object[]{this.discoverer.getASMTable(), this.canonicalConfigDir});
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.transition(LoaderState.INITIALIZATION, false);
        this.progressBar.step("Initializing Minecraft Engine");
    }

    @Shadow
    private void disableRequestedMods() {
        String forcedModList = System.getProperty("fml.modStates", "");
        FMLLog.finer((String)"Received a system property request '%s'", (Object[])new Object[]{forcedModList});
        Map sysPropertyStateList = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)";:")).omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)forcedModList);
        FMLLog.finer((String)"System property request managing the state of %d mods", (Object[])new Object[]{sysPropertyStateList.size()});
        HashMap modStates = Maps.newHashMap();
        this.forcedModFile = new File(this.canonicalConfigDir, "fmlModState.properties");
        Properties forcedModListProperties = new Properties();
        if (this.forcedModFile.exists() && this.forcedModFile.isFile()) {
            FMLLog.finer((String)"Found a mod state file %s", (Object[])new Object[]{this.forcedModFile.getName()});
            try {
                forcedModListProperties.load(new FileReader(this.forcedModFile));
                FMLLog.finer((String)"Loaded states for %d mods from file", (Object[])new Object[]{forcedModListProperties.size()});
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.INFO, (Throwable)e, (String)"An error occurred reading the fmlModState.properties file", (Object[])new Object[0]);
            }
        }
        modStates.putAll(Maps.fromProperties((Properties)forcedModListProperties));
        modStates.putAll(sysPropertyStateList);
        FMLLog.fine((String)"After merging, found state information for %d mods", (Object[])new Object[]{modStates.size()});
        Map isEnabled = Maps.transformValues((Map)modStates, (Function)new Function<String, Boolean>(){

            public Boolean apply(String input) {
                return Boolean.parseBoolean(input);
            }
        });
        for (Map.Entry entry2 : isEnabled.entrySet()) {
            if (!this.namedMods.containsKey(entry2.getKey())) continue;
            FMLLog.info((String)"Setting mod %s to enabled state %b", (Object[])new Object[]{entry2.getKey(), entry2.getValue()});
            this.namedMods.get(entry2.getKey()).setEnabledState(((Boolean)entry2.getValue()).booleanValue());
        }
    }

    @Shadow
    public static boolean isModLoaded(String modname) {
        return MixinLoader.optimizationsAndTweaks$instance().namedMods.containsKey(modname) && MixinLoader.optimizationsAndTweaks$instance().modController.getModState(MixinLoader.optimizationsAndTweaks$instance.namedMods.get(modname)) != LoaderState.ModState.DISABLED;
    }

    @Shadow
    public File getConfigDir() {
        return this.canonicalConfigDir;
    }

    @Shadow
    public String getCrashInformation() {
        if (this.modController == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        List branding = FMLCommonHandler.instance().getBrandings(false);
        Joiner.on((char)' ').skipNulls().appendTo(ret, (Iterable)branding);
        if (this.modController != null) {
            this.modController.printModStates(ret);
        }
        return ret.toString();
    }

    @Shadow
    public String getFMLVersionString() {
        return "7.10.99.99";
    }

    @Shadow
    public ClassLoader getModClassLoader() {
        return this.modClassLoader;
    }

    @Shadow
    public void computeDependencies(String dependencyString, Set<ArtifactVersion> requirements, List<ArtifactVersion> dependencies, List<ArtifactVersion> dependants) {
        if (dependencyString == null || dependencyString.length() == 0) {
            return;
        }
        boolean parseFailure = false;
        for (String dep : DEPENDENCYSPLITTER.split((CharSequence)dependencyString)) {
            ArrayList depparts = Lists.newArrayList((Iterable)DEPENDENCYPARTSPLITTER.split((CharSequence)dep));
            if (depparts.size() != 2) {
                parseFailure = true;
                continue;
            }
            String instruction = (String)depparts.get(0);
            String target = (String)depparts.get(1);
            boolean targetIsAll = target.startsWith("*");
            if (targetIsAll && target.length() > 1) {
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(instruction) || "required-after".equals(instruction)) {
                if (!targetIsAll) {
                    requirements.add(VersionParser.parseVersionReference((String)target));
                } else {
                    parseFailure = true;
                    continue;
                }
            }
            if (targetIsAll && target.indexOf(64) > -1) {
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(instruction) || "before".equals(instruction)) {
                dependants.add(VersionParser.parseVersionReference((String)target));
                continue;
            }
            if ("required-after".equals(instruction) || "after".equals(instruction)) {
                dependencies.add(VersionParser.parseVersionReference((String)target));
                continue;
            }
            parseFailure = true;
        }
        if (parseFailure) {
            FMLLog.log((Level)Level.WARN, (String)"Unable to parse dependency string %s", (Object[])new Object[]{dependencyString});
            throw new LoaderException(String.format("Unable to parse dependency string %s", dependencyString));
        }
    }

    @Shadow
    public Map<String, ModContainer> getIndexedModList() {
        return ImmutableMap.copyOf(this.namedMods);
    }

    @Shadow
    public void initializeMods() {
        this.progressBar.step("Initializing mods Phase 2");
        this.modController.distributeStateMessage(LoaderState.INITIALIZATION, new Object[0]);
        this.progressBar.step("Initializing mods Phase 3");
        this.modController.transition(LoaderState.POSTINITIALIZATION, false);
        this.modController.distributeStateMessage(FMLInterModComms.IMCEvent.class);
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.distributeStateMessage(LoaderState.POSTINITIALIZATION, new Object[0]);
        this.progressBar.step("Finishing up");
        this.modController.transition(LoaderState.AVAILABLE, false);
        this.modController.distributeStateMessage(LoaderState.AVAILABLE, new Object[0]);
        GameData.freezeData();
        GameData.dumpRegistry((File)minecraftDir);
        FMLLog.info((String)"Forge Mod Loader has successfully loaded %d mod%s", (Object[])new Object[]{this.mods.size(), this.mods.size() == 1 ? "" : "s"});
        this.progressBar.step("Completing Minecraft initialization");
    }

    @Shadow
    public ICrashCallable getCallableCrashInformation() {
        return new ICrashCallable(){

            public String call() throws Exception {
                return MixinLoader.this.getCrashInformation();
            }

            public String getLabel() {
                return "FML";
            }
        };
    }

    @Shadow
    public List<ModContainer> getActiveModList() {
        return this.modController != null ? this.modController.getActiveModList() : ImmutableList.of();
    }

    @Shadow
    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return this.modController.getModState(selectedMod);
    }

    @Shadow
    public String getMCVersionString() {
        return "Minecraft " + mccversion;
    }

    @Shadow
    public boolean serverStarting(Object server) {
        try {
            this.modController.distributeStateMessage(LoaderState.SERVER_STARTING, new Object[]{server});
            this.modController.transition(LoaderState.SERVER_STARTING, false);
        }
        catch (Throwable t) {
            FMLLog.log((Level)Level.ERROR, (Throwable)t, (String)"A fatal exception occurred during the server starting event", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    @Shadow
    public void serverStarted() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STARTED, false);
    }

    @Shadow
    public void serverStopping() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPING, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPING, false);
    }

    @Shadow
    public BiMap<ModContainer, Object> getModObjectList() {
        return this.modController.getModObjectList();
    }

    @Shadow
    public BiMap<Object, ModContainer> getReversedModObjectList() {
        return this.getModObjectList().inverse();
    }

    @Shadow
    public ModContainer activeModContainer() {
        return this.modController != null ? this.modController.activeContainer() : null;
    }

    @Shadow
    public boolean isInState(LoaderState state) {
        return this.modController.isInState(state);
    }

    @Shadow
    public MinecraftDummyContainer getMinecraftModContainer() {
        return this.minecraft;
    }

    @Shadow
    public String getMCPVersionString() {
        return String.format("MCP v%s", mcpversion);
    }

    @Shadow
    public void serverStopped() {
        GameData.revertToFrozen();
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPED, true);
        this.modController.transition(LoaderState.AVAILABLE, true);
    }

    @Shadow
    public boolean serverAboutToStart(Object server) {
        try {
            this.modController.distributeStateMessage(LoaderState.SERVER_ABOUT_TO_START, new Object[]{server});
            this.modController.transition(LoaderState.SERVER_ABOUT_TO_START, false);
        }
        catch (Throwable t) {
            FMLLog.log((Level)Level.ERROR, (Throwable)t, (String)"A fatal exception occurred during the server about to start event", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    @Shadow
    public Map<String, String> getFMLBrandingProperties() {
        if (this.fmlBrandingProperties == null) {
            Properties loaded = new Properties();
            try {
                loaded.load(this.getClass().getClassLoader().getResourceAsStream("fmlbranding.properties"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fmlBrandingProperties = Maps.fromProperties((Properties)loaded);
        }
        return this.fmlBrandingProperties;
    }

    @Shadow
    public Map<String, String> getCustomModProperties(String modId) {
        return this.getIndexedModList().get(modId).getCustomModProperties();
    }

    @Shadow
    boolean checkRemoteModList(Map<String, String> modList, Side side) {
        Set<String> remoteModIds = modList.keySet();
        Set<String> localModIds = this.namedMods.keySet();
        LinkedHashSet difference = Sets.newLinkedHashSet((Iterable)Sets.difference(localModIds, remoteModIds));
        Iterator iterator = difference.iterator();
        while (iterator.hasNext()) {
            String missingRemotely = (String)iterator.next();
            LoaderState.ModState modState = this.modController.getModState(this.namedMods.get(missingRemotely));
            if (modState != LoaderState.ModState.DISABLED) continue;
            iterator.remove();
        }
        FMLLog.info((String)"Attempting connection with missing mods %s at %s", (Object[])new Object[]{difference, side});
        return true;
    }

    @Shadow
    public List<String> fireMissingMappingEvent(LinkedHashMap<String, Integer> missing, boolean isLocalWorld, GameData gameData, Map<String, Integer[]> remaps) {
        if (missing.isEmpty()) {
            return ImmutableList.of();
        }
        FMLLog.fine((String)"There are %d mappings missing - attempting a mod remap", (Object[])new Object[]{missing.size()});
        ArrayListMultimap missingMappings = ArrayListMultimap.create();
        for (Map.Entry<String, Integer> mapping : missing.entrySet()) {
            int id = mapping.getValue();
            FMLMissingMappingsEvent.MissingMapping m = new FMLMissingMappingsEvent.MissingMapping(mapping.getKey(), id);
            missingMappings.put((Object)m.name.substring(0, m.name.indexOf(58)), (Object)m);
        }
        FMLMissingMappingsEvent missingEvent = new FMLMissingMappingsEvent((ListMultimap)missingMappings);
        this.modController.propogateStateMessage((FMLEvent)missingEvent);
        if (isLocalWorld) {
            boolean didWarn = false;
            for (FMLMissingMappingsEvent.MissingMapping mapping : missingMappings.values()) {
                if (mapping.getAction() != FMLMissingMappingsEvent.Action.DEFAULT) continue;
                if (!didWarn) {
                    FMLLog.severe((String)"There are unidentified mappings in this world - we are going to attempt to process anyway", (Object[])new Object[0]);
                    didWarn = true;
                }
                FMLLog.severe((String)"Unidentified %s: %s, id %d", (Object[])new Object[]{mapping.type == GameRegistry.Type.BLOCK ? "block" : "item", mapping.name, mapping.id});
            }
        } else {
            ArrayList<String> missedMapping = new ArrayList<String>();
            for (FMLMissingMappingsEvent.MissingMapping mapping : missingMappings.values()) {
                if (mapping.getAction() != FMLMissingMappingsEvent.Action.DEFAULT) continue;
                missedMapping.add(mapping.name);
            }
            if (!missedMapping.isEmpty()) {
                return ImmutableList.copyOf(missedMapping);
            }
        }
        return GameData.processIdRematches((Iterable)missingMappings.values(), (boolean)isLocalWorld, (GameData)gameData, remaps);
    }

    @Shadow
    public void fireRemapEvent(Map<String, Integer[]> remaps) {
        this.modController.propogateStateMessage((FMLEvent)new FMLModIdMappingEvent(remaps));
    }

    @Shadow
    public void loadingComplete() {
        ProgressManager.pop((ProgressManager.ProgressBar)this.progressBar);
        this.progressBar = null;
    }

    @Shadow
    private void readInjectedDependencies() {
        File injectedDepFile = new File(this.getConfigDir(), "injectedDependencies.json");
        if (!injectedDepFile.exists()) {
            FMLLog.getLogger().log(Level.DEBUG, "File {} not found. No dependencies injected", (Object)injectedDepFile.getAbsolutePath());
            return;
        }
        JsonParser parser = new JsonParser();
        try {
            JsonElement injectedDeps = parser.parse((Reader)new FileReader(injectedDepFile));
            for (JsonElement el : injectedDeps.getAsJsonArray()) {
                JsonObject jo = el.getAsJsonObject();
                String modId = jo.get("modId").getAsString();
                JsonArray deps = jo.get("deps").getAsJsonArray();
                for (JsonElement dep : deps) {
                    JsonObject depObj = dep.getAsJsonObject();
                    String type = depObj.get("type").getAsString();
                    if (type.equals("before")) {
                        this.injectedBefore.put((Object)modId, (Object)VersionParser.parseVersionReference((String)depObj.get("target").getAsString()));
                        continue;
                    }
                    if (type.equals("after")) {
                        this.injectedAfter.put((Object)modId, (Object)VersionParser.parseVersionReference((String)depObj.get("target").getAsString()));
                        continue;
                    }
                    FMLLog.getLogger().log(Level.ERROR, "Invalid dependency type {}", (Object)type);
                    throw new RuntimeException("Unable to parse type");
                }
            }
        }
        catch (Exception e) {
            FMLLog.getLogger().log(Level.ERROR, "Unable to parse {} - skipping", (Object)injectedDepFile);
            FMLLog.getLogger().throwing(Level.ERROR, (Throwable)e);
            return;
        }
        FMLLog.getLogger().log(Level.DEBUG, "Loaded {} injected dependencies on modIds: {}", (Object)this.injectedBefore.size(), (Object)this.injectedBefore.keySet());
    }

    @Shadow
    List<ArtifactVersion> getInjectedBefore(String modId) {
        return this.injectedBefore.get((Object)modId);
    }

    @Shadow
    List<ArtifactVersion> getInjectedAfter(String modId) {
        return this.injectedAfter.get((Object)modId);
    }
}

