/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WorldGenMinable.class})
public class MixinWorldGenMinable
extends WorldGenerator {
    @Shadow
    private Block field_150519_a;
    @Shadow
    private int field_76541_b;
    @Shadow
    private Block field_150518_c;
    @Shadow
    private int mineableBlockMeta;
    @Unique
    private static final int SIN_COS_PRECISION = 360;
    @Unique
    private static final float[] SIN_TABLE = new float[360];
    @Unique
    private static final float[] COS_TABLE = new float[360];

    @Overwrite
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        float angle = random.nextFloat() * (float)Math.PI;
        double centerX = (float)(x + 8) + SIN_TABLE[MathHelper.func_76141_d((float)(angle * 360.0f)) & 0x167] * (float)this.field_76541_b / 8.0f;
        double centerY = (double)(y + random.nextInt(3)) - 2.0;
        double centerZ = (float)(z + 8) + COS_TABLE[MathHelper.func_76141_d((float)(angle * 360.0f)) & 0x167] * (float)this.field_76541_b / 8.0f;
        for (int l = 0; l <= this.field_76541_b; ++l) {
            double ellipseX = centerX - (double)(SIN_TABLE[l] * (float)this.field_76541_b) / 8.0;
            double ellipseY = centerY + random.nextDouble() * (double)this.field_76541_b / 16.0;
            double ellipseZ = centerZ - (double)(COS_TABLE[l] * (float)this.field_76541_b) / 8.0;
            this.optimizationsAndTweaks$generateEllipseLayer(world, ellipseX, ellipseY, ellipseZ);
        }
        return true;
    }

    @Unique
    private void optimizationsAndTweaks$generateEllipseLayer(World world, double ellipseX, double ellipseY, double ellipseZ) {
        int minX = MathHelper.func_76128_c((double)(ellipseX - 1.0));
        int maxX = MathHelper.func_76128_c((double)(ellipseX + 1.0));
        int minY = MathHelper.func_76128_c((double)(ellipseY - 1.0));
        int maxY = MathHelper.func_76128_c((double)(ellipseY + 1.0));
        int minZ = MathHelper.func_76128_c((double)(ellipseZ - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(ellipseZ + 1.0));
        Block oreGenBlock = this.field_150518_c;
        if (oreGenBlock != null) {
            for (int x = minX; x <= maxX; ++x) {
                double d12 = (double)x + 0.5 - ellipseX;
                for (int y = minY; y <= maxY; ++y) {
                    double d13 = (double)y + 0.5 - ellipseY;
                    for (int z = minZ; z <= maxZ; ++z) {
                        double d14 = (double)z + 0.5 - ellipseZ;
                        if (!this.optimizationsAndTweaks$isInsideEllipse(d12, d13, d14)) continue;
                        this.optimizationsAndTweaks$processBlock(world, x, y, z);
                    }
                }
            }
        }
    }

    @Unique
    private void optimizationsAndTweaks$processBlock(World world, int x, int y, int z) {
        Block block;
        Block oreGenBlock = this.optimizationsAndTweaks$getField_150518_c();
        if (this.optimizationsAndTweaks$isReplaceableOreGen(world, x, y, z, oreGenBlock, block = this.optimizationsAndTweaks$getBlock(world, x, y, z))) {
            this.optimizationsAndTweaks$replaceBlock(world, x, y, z);
        }
    }

    @Unique
    private boolean optimizationsAndTweaks$isReplaceableOreGen(World world, int x, int y, int z, Block oreGenBlock, Block block) {
        return block.isReplaceableOreGen(world, x, y, z, oreGenBlock);
    }

    @Unique
    private void optimizationsAndTweaks$replaceBlock(World world, int x, int y, int z) {
        Block replaceBlock = this.field_150519_a;
        if (replaceBlock != null && world != null) {
            world.func_147465_d(x, y, z, replaceBlock, this.mineableBlockMeta, 2);
        }
    }

    @Unique
    private Block optimizationsAndTweaks$getField_150518_c() {
        return this.field_150518_c;
    }

    @Unique
    private Block optimizationsAndTweaks$getBlock(World world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        return world.func_147439_a(x, y, z);
    }

    @Unique
    private boolean optimizationsAndTweaks$isInsideEllipse(double d12, double d13, double d14) {
        return d12 * d12 + d13 * d13 + d14 * d14 < 1.0;
    }

    static {
        for (int i = 0; i < 360; ++i) {
            float angle = (float)Math.toRadians(i);
            MixinWorldGenMinable.SIN_TABLE[i] = MathHelper.func_76126_a((float)angle);
            MixinWorldGenMinable.COS_TABLE[i] = MathHelper.func_76134_b((float)angle);
        }
    }
}

