/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.coroutil;

import CoroUtil.ChunkCoordinatesSize;
import CoroUtil.DimensionChunkCache;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFJobData;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.util.CoroUtilBlock;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PFQueue.class})
public abstract class MixinPFQueue
implements Runnable {
    @Shadow
    public static PFQueue instance;
    @Shadow
    public static LinkedList<PFJobData> queue;
    @Shadow
    public static HashMap pfDelays;
    @Shadow
    public static long lastCacheUpdate;

    @Shadow
    public static boolean tryPath(Entity var1, int x, int y, int z, float var2, int priority, IPFCallback parCallback) {
        return MixinPFQueue.tryPath(var1, x, y, z, var2, priority, parCallback, null);
    }

    @Overwrite
    public static boolean tryPath(PFJobData parJob) {
        boolean tryPath;
        parJob.initData();
        if (instance == null) {
            new PFQueue(null);
        }
        if (lastCacheUpdate < System.currentTimeMillis()) {
            lastCacheUpdate = System.currentTimeMillis() + 10000L;
            DimensionChunkCache.updateAllWorldCache();
        }
        int delay = 3000 + queue.size() * 20;
        boolean bl = tryPath = parJob.sourceEntity == null || MixinPFQueue.optimizationsAndTweaks$updateDelay(parJob.sourceEntity, delay);
        if (!tryPath && parJob.priority != -1) {
            return false;
        }
        try {
            MixinPFQueue.optimizationsAndTweaks$addToQueue(parJob);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unique
    private static boolean optimizationsAndTweaks$updateDelay(Entity entity, int delay) {
        if (pfDelays.containsKey(entity)) {
            long time;
            long l = time = pfDelays.get(entity) != null ? (Long)pfDelays.get(entity) : 0L;
            if (time >= System.currentTimeMillis()) return false;
            pfDelays.put(entity, System.currentTimeMillis() + (long)delay);
            return true;
        } else {
            pfDelays.put(entity, System.currentTimeMillis() + (long)delay);
        }
        return true;
    }

    @Unique
    private static void optimizationsAndTweaks$addToQueue(PFJobData parJob) {
        if (parJob.priority == 0) {
            queue.addLast(parJob);
        } else if (parJob.priority == -1) {
            queue.addFirst(parJob);
        } else {
            int pos = 0;
            while (!queue.isEmpty() && parJob.priority < MixinPFQueue.queue.get((int)pos).priority) {
                ++pos;
            }
            queue.add(pos, parJob);
        }
    }

    @Overwrite
    public static boolean tryPath(Entity entity, int x, int y, int z, float var2, int priority, IPFCallback parCallback, ChunkCoordinatesSize parCoordSize) {
        long currentTime;
        if (entity != null && CoroUtilBlock.isAir((Block)entity.field_70170_p.func_147439_a(x, y - 1, z))) {
            while (y > 0 && CoroUtilBlock.isAir((Block)entity.field_70170_p.func_147439_a(x, y--, z))) {
            }
        }
        if (instance == null) {
            if (entity == null) {
                return false;
            }
            new PFQueue(null);
        }
        if (lastCacheUpdate < (currentTime = System.currentTimeMillis())) {
            lastCacheUpdate = currentTime + 10000L;
            DimensionChunkCache.updateAllWorldCache();
        }
        int delay = 3000 + queue.size() * 20;
        boolean tryPath = true;
        Long entityDelay = (Long)pfDelays.get(entity);
        if (entityDelay == null || entityDelay < currentTime) {
            pfDelays.put(entity, currentTime + (long)delay);
        } else {
            tryPath = false;
        }
        if (!tryPath && priority != -1) {
            return false;
        }
        PFJobData job = MixinPFQueue.optimizationsAndTweaks$createPFJob(entity, x, y, z, var2, parCallback, parCoordSize);
        try {
            if (priority == 0) {
                queue.addLast(job);
            } else if (priority == -1) {
                queue.addFirst(job);
            } else {
                int pos = 0;
                while (!queue.isEmpty() && priority < MixinPFQueue.queue.get((int)pos).priority) {
                    ++pos;
                }
                queue.add(pos, job);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Unique
    private static PFJobData optimizationsAndTweaks$createPFJob(Entity entity, int x, int y, int z, float var2, IPFCallback parCallback, ChunkCoordinatesSize parCoordSize) {
        PFJobData job;
        if (entity != null) {
            job = new PFJobData(entity, x, y, z, var2);
        } else if (parCoordSize != null) {
            job = new PFJobData(parCoordSize, x, y, z, var2);
        } else {
            System.out.println("Invalid use of PFQueue");
            return null;
        }
        job.callback = parCallback;
        job.canUseLadder = true;
        return job;
    }

    static {
        pfDelays = new HashMap();
        lastCacheUpdate = 0L;
    }
}

