/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.familliarsAPI;

import de.pitman87.FamiliarsAPI.common.ConfigHandler;
import de.pitman87.FamiliarsAPI.common.FamiliarsAPI;
import de.pitman87.FamiliarsAPI.common.entity.Familiar;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Familiar.class})
public class MixinFamiliar
extends EntityLiving
implements IAnimals {
    @Unique
    private static final int MAX_AGE = 628;
    @Unique
    private Familiar familiar;
    @Shadow
    public EntityPlayer player;
    @Shadow
    public int maxDistanceToPlayer;
    @Shadow
    protected Entity entityToAttack;
    @Shadow
    protected boolean hasAttacked;
    @Shadow
    public int attackDelay;
    @Shadow
    public int attackRangeX;
    @Shadow
    public int attackRangeY;
    @Shadow
    public float posYOffset;
    @Shadow
    public boolean usesSaveFile;
    @Shadow
    public int age;

    public MixinFamiliar(World world, Familiar familiar) {
        super(world);
        this.familiar = familiar;
        this.age = 0;
        this.field_70178_ae = true;
        this.func_70105_a(0.1f, 0.1f);
        this.maxDistanceToPlayer = 40;
        this.attackRangeX = 15;
        this.attackRangeY = this.attackRangeX / 2;
        this.attackDelay = 60;
        this.posYOffset = 0.0f;
        this.usesSaveFile = false;
        this.field_70155_l = 10.0;
    }

    @Overwrite(remap=false)
    public void func_70636_d() {
        ++this.age;
        if (this.age >= 628) {
            this.age = 0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.multithreadingandtweaks$checkAndUpdatePlayerFamiliar();
        } else {
            this.updateHeadRotation();
        }
        if (this.player != null) {
            this.multithreadingandtweaks$handlePlayer();
        }
    }

    @Unique
    private void multithreadingandtweaks$checkAndUpdatePlayerFamiliar() {
        if (this.player == null && this.getOwner() != null) {
            this.player = this.getOwner();
            FamiliarsAPI.proxy.checkPlayersFamiliar(this.familiar, this.getOwnerName());
        }
    }

    @Unique
    private void multithreadingandtweaks$handlePlayer() {
        this.field_70143_R = 0.0f;
        if (this.player == null || this.player.field_70128_L || this.field_70170_p != this.player.field_70170_p) {
            this.func_70106_y();
            return;
        }
        if (this.field_70724_aR > 0) {
            --this.field_70724_aR;
        }
        this.followPlayer();
        this.func_70626_be();
        if (ConfigHandler.abilitiesEnabledGlobal && FamiliarsAPI.proxy.useAbility(this.getOwner())) {
            this.updateAbility();
        }
    }

    @Shadow
    public void updateAbility() {
    }

    @Overwrite(remap=false)
    public void func_70612_e(float par1, float par2) {
        float var3 = 0.91f;
        float var8 = 0.16277136f / (var3 * var3 * var3);
        float var5 = this.func_70650_aV() ? this.func_70689_ay() : this.field_70747_aH;
        this.func_70060_a(par1, par2, var5 *= var8);
        var3 = 0.91f;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)var3;
        this.field_70179_y *= (double)var3;
        this.field_70722_aY = this.field_70721_aZ;
        double var9 = this.field_70165_t - this.field_70169_q;
        double var12 = this.field_70161_v - this.field_70166_s;
        float var11 = MathHelper.func_76133_a((double)(var9 * var9 + var12 * var12)) * 4.0f;
        if (var11 > 1.0f) {
            var11 = 1.0f;
        }
        this.field_70721_aZ += (var11 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    @Overwrite(remap=false)
    private void updateHeadRotation() {
        if (this.field_70716_bi > 0) {
            double deltaRotation = this.field_70712_bm - (double)this.field_70177_z;
            deltaRotation = (deltaRotation + 180.0) % 360.0 - 180.0;
            this.field_70177_z = (float)((double)this.field_70177_z + deltaRotation / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70705_bn - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.field_70759_as = this.field_70177_z;
    }

    @Overwrite(remap=false)
    public void spawn(EntityPlayer p) {
        this.player = p;
        this.field_70170_p = p.field_70170_p;
        this.func_70012_b(this.player.field_70165_t, this.player.field_70163_u - 1.0, this.player.field_70161_v, 0.0f, 0.0f);
        this.field_70170_p.func_72838_d((Entity)this);
        this.setOwner(this.player.getDisplayName());
        this.field_71093_bK = p.field_71093_bK;
    }

    @Overwrite(remap=false)
    public void followPlayer() {
        if (this.func_70068_e((Entity)this.player) > (double)this.maxDistanceToPlayer) {
            this.func_70634_a(this.player.field_70165_t + 0.5, this.player.field_70163_u - (double)this.posYOffset, this.player.field_70161_v + 0.5);
        } else {
            float f2 = MathHelper.func_76126_a((float)((float)this.age / 10.0f)) * 0.3f + 0.1f;
            float f = this.player.field_70761_aq * 3.141593f / 180.0f - 0.15f;
            double f1 = MathHelper.func_76134_b((float)f);
            double f3 = MathHelper.func_76126_a((float)f);
            double d = this.player.field_70165_t;
            double d1 = this.player.field_70163_u - (double)this.posYOffset;
            double d2 = this.player.field_70161_v;
            double d4 = (d - this.field_70165_t - f1) / 5.0;
            double d5 = d1 - this.field_70163_u + (double)this.player.func_70047_e() + (double)f2 / 5.0;
            double d6 = (d2 - this.field_70161_v - f3) / 5.0;
            this.func_70091_d(d4, d5, d6);
        }
    }

    @Shadow
    public void attackEntity(Entity entity, float f) {
    }

    @Overwrite(remap=false)
    public Entity findEntityToAttack() {
        Entity target = null;
        List entities = this.multithreadingandtweaks$getEntitiesWithinAttackRange();
        for (Entity entity : entities) {
            if (!this.canSetAsTarget(entity) || target != null && (!this.func_70685_l(entity) || !(this.func_70068_e(entity) < this.func_70068_e(target)))) continue;
            target = entity;
        }
        return target;
    }

    @Unique
    private List multithreadingandtweaks$getEntitiesWithinAttackRange() {
        return this.field_70170_p.func_72872_a(EntityLiving.class, this.multithreadingandtweaks$getBoundingBoxForAttackRange());
    }

    @Unique
    private AxisAlignedBB multithreadingandtweaks$getBoundingBoxForAttackRange() {
        return AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)this.attackRangeX), (double)(this.field_70163_u - (double)this.attackRangeY), (double)(this.field_70161_v - (double)this.attackRangeX), (double)(this.field_70165_t + (double)this.attackRangeX), (double)(this.field_70163_u + (double)this.attackRangeY), (double)(this.field_70161_v + (double)this.attackRangeX));
    }

    @Shadow
    public boolean canSetAsTarget(Entity entity) {
        return entity instanceof EntityLiving && !(entity instanceof Familiar);
    }

    @Shadow
    public void func_70626_be() {
        super.func_70626_be();
        this.entityToAttack = this.findEntityToAttack();
        if (this.field_70724_aR <= 0) {
            if (this.entityToAttack != null) {
                if (!this.entityToAttack.func_70089_S()) {
                    this.entityToAttack = null;
                } else if (ConfigHandler.abilitiesEnabledGlobal && FamiliarsAPI.proxy.useAbility(this.getOwner())) {
                    float f1 = this.entityToAttack.func_70032_d((Entity)this);
                    if (this.func_70685_l(this.entityToAttack)) {
                        this.attackEntity(this.entityToAttack, f1);
                    } else {
                        this.attackBlockedEntity(this.entityToAttack, f1);
                    }
                }
            }
            if (this.entityToAttack != null) {
                this.func_70625_a(this.entityToAttack, 30.0f, 30.0f);
            }
            this.field_70724_aR = this.attackDelay;
            this.hasAttacked = true;
        }
    }

    @Shadow
    public void attackBlockedEntity(Entity entityToAttack2, float f1) {
    }

    @Shadow
    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(17);
    }

    @Shadow
    public void setOwner(String par1Str) {
        this.field_70180_af.func_75692_b(17, (Object)par1Str);
    }

    @Shadow
    public EntityPlayer getOwner() {
        return this.field_70170_p.func_72924_a(this.getOwnerName());
    }
}

