/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.matmos;

import eu.ha3.matmos.core.expansion.ExpansionManager;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.SheetDataPackage;
import eu.ha3.matmos.data.modules.AbstractThingCountModule;
import eu.ha3.matmos.data.modules.BlockCountModule;
import eu.ha3.matmos.data.modules.VirtualCountModule;
import eu.ha3.matmos.util.MAtUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockCountModule.class})
public class MixinBlockCountModule
extends AbstractThingCountModule<Pair<Block, Integer>> {
    @Shadow
    private static final int INITIAL_SIZE = 4096;
    @Shadow
    private boolean[] wasZero = new boolean[4096];
    @Shadow
    private int[] counts = new int[4096];
    @Shadow
    private int[] zeroMetadataCounts = new int[4096];
    @Shadow
    private TreeMap<Integer, Integer>[] metadatas = new TreeMap[4096];
    @Shadow
    int size = 4096;
    @Shadow
    VirtualCountModule<Pair<Block, Integer>> thousand;
    @Shadow
    SheetDataPackage sheetData;
    @Shadow
    int blocksCounted = 0;

    public MixinBlockCountModule(DataPackage data, String name) {
        this(data, name, false);
    }

    public MixinBlockCountModule(DataPackage data, String name, boolean doNotUseDelta) {
        this(data, name, doNotUseDelta, null);
    }

    public MixinBlockCountModule(DataPackage data, String name, boolean doNotUseDelta, VirtualCountModule<Pair<Block, Integer>> thousand) {
        super(data, name, doNotUseDelta);
        this.thousand = thousand;
        data.getSheet(name).setDefaultValue("0");
        if (!doNotUseDelta) {
            data.getSheet(name + "_delta").setDefaultValue("0");
        }
        this.sheetData = (SheetDataPackage)data;
    }

    @Shadow
    protected void doProcess() {
        this.count();
        this.apply();
    }

    @Shadow
    public void increment(Pair<Block, Integer> blockMeta) {
        this.increment(blockMeta, 1);
    }

    @Overwrite(remap=false)
    public void increment(Pair<Block, Integer> blockMeta, int amount) {
        Block block = (Block)blockMeta.getLeft();
        int meta = (Integer)blockMeta.getRight();
        int id = ExpansionManager.dealiasToID((Block)block, (DataPackage)this.sheetData);
        if (id >= this.size) {
            this.resize(id + 1);
        }
        int[] var10000 = this.counts;
        int n = id;
        var10000[n] = var10000[n] + amount;
        if (meta != -1 && meta != 0) {
            if (this.metadatas[id] == null) {
                this.metadatas[id] = new TreeMap();
            }
            Integer metaCount = this.metadatas[id].get(meta);
            this.metadatas[id].put(meta, metaCount == null ? 0 : metaCount + amount);
        } else if (meta == 0) {
            var10000 = this.zeroMetadataCounts;
            int n2 = id;
            var10000[n2] = var10000[n2] + amount;
        }
        this.blocksCounted += amount;
    }

    @Overwrite(remap=false)
    public int get(Pair<Block, Integer> blockMeta) {
        Block block = (Block)blockMeta.getLeft();
        int meta = (Integer)blockMeta.getRight();
        int id = Block.func_149682_b((Block)block);
        if (id >= this.size) {
            return 0;
        }
        return meta == -1 ? this.counts[id] : this.metadatas[id].get(meta);
    }

    @Shadow
    public void count() {
    }

    public void apply() {
        for (int i = 0; i < this.counts.length; ++i) {
            this.processCount(i, this.counts[i], false);
            this.processCount(i, this.zeroMetadataCounts[i], true);
            if (this.metadatas[i] != null) {
                this.processMetadata(i, this.metadatas[i]);
            }
            this.wasZero[i] = this.isZero(i);
        }
        this.resetValues();
    }

    @Unique
    private void processCount(int id, int count, boolean isZeroMetadata) {
        if (count > 0 || !this.wasZero[id]) {
            String name = isZeroMetadata ? MAtUtil.asPowerMeta((Block)Block.func_149729_e((int)id), (int)0) : MAtUtil.nameOf((Block)Block.func_149729_e((int)id));
            this.setValue(name, count);
            if (this.thousand != null) {
                float floatVal = (float)count / (float)this.blocksCounted * 1000.0f;
                this.thousand.setValue(name, (long)((int)Math.ceil(floatVal)));
            }
        }
    }

    @Unique
    private void processMetadata(int id, Map<Integer, Integer> metadata) {
        for (Map.Entry<Integer, Integer> entry2 : metadata.entrySet()) {
            int value = entry2.getValue();
            if (value <= 0 && this.wasZero[id]) continue;
            String name = MAtUtil.asPowerMeta((Block)Block.func_149729_e((int)id), (int)entry2.getKey());
            this.setValue(name, value);
            if (this.thousand == null) continue;
            float floatVal = (float)value / (float)this.blocksCounted * 1000.0f;
            this.thousand.setValue(name, (long)((int)Math.ceil(floatVal)));
        }
    }

    @Unique
    private boolean isZero(int index) {
        return this.counts[index] == 0 && this.zeroMetadataCounts[index] == 0 && (this.metadatas[index] == null || this.metadatas[index].values().stream().allMatch(val -> val == 0));
    }

    @Unique
    private void resetValues() {
        this.blocksCounted = 0;
        Arrays.fill(this.counts, 0);
        Arrays.fill(this.zeroMetadataCounts, 0);
        Arrays.stream(this.metadatas).filter(Objects::nonNull).forEach(m -> m.replaceAll((k, v) -> 0));
    }

    @Overwrite(remap=false)
    private void resize(int newSize) {
        int stepSize = 1024;
        newSize = (int)Math.ceil((double)newSize / (double)stepSize) * stepSize;
        this.wasZero = Arrays.copyOf(this.wasZero, newSize);
        this.counts = Arrays.copyOf(this.counts, newSize);
        this.zeroMetadataCounts = Arrays.copyOf(this.zeroMetadataCounts, newSize);
        this.metadatas = Arrays.copyOf(this.metadatas, newSize);
        this.size = newSize;
    }
}

