/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.pneumaticraft;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.Object2ObjectHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableBlock;
import pneumaticCraft.client.render.pneumaticArmor.hacking.HackableHandler;
import pneumaticCraft.common.HackTickHandler;
import pneumaticCraft.common.util.WorldAndCoord;

@Mixin(value={HackTickHandler.class})
public class MixinHackTickHandler {
    @Final
    @Unique
    private final Object2ObjectHashMap<WorldAndCoord, IHackableBlock> optimizationsAndTweaks$hackedBlocks = new Object2ObjectHashMap();
    @Unique
    private final Object2ObjectHashMap<Class<? extends IHackableBlock>, Block> optimizationsAndTweaks$hackableBlockMap = new Object2ObjectHashMap();
    @Unique
    private final Object2ObjectHashMap<Entity, HackableHandler.HackingEntityProperties> optimizationsAndTweaks$entityPropertiesMap = new Object2ObjectHashMap();

    @Overwrite(remap=false)
    public void trackBlock(WorldAndCoord coord, IHackableBlock iHackable) {
        this.optimizationsAndTweaks$hackedBlocks.put(coord, iHackable);
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Object2ObjectHashMap.KeyIterator iterator = this.optimizationsAndTweaks$hackedBlocks.keySet().iterator();
            while (iterator.hasNext()) {
                WorldAndCoord hackedBlock = (WorldAndCoord)iterator.next();
                IHackableBlock hackableBlock = (IHackableBlock)this.optimizationsAndTweaks$hackableBlockMap.get(hackedBlock.getClass());
                if (hackableBlock == null || hackableBlock.afterHackTick((World)hackedBlock.world, hackedBlock.x, hackedBlock.y, hackedBlock.z)) continue;
                iterator.remove();
            }
        }
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Object entityObject : event.world.field_72996_f) {
                Entity entity;
                HackableHandler.HackingEntityProperties hackingProps;
                if (!(entityObject instanceof Entity) || (hackingProps = this.optimizationsAndTweaks$getHackingProperties(entity = (Entity)entityObject)) == null) continue;
                hackingProps.update(entity);
            }
        }
    }

    @Unique
    private HackableHandler.HackingEntityProperties optimizationsAndTweaks$getHackingProperties(Entity entity) {
        HackableHandler.HackingEntityProperties hackingProps = this.optimizationsAndTweaks$entityPropertiesMap.get(entity);
        if (hackingProps == null && (hackingProps = (HackableHandler.HackingEntityProperties)entity.getExtendedProperties("PneumaticCraftHacking")) != null) {
            this.optimizationsAndTweaks$entityPropertiesMap.put(entity, hackingProps);
        }
        return hackingProps;
    }
}

