/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.thaumcraft;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IRepairableExtended;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.items.armor.ItemHoverHarness;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.WarpEvents;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.events.EventHandlerEntity;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.EntityUtils;

@Mixin(value={EventHandlerEntity.class})
public class MixinEventHandlerEntity {
    @Shadow
    public HashMap<Integer, Float> prevStep = new HashMap();
    @Shadow
    public static HashMap<String, ArrayList<WeakReference<Entity>>> linkedEntities = new HashMap();

    @Overwrite(remap=false)
    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entity instanceof EntityPlayer)) {
            EntityMob mob;
            int a;
            if (event.entity instanceof EntityMob && !event.entity.field_70128_L && (a = (int)(mob = (EntityMob)event.entity).func_110148_a(EntityUtils.CHAMPION_MOD).func_111126_e()) >= 0 && ChampionModifier.mods[a].type == 0) {
                ChampionModifier.mods[a].effect.performEffect((EntityLivingBase)mob, null, null, 0.0f);
            }
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            this.optimizationsAndTweaks$handleStepHeight(player);
        } else {
            this.optimizationsAndTweaks$handleNonRemoteUpdates(player);
        }
    }

    @Unique
    private void optimizationsAndTweaks$handleNonRemoteUpdates(EntityPlayer player) {
        int ticksExisted = player.field_70173_aa;
        if (!Config.wuss && ticksExisted > 0 && ticksExisted % 2000 == 0 && !player.func_82165_m(Config.potionWarpWardID)) {
            WarpEvents.checkWarpEvent((EntityPlayer)player);
        }
        if (ticksExisted % 10 == 0 && player.func_82165_m(Config.potionDeathGazeID)) {
            WarpEvents.checkDeathGaze((EntityPlayer)player);
        }
        if (ticksExisted % 40 == 0) {
            this.optimizationsAndTweaks$doItemRepairs(player);
        }
    }

    @Unique
    private void optimizationsAndTweaks$doItemRepairs(EntityPlayer player) {
        int i;
        InventoryPlayer inventory = player.field_71071_by;
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77960_j() <= 0 || !(stack.func_77973_b() instanceof IRepairable) || player.field_71075_bZ.field_75098_d || stack.func_77973_b() instanceof ItemHoverHarness && i < InventoryPlayer.func_70451_h()) continue;
            MixinEventHandlerEntity.doRepair(stack, player);
        }
        for (i = 0; i < 4; ++i) {
            ItemStack armorStack = inventory.func_70440_f(i);
            if (armorStack == null || armorStack.func_77960_j() <= 0 || !(armorStack.func_77973_b() instanceof IRepairable) || player.field_71075_bZ.field_75098_d) continue;
            MixinEventHandlerEntity.doRepair(armorStack, player);
        }
    }

    @Unique
    private void optimizationsAndTweaks$handleStepHeight(EntityPlayer player) {
        if ((player.func_70093_af() || player.field_71071_by.func_70440_f(0) == null || player.field_71071_by.func_70440_f(0).func_77973_b() != ConfigItems.itemBootsTraveller) && this.prevStep.containsKey(player.func_145782_y())) {
            player.field_70138_W = this.prevStep.get(player.func_145782_y()).floatValue();
            this.prevStep.remove(player.func_145782_y());
        }
    }

    @Shadow
    public static void doRepair(ItemStack is, EntityPlayer player) {
        int level = EnchantmentHelper.func_77506_a((int)Config.enchRepair.field_77352_x, (ItemStack)is);
        if (level > 0) {
            AspectList cost;
            if (level > 2) {
                level = 2;
            }
            if ((cost = ThaumcraftCraftingManager.getObjectTags((ItemStack)is)) != null && cost.size() != 0) {
                cost = ResearchManager.reduceToPrimals((AspectList)cost);
                AspectList finalCost = new AspectList();
                for (Aspect a : cost.getAspects()) {
                    if (a == null) continue;
                    finalCost.merge(a, (int)Math.sqrt(cost.getAmount(a) * 2) * level);
                }
                if (is.func_77973_b() instanceof IRepairableExtended) {
                    if (((IRepairableExtended)is.func_77973_b()).doRepair(is, player, level) && WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)finalCost)) {
                        is.func_77972_a(-level, (EntityLivingBase)player);
                    }
                } else if (WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)finalCost)) {
                    is.func_77972_a(-level, (EntityLivingBase)player);
                }
            }
        }
    }

    @Shadow
    private void updateSpeed(EntityPlayer player) {
        try {
            int haste;
            if (!player.field_71075_bZ.field_75100_b && player.field_71071_by.func_70440_f(0) != null && player.field_70701_bs > 0.0f && (haste = EnchantmentHelper.func_77506_a((int)Config.enchHaste.field_77352_x, (ItemStack)player.field_71071_by.func_70440_f(0))) > 0) {
                float bonus = (float)haste * 0.015f;
                if (player.field_70160_al) {
                    bonus /= 2.0f;
                }
                if (player.func_70090_H()) {
                    bonus /= 2.0f;
                }
                player.func_70060_a(0.0f, 1.0f, bonus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

