/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.agrona;

import fr.iamacat.optimizationsandtweaks.utils.agrona.DirectBuffer;
import fr.iamacat.optimizationsandtweaks.utils.agrona.MutableDirectBuffer;

public class AsciiSequenceView
implements CharSequence {
    private DirectBuffer buffer;
    private int offset;
    private int length;

    public AsciiSequenceView() {
    }

    public AsciiSequenceView(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException("index=" + index + " length=" + this.length);
        }
        return (char)this.buffer.getByte(this.offset + index);
    }

    @Override
    public AsciiSequenceView subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException("start=" + start);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException("end=" + end + " length=" + this.length);
        }
        if (end - start < 0) {
            throw new StringIndexOutOfBoundsException("start=" + start + " end=" + end);
        }
        return new AsciiSequenceView(this.buffer, this.offset + start, end - start);
    }

    public AsciiSequenceView wrap(DirectBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        return this;
    }

    public void reset() {
        this.buffer = null;
        this.offset = 0;
        this.length = 0;
    }

    public int getBytes(MutableDirectBuffer dstBuffer, int dstOffset) {
        if (null == this.buffer || this.length <= 0) {
            return 0;
        }
        dstBuffer.putBytes(dstOffset, this.buffer, this.offset, this.length);
        return this.length;
    }

    @Override
    public String toString() {
        if (null == this.buffer || this.length <= 0) {
            return "";
        }
        return this.buffer.getStringWithoutLengthAscii(this.offset, this.length);
    }
}

