/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.agrona;

import fr.iamacat.optimizationsandtweaks.utils.agrona.ErrorHandler;
import fr.iamacat.optimizationsandtweaks.utils.agrona.LangUtil;
import java.util.Collection;

public final class CloseHelper {
    private CloseHelper() {
    }

    public static void quietClose(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void quietCloseAll(Collection<? extends AutoCloseable> closeables) {
        if (null != closeables) {
            for (AutoCloseable autoCloseable : closeables) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void quietCloseAll(AutoCloseable ... closeables) {
        if (null != closeables) {
            for (AutoCloseable closeable : closeables) {
                if (null == closeable) continue;
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        }
    }

    public static void closeAll(Collection<? extends AutoCloseable> closeables) {
        if (null != closeables) {
            Exception error = null;
            for (AutoCloseable autoCloseable : closeables) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception ex) {
                    if (null == error) {
                        error = ex;
                        continue;
                    }
                    error.addSuppressed(ex);
                }
            }
            if (null != error) {
                LangUtil.rethrowUnchecked(error);
            }
        }
    }

    public static void closeAll(AutoCloseable ... closeables) {
        if (null != closeables) {
            Exception error = null;
            for (AutoCloseable closeable : closeables) {
                if (null == closeable) continue;
                try {
                    closeable.close();
                }
                catch (Exception ex) {
                    if (error == null) {
                        error = ex;
                        continue;
                    }
                    error.addSuppressed(ex);
                }
            }
            if (null != error) {
                LangUtil.rethrowUnchecked(error);
            }
        }
    }

    public static void close(ErrorHandler errorHandler, AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                if (null == errorHandler) {
                    NullPointerException error = new NullPointerException("errorHandler is null");
                    error.addSuppressed(ex);
                    throw error;
                }
                errorHandler.onError(ex);
            }
        }
    }

    public static void closeAll(ErrorHandler errorHandler, Collection<? extends AutoCloseable> closeables) {
        if (null != closeables) {
            Throwable error = null;
            for (AutoCloseable autoCloseable : closeables) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception ex) {
                    if (null == errorHandler) {
                        if (null == error) {
                            error = new NullPointerException("errorHandler is null");
                        }
                        error.addSuppressed(ex);
                        continue;
                    }
                    errorHandler.onError(ex);
                }
            }
            if (null != error) {
                LangUtil.rethrowUnchecked(error);
            }
        }
    }

    public static void closeAll(ErrorHandler errorHandler, AutoCloseable ... closeables) {
        if (null != closeables) {
            Throwable error = null;
            for (AutoCloseable closeable : closeables) {
                if (null == closeable) continue;
                try {
                    closeable.close();
                }
                catch (Exception ex) {
                    if (null == errorHandler) {
                        if (null == error) {
                            error = new NullPointerException("errorHandler is null");
                        }
                        error.addSuppressed(ex);
                        continue;
                    }
                    errorHandler.onError(ex);
                }
            }
            if (null != error) {
                LangUtil.rethrowUnchecked(error);
            }
        }
    }
}

