/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.agrona.collections;

import fr.iamacat.optimizationsandtweaks.utils.agrona.BitUtil;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.CollectionUtil;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.Hashing;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class BiInt2ObjectMap<V> {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private long[] keys;
    private Object[] values;

    public BiInt2ObjectMap() {
        this(8, 0.65f);
    }

    public BiInt2ObjectMap(int initialCapacity, float loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.keys = new long[capacity];
        this.values = new Object[capacity];
    }

    public int capacity() {
        return this.values.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, null);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public V put(int keyPartA, int keyPartB, V value) {
        Object oldValue;
        Object val = this.mapNullValue(value);
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Objects.requireNonNull(val, "value cannot be null");
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (oldValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            keys[index] = key;
        }
        values[index] = val;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return this.unmapNullValue(oldValue);
    }

    protected Object mapNullValue(Object value) {
        return value;
    }

    protected V unmapNullValue(Object value) {
        return (V)value;
    }

    private V getMapping(int keyPartA, int keyPartB) {
        Object value;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V get(int keyPartA, int keyPartB) {
        return this.unmapNullValue(this.getMapping(keyPartA, keyPartB));
    }

    public V getOrDefault(int keyPartA, int keyPartB, V defaultValue) {
        V val = this.getMapping(keyPartA, keyPartB);
        return this.unmapNullValue(null != val ? val : defaultValue);
    }

    public boolean containsKey(int keyPartA, int keyPartB) {
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (null != values[index]) {
            if (key == keys[index]) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    public V remove(int keyPartA, int keyPartB) {
        Object value;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = values[index])) {
            if (key == keys[index]) {
                values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V computeIfAbsent(int keyPartA, int keyPartB, EntryFunction<? extends V> mappingFunction) {
        Object mappedValue;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Objects.requireNonNull(mappingFunction);
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V value = this.unmapNullValue(mappedValue);
        if (null == value && (value = mappingFunction.apply(keyPartA, keyPartB)) != null) {
            values[index] = value;
            if (null == mappedValue) {
                keys[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        }
        return value;
    }

    public V computeIfPresent(int keyPartA, int keyPartB, EntryRemap<? super V, ? extends V> remappingFunction) {
        Object mappedValue;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Objects.requireNonNull(remappingFunction);
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V value = this.unmapNullValue(mappedValue);
        if (null != value) {
            value = remappingFunction.apply(keyPartA, keyPartB, value);
            values[index] = value;
            if (null == value) {
                --this.size;
                this.compactChain(index);
            }
        }
        return value;
    }

    public V compute(int keyPartA, int keyPartB, EntryRemap<? super V, ? extends V> remappingFunction) {
        Object mappedvalue;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Objects.requireNonNull(remappingFunction);
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedvalue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V newValue = remappingFunction.apply(keyPartA, keyPartB, this.unmapNullValue(mappedvalue));
        if (null != newValue) {
            values[index] = newValue;
            if (null == mappedvalue) {
                keys[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != mappedvalue) {
            values[index] = null;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    public V merge(int keyPartA, int keyPartB, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Object mappedvalue;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedvalue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V oldValue = this.unmapNullValue(mappedvalue);
        V v = newValue = null == oldValue ? value : remappingFunction.apply(oldValue, value);
        if (null != newValue) {
            values[index] = newValue;
            if (null == mappedvalue) {
                keys[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != mappedvalue) {
            values[index] = null;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    public void forEach(Consumer<V> consumer) {
        int remaining = this.size;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; remaining > 0 && i < length; ++i) {
            Object value = values[i];
            if (null == value) continue;
            consumer.accept(value);
            --remaining;
        }
    }

    public void forEach(EntryConsumer<V> consumer) {
        int remaining = this.size;
        long[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; remaining > 0 && i < length; ++i) {
            Object value = values[i];
            if (null == value) continue;
            long compoundKey = keys[i];
            int keyPartA = (int)(compoundKey >>> 32);
            int keyPartB = (int)(compoundKey & 0xFFFFFFFFL);
            consumer.accept(keyPartA, keyPartB, this.unmapNullValue(value));
            --remaining;
        }
    }

    public V replace(int keyPartA, int keyPartB, V value) {
        Object oldValue;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (oldValue = values[index])) {
            if (key == keys[index]) {
                values[index] = val;
                break;
            }
            ++index;
            index &= mask;
        }
        return this.unmapNullValue(oldValue);
    }

    public boolean replace(int keyPartA, int keyPartB, V oldValue, V newValue) {
        Object mappedValue;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Object val = this.mapNullValue(newValue);
        Objects.requireNonNull(val, "value cannot be null");
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index])) {
            if (key == keys[index]) {
                if (!Objects.equals(this.unmapNullValue(mappedValue), oldValue)) break;
                values[index] = val;
                return true;
            }
            ++index;
            index &= mask;
        }
        return false;
    }

    public V putIfAbsent(int keyPartA, int keyPartB, V value) {
        Object mappedValue;
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V oldValue = this.unmapNullValue(mappedValue);
        if (null == oldValue) {
            if (null == mappedValue) {
                ++this.size;
                keys[index] = key;
            }
            values[index] = val;
            if (this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return oldValue;
    }

    public boolean remove(int keyPartA, int keyPartB, V value) {
        long key = Hashing.compoundKey(keyPartA, keyPartB);
        Object val = this.mapNullValue(value);
        if (null != val) {
            Object mappedValue;
            long[] keys = this.keys;
            Object[] values = this.values;
            int mask = values.length - 1;
            int index = Hashing.hash(key, mask);
            while (null != (mappedValue = values[index])) {
                if (key == keys[index]) {
                    if (!Objects.equals(this.unmapNullValue(mappedValue), value)) break;
                    values[index] = null;
                    --this.size;
                    this.compactChain(index);
                    return true;
                }
                ++index;
                index &= mask;
            }
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        long[] keys = this.keys;
        Object[] values = this.values;
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            Object value = values[i];
            if (null == value) continue;
            long compoundKey = keys[i];
            int keyPartA = (int)(compoundKey >>> 32);
            int keyPartB = (int)(compoundKey & 0xFFFFFFFFL);
            sb.append(keyPartA).append('_').append(keyPartB).append('=').append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        long[] tempKeys = new long[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        long[] keys = this.keys;
        Object[] values = this.values;
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            Object value = values[i];
            if (null == value) continue;
            long key = keys[i];
            int newHash = Hashing.hash(key, mask);
            while (null != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        long[] keys = this.keys;
        Object[] values = this.values;
        while (true) {
            ++index;
            Object value = values[index &= mask];
            if (null == value) break;
            long key = keys[index];
            int hash = Hashing.hash(key, mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            keys[deleteIndex] = key;
            values[deleteIndex] = value;
            values[index] = null;
            deleteIndex = index;
        }
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    public static interface EntryFunction<V> {
        public V apply(int var1, int var2);
    }

    public static interface EntryRemap<V, V1> {
        public V1 apply(int var1, int var2, V var3);
    }

    public static interface EntryConsumer<V> {
        public void accept(int var1, int var2, V var3);
    }
}

