/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.agrona.collections;

import fr.iamacat.optimizationsandtweaks.utils.agrona.BitUtil;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.CollectionUtil;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.Hashing;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.IntObjConsumer;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.IntObjPredicate;
import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.IntObjectToObjectFunction;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;

public class Int2ObjectHashMap<V>
implements Map<Integer, V> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private int[] keys;
    private Object[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Int2ObjectHashMap() {
        this(8, 0.65f, true);
    }

    public Int2ObjectHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, true);
    }

    public Int2ObjectHashMap(int initialCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.keys = new int[capacity];
        this.values = new Object[capacity];
    }

    public Int2ObjectHashMap(Int2ObjectHashMap<V> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.shouldAvoidAllocation = mapToCopy.shouldAvoidAllocation;
        this.keys = (int[])mapToCopy.keys.clone();
        this.values = (Object[])mapToCopy.values.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super V> action) {
        this.forEachInt(action::accept);
    }

    @Deprecated
    public void intForEach(IntObjConsumer<V> consumer) {
        this.forEachInt(consumer);
    }

    public void forEachInt(IntObjConsumer<V> consumer) {
        Objects.requireNonNull(consumer);
        int[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            Object value = values[index];
            if (null == value) continue;
            consumer.accept(keys[index], this.unmapNullValue(value));
            --remaining;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    public boolean containsKey(int key) {
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (null != values[index]) {
            if (key == keys[index]) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        Object val = this.mapNullValue(value);
        if (null != val) {
            Object[] values = this.values;
            int length = values.length;
            int remaining = this.size;
            for (int i = 0; remaining > 0 && i < length; ++i) {
                Object existingValue = values[i];
                if (null == existingValue) continue;
                if (Objects.equals(existingValue, val)) {
                    found = true;
                    break;
                }
                --remaining;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Integer)key);
    }

    public V get(int key) {
        return this.unmapNullValue(this.getMapped(key));
    }

    public V getOrDefault(int key, V defaultValue) {
        V value = this.getMapped(key);
        return null != value ? this.unmapNullValue(value) : defaultValue;
    }

    protected V getMapped(int key) {
        Object value;
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    @Override
    public V computeIfAbsent(Integer key, Function<? super Integer, ? extends V> mappingFunction) {
        return (V)this.computeIfAbsent((int)key, mappingFunction::apply);
    }

    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        Object mappedValue;
        Objects.requireNonNull(mappingFunction);
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V value = this.unmapNullValue(mappedValue);
        if (null == value && (value = mappingFunction.apply(key)) != null) {
            values[index] = value;
            if (null == mappedValue) {
                keys[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        }
        return value;
    }

    @Override
    public V computeIfPresent(Integer key, BiFunction<? super Integer, ? super V, ? extends V> remappingFunction) {
        return (V)this.computeIfPresent((int)key, remappingFunction::apply);
    }

    public V computeIfPresent(int key, IntObjectToObjectFunction<? super V, ? extends V> remappingFunction) {
        Object mappedValue;
        Objects.requireNonNull(remappingFunction);
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V value = this.unmapNullValue(mappedValue);
        if (null != value) {
            value = remappingFunction.apply(key, value);
            values[index] = value;
            if (null == value) {
                --this.size;
                this.compactChain(index);
            }
        }
        return value;
    }

    @Override
    public V compute(Integer key, BiFunction<? super Integer, ? super V, ? extends V> remappingFunction) {
        return (V)this.compute((int)key, remappingFunction::apply);
    }

    public V compute(int key, IntObjectToObjectFunction<? super V, ? extends V> remappingFunction) {
        Object mappedvalue;
        Objects.requireNonNull(remappingFunction);
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedvalue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V newValue = remappingFunction.apply(key, this.unmapNullValue(mappedvalue));
        if (null != newValue) {
            values[index] = newValue;
            if (null == mappedvalue) {
                keys[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != mappedvalue) {
            values[index] = null;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    @Override
    public V merge(Integer key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.merge((int)key, value, remappingFunction);
    }

    @Override
    public V merge(int key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Object mappedvalue;
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedvalue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V oldValue = this.unmapNullValue(mappedvalue);
        V v = newValue = null == oldValue ? value : remappingFunction.apply(oldValue, value);
        if (null != newValue) {
            values[index] = newValue;
            if (null == mappedvalue) {
                keys[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != mappedvalue) {
            values[index] = null;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public V put(int key, V value) {
        Object oldValue;
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (oldValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            keys[index] = key;
        }
        values[index] = val;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return this.unmapNullValue(oldValue);
    }

    @Override
    public V remove(Object key) {
        return this.remove((Integer)key);
    }

    public V remove(int key) {
        Object value;
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = values[index])) {
            if (key == keys[index]) {
                values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return this.unmapNullValue(value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, value);
    }

    public boolean remove(int key, V value) {
        Object val = this.mapNullValue(value);
        if (null != val) {
            Object mappedValue;
            int[] keys = this.keys;
            Object[] values = this.values;
            int mask = values.length - 1;
            int index = Hashing.hash(key, mask);
            while (null != (mappedValue = values[index])) {
                if (key == keys[index]) {
                    if (!Objects.equals(this.unmapNullValue(mappedValue), value)) break;
                    values[index] = null;
                    --this.size;
                    this.compactChain(index);
                    return true;
                }
                ++index;
                index &= mask;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, null);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        for (Map.Entry<Integer, V> entry2 : map.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    public void putAll(Int2ObjectHashMap<? extends V> map) {
        EntryIterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.findNext();
            this.put(iterator.getIntKey(), (V)iterator.getValue());
        }
    }

    @Override
    public V putIfAbsent(int key, V value) {
        Object mappedValue;
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index]) && key != keys[index]) {
            ++index;
            index &= mask;
        }
        V oldValue = this.unmapNullValue(mappedValue);
        if (null == oldValue) {
            if (null == mappedValue) {
                ++this.size;
                keys[index] = key;
            }
            values[index] = val;
            if (this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return oldValue;
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getIntKey()).append('=').append(this.unmapNullValue(entryIterator.getValue()));
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = values[i];
            if (null == thisValue || thisValue.equals(this.mapNullValue(thatValue = that.get(keys[i])))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object value = values[i];
            if (null == value) continue;
            result += Integer.hashCode(keys[i]) ^ value.hashCode();
        }
        return result;
    }

    protected Object mapNullValue(Object value) {
        return value;
    }

    protected V unmapNullValue(Object value) {
        return (V)value;
    }

    @Override
    public V replace(int key, V value) {
        Object oldValue;
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (oldValue = values[index])) {
            if (key == keys[index]) {
                values[index] = val;
                break;
            }
            ++index;
            index &= mask;
        }
        return this.unmapNullValue(oldValue);
    }

    @Override
    public boolean replace(int key, V oldValue, V newValue) {
        Object mappedValue;
        Object val = this.mapNullValue(newValue);
        Objects.requireNonNull(val, "value cannot be null");
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (mappedValue = values[index])) {
            if (key == keys[index]) {
                if (!Objects.equals(this.unmapNullValue(mappedValue), oldValue)) break;
                values[index] = val;
                return true;
            }
            ++index;
            index &= mask;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super V, ? extends V> function) {
        this.replaceAllInt(function::apply);
    }

    public void replaceAllInt(IntObjectToObjectFunction<? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        int[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            Object oldValue = values[index];
            if (null == oldValue) continue;
            Object newVal = this.mapNullValue(function.apply(keys[index], this.unmapNullValue(oldValue)));
            Objects.requireNonNull(newVal, "value cannot be null");
            values[index] = newVal;
            --remaining;
        }
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] tempKeys = new int[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        int[] keys = this.keys;
        Object[] values = this.values;
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            Object value = values[i];
            if (null == value) continue;
            int key = keys[i];
            int index = Hashing.hash(key, mask);
            while (null != tempValues[index]) {
                ++index;
                index &= mask;
            }
            tempKeys[index] = key;
            tempValues[index] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            Object value = values[index &= mask];
            if (null == value) break;
            int key = keys[index];
            int hash = Hashing.hash(key, mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            keys[deleteIndex] = key;
            values[deleteIndex] = value;
            values[index] = null;
            deleteIndex = index;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry2 = (Map.Entry)o;
            int key = (Integer)entry2.getKey();
            Object value = Int2ObjectHashMap.this.getMapped(key);
            return null != value && value.equals(Int2ObjectHashMap.this.mapNullValue(entry2.getValue()));
        }

        public boolean removeIfInt(IntObjPredicate<V> filter) {
            boolean removed = false;
            EntryIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.findNext();
                if (!filter.test(iterator.getIntKey(), iterator.getValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Int2ObjectHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Int2ObjectHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<Integer, V>>
    implements Map.Entry<Integer, V> {
        @Override
        public Map.Entry<Integer, V> next() {
            this.findNext();
            if (Int2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, V> allocateDuplicateEntry() {
            return new MapEntry(this.getIntKey(), this.getValue());
        }

        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2ObjectHashMap.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Int2ObjectHashMap.this.unmapNullValue(Int2ObjectHashMap.this.values[this.position()]);
        }

        @Override
        public V setValue(V value) {
            Object val = Int2ObjectHashMap.this.mapNullValue(value);
            Objects.requireNonNull(val, "value cannot be null");
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int pos = this.position();
            Object[] values = Int2ObjectHashMap.this.values;
            Object oldValue = values[pos];
            values[pos] = val;
            return oldValue;
        }

        public final class MapEntry
        implements Map.Entry<Integer, V> {
            private final int k;
            private final V v;

            public MapEntry(int k, V v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public Integer getKey() {
                return this.k;
            }

            @Override
            public V getValue() {
                return this.v;
            }

            @Override
            public V setValue(V value) {
                return Int2ObjectHashMap.this.put(this.k, value);
            }

            @Override
            public int hashCode() {
                return Integer.hashCode(EntryIterator.this.getIntKey()) ^ (null != this.v ? this.v.hashCode() : 0);
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() != null && e.getKey().equals(this.k) && (e.getValue() == null && this.v == null || e.getValue().equals(this.v));
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectHashMap.this.containsKey(o);
        }

        public boolean contains(int key) {
            return Int2ObjectHashMap.this.containsKey(key);
        }

        @Override
        public boolean remove(Object o) {
            return null != Int2ObjectHashMap.this.remove(o);
        }

        public boolean remove(int key) {
            return null != Int2ObjectHashMap.this.remove(key);
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }

        public boolean removeIfInt(IntPredicate filter) {
            boolean removed = false;
            KeyIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!filter.test(iterator.nextInt())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            int remaining = Int2ObjectHashMap.this.size;
            Object[] values = Int2ObjectHashMap.this.values;
            int length = values.length;
            for (int i = 0; remaining > 0 && i < length; ++i) {
                Object value = values[i];
                if (null == value) continue;
                action.accept(Int2ObjectHashMap.this.unmapNullValue(value));
                --remaining;
            }
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Int2ObjectHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Int2ObjectHashMap.this.unmapNullValue(Int2ObjectHashMap.this.values[this.position()]);
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Int2ObjectHashMap.this.values.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] values = Int2ObjectHashMap.this.values;
            int mask = values.length - 1;
            int stop = this.stopCounter;
            for (int i = this.posCounter - 1; i >= stop; --i) {
                int index = i & mask;
                if (null == values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Int2ObjectHashMap)Int2ObjectHashMap.this).values[position] = null;
            --Int2ObjectHashMap.this.size;
            Int2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Int2ObjectHashMap.this.size;
            Object[] values = Int2ObjectHashMap.this.values;
            int i = capacity = values.length;
            if (null != values[capacity - 1]) {
                for (i = 0; i < capacity && null != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }
}

