/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.agrona.generation;

import fr.iamacat.optimizationsandtweaks.utils.agrona.LangUtil;
import fr.iamacat.optimizationsandtweaks.utils.agrona.SystemUtil;
import fr.iamacat.optimizationsandtweaks.utils.agrona.generation.CharSequenceJavaFileObject;
import fr.iamacat.optimizationsandtweaks.utils.agrona.generation.ClassFileManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class CompilerUtil {
    private static final String TEMP_DIR_NAME = SystemUtil.tmpDirName();

    private CompilerUtil() {
    }

    public static Class<?> compileInMemory(String className, Map<String, CharSequence> sources) throws ClassNotFoundException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (null == compiler) {
            throw new IllegalStateException("JDK required to run tests. JRE is not sufficient.");
        }
        ClassFileManager<StandardJavaFileManager> fileManager = new ClassFileManager<StandardJavaFileManager>(compiler.getStandardFileManager(null, null, null));
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, CompilerUtil.wrap(sources));
        return CompilerUtil.compileAndLoad(className, diagnostics, fileManager, task);
    }

    public static Class<?> compileOnDisk(String className, Map<String, CharSequence> sources) throws ClassNotFoundException, IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (null == compiler) {
            throw new IllegalStateException("JDK required to run tests. JRE is not sufficient.");
        }
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);){
            ArrayList<String> options = new ArrayList<String>(Arrays.asList("-classpath", System.getProperty("java.class.path") + File.pathSeparator + TEMP_DIR_NAME));
            Collection<File> files = CompilerUtil.persist(sources);
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
            Class<?> clazz = CompilerUtil.compileAndLoad(className, diagnostics, fileManager, task);
            return clazz;
        }
    }

    public static Class<?> compileAndLoad(String className, DiagnosticCollector<JavaFileObject> diagnostics, JavaFileManager fileManager, JavaCompiler.CompilationTask task) throws ClassNotFoundException {
        if (!CompilerUtil.compile(diagnostics, task)) {
            return null;
        }
        return fileManager.getClassLoader(null).loadClass(className);
    }

    public static boolean compile(DiagnosticCollector<JavaFileObject> diagnostics, JavaCompiler.CompilationTask task) {
        Boolean succeeded = task.call();
        if (!succeeded.booleanValue()) {
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
                System.err.println(diagnostic.getCode());
                System.err.println((Object)diagnostic.getKind());
                JavaFileObject source = diagnostic.getSource();
                System.err.printf("Line = %d, Col = %d, File = %s", diagnostic.getLineNumber(), diagnostic.getColumnNumber(), source);
                System.err.println("Start: " + diagnostic.getStartPosition());
                System.err.println("End: " + diagnostic.getEndPosition());
                System.err.println("Pos: " + diagnostic.getPosition());
                try {
                    String content = source.getCharContent(true).toString();
                    int begin = content.lastIndexOf(10, (int)diagnostic.getStartPosition());
                    int end = content.indexOf(10, (int)diagnostic.getEndPosition());
                    System.err.println(diagnostic.getMessage(null));
                    System.err.println(content.substring(Math.max(0, begin), end));
                }
                catch (IOException ex) {
                    LangUtil.rethrowUnchecked(ex);
                }
            }
        }
        return succeeded;
    }

    public static Collection<File> persist(Map<String, CharSequence> sources) throws IOException {
        ArrayList<File> files = new ArrayList<File>(sources.size());
        for (Map.Entry<String, CharSequence> entry2 : sources.entrySet()) {
            String fqClassName;
            String className = fqClassName = entry2.getKey();
            Path path = Paths.get(TEMP_DIR_NAME, new String[0]);
            int indexOfLastDot = fqClassName.lastIndexOf(46);
            if (indexOfLastDot != -1) {
                className = fqClassName.substring(indexOfLastDot + 1);
                path = Paths.get(TEMP_DIR_NAME + fqClassName.substring(0, indexOfLastDot).replace('.', File.separatorChar), new String[0]);
                Files.createDirectories(path, new FileAttribute[0]);
            }
            File file = new File(path.toString(), className + ".java");
            files.add(file);
            try (FileWriter out = new FileWriter(file);){
                out.append(entry2.getValue());
                out.flush();
            }
        }
        return files;
    }

    private static Collection<CharSequenceJavaFileObject> wrap(Map<String, CharSequence> sources) {
        return sources.entrySet().stream().map(e -> new CharSequenceJavaFileObject((String)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.toList());
    }
}

