/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.genetics;

import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.MathIllegalArgumentException;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.util.LocalizedFormats;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.genetics.Chromosome;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.genetics.GeneticAlgorithm;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.genetics.MutationPolicy;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.genetics.RandomKey;
import java.util.ArrayList;
import java.util.List;

public class RandomKeyMutation
implements MutationPolicy {
    @Override
    public Chromosome mutate(Chromosome original) throws MathIllegalArgumentException {
        if (!(original instanceof RandomKey)) {
            throw new MathIllegalArgumentException(LocalizedFormats.RANDOMKEY_MUTATION_WRONG_CLASS, original.getClass().getSimpleName());
        }
        RandomKey originalRk = (RandomKey)original;
        List repr = originalRk.getRepresentation();
        int rInd = GeneticAlgorithm.getRandomGenerator().nextInt(repr.size());
        ArrayList newRepr = new ArrayList(repr);
        newRepr.set(rInd, GeneticAlgorithm.getRandomGenerator().nextDouble());
        return originalRk.newFixedLengthChromosome(newRepr);
    }
}

