/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.clustering.evaluation;

import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.clustering.Cluster;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.clustering.Clusterable;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.clustering.evaluation.ClusterEvaluator;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.ml.distance.DistanceMeasure;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.stat.descriptive.moment.Variance;
import java.util.List;

public class SumOfClusterVariances<T extends Clusterable>
extends ClusterEvaluator<T> {
    public SumOfClusterVariances(DistanceMeasure measure) {
        super(measure);
    }

    @Override
    public double score(List<? extends Cluster<T>> clusters) {
        double varianceSum = 0.0;
        for (Cluster<T> cluster : clusters) {
            if (cluster.getPoints().isEmpty()) continue;
            Clusterable center = this.centroidOf(cluster);
            Variance stat = new Variance();
            for (Clusterable point : cluster.getPoints()) {
                stat.increment(this.distance(point, center));
            }
            varianceSum += stat.getResult();
        }
        return varianceSum;
    }
}

