/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.nonlinear.scalar;

import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.analysis.MultivariateFunction;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.exception.TooManyEvaluationsException;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.BaseMultivariateOptimizer;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.ConvergenceChecker;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.OptimizationData;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.PointValuePair;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import fr.iamacat.optimizationsandtweaks.utils.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;

public abstract class MultivariateOptimizer
extends BaseMultivariateOptimizer<PointValuePair> {
    private MultivariateFunction function;
    private GoalType goal;

    protected MultivariateOptimizer(ConvergenceChecker<PointValuePair> checker) {
        super(checker);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        return (PointValuePair)super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof GoalType) {
                this.goal = (GoalType)data;
                continue;
            }
            if (!(data instanceof ObjectiveFunction)) continue;
            this.function = ((ObjectiveFunction)data).getObjectiveFunction();
        }
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    public double computeObjectiveValue(double[] params) {
        super.incrementEvaluationCount();
        return this.function.value(params);
    }
}

