/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.collections.maps;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class ArrayListThreadSafe<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    private AtomicReferenceArray<Object> elementData;
    private final AtomicInteger size = new AtomicInteger(0);

    public ArrayListThreadSafe(int initialCapacity) {
        if (initialCapacity > 0) {
            this.elementData = new AtomicReferenceArray(initialCapacity);
        } else {
            if (initialCapacity != 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.elementData = new AtomicReferenceArray<Object>(EMPTY_ELEMENTDATA);
        }
    }

    public ArrayListThreadSafe() {
        this.elementData = new AtomicReferenceArray<Object>(DEFAULTCAPACITY_EMPTY_ELEMENTDATA);
    }

    public ArrayListThreadSafe(Collection<? extends E> c) {
        Object[] a = c.toArray();
        int size = a.length;
        this.size.set(size);
        this.modCount = 0;
        this.elementData = size != 0 ? new AtomicReferenceArray<Object>(c.toArray()) : new AtomicReferenceArray<Object>(EMPTY_ELEMENTDATA);
    }

    public void trimToSize() {
        int currentSize = this.size.get();
        if (currentSize < this.elementData.length()) {
            AtomicReferenceArray<Object> newArray = new AtomicReferenceArray<Object>(currentSize);
            for (int i = 0; i < currentSize; ++i) {
                newArray.set(i, this.elementData.get(i));
            }
            this.elementData.lazySet(0, newArray.get(0));
        }
    }

    public void ensureCapacity(int minCapacity) {
        while (minCapacity > this.elementData.length() && (this.elementData.get(0) != DEFAULTCAPACITY_EMPTY_ELEMENTDATA || minCapacity > 10)) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length();
        int newCapacity = oldCapacity + Math.max(oldCapacity >> 1, 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        AtomicReferenceArray<Object> newArray = new AtomicReferenceArray<Object>(newCapacity);
        for (int i = 0; i < oldCapacity; ++i) {
            newArray.set(i, this.elementData.get(i));
        }
        this.elementData = newArray;
    }

    private Object[] grow() {
        int oldCapacity = this.elementData.length();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        Object[] newArray = new Object[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            newArray[i] = this.elementData.get(i);
        }
        this.elementData = new AtomicReferenceArray<Object>(newArray);
        return newArray;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOfRange(o, 0, this.size.get());
    }

    int indexOfRange(Object o, int start, int end) {
        AtomicReferenceArray<Object> es = this.elementData;
        if (o == null) {
            for (int i = start; i < end; ++i) {
                if (es.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!o.equals(es.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.lastIndexOfRange(o, 0, this.size.get());
    }

    int lastIndexOfRange(Object o, int start, int end) {
        AtomicReferenceArray<Object> es = this.elementData;
        if (o == null) {
            for (int i = end - 1; i >= start; --i) {
                if (es.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                if (!o.equals(es.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayListThreadSafe v = (ArrayListThreadSafe)super.clone();
            AtomicReferenceArray<Object> newElementData = new AtomicReferenceArray<Object>(this.size.get());
            for (int i = 0; i < this.size.get(); ++i) {
                newElementData.set(i, this.elementData.get(i));
            }
            v.elementData = newElementData;
            v.modCount = new AtomicInteger(0).intValue();
            return v;
        }
        catch (CloneNotSupportedException var2) {
            throw new InternalError(var2);
        }
    }

    @Override
    public Object[] toArray() {
        Object[] newArray = new Object[this.size.get()];
        for (int i = 0; i < this.size.get(); ++i) {
            newArray[i] = this.elementData.get(i);
        }
        return newArray;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size.get()) {
            return Arrays.copyOf(this.toArray(), this.size.get(), a.getClass());
        }
        System.arraycopy(this.toArray(), 0, a, 0, this.size.get());
        if (a.length > this.size.get()) {
            a[this.size.get()] = null;
        }
        return a;
    }

    E elementData(int index) {
        return (E)this.elementData.get(index);
    }

    static <E> E elementAt(Object[] es, int index) {
        return (E)es[index];
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.elementData(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size.get()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
        }
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index);
        Object oldValue = this.elementData.get(index);
        this.elementData.set(index, element);
        return (E)oldValue;
    }

    @Override
    public boolean add(E e) {
        int s = this.size.getAndIncrement();
        if (s >= this.elementData.length()) {
            this.grow(s + 1);
        }
        this.elementData.set(s, e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        int s = this.size.getAndIncrement();
        if (s >= this.elementData.length()) {
            this.grow(s + 1);
        }
        for (int i = s; i > index; --i) {
            this.elementData.set(i, this.elementData.get(i - 1));
        }
        this.elementData.set(index, element);
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        int s = this.size.getAndDecrement();
        Object oldValue = this.elementData.get(index);
        for (int i = index; i < s - 1; ++i) {
            this.elementData.set(i, this.elementData.get(i + 1));
        }
        this.elementData.set(s - 1, null);
        return (E)oldValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        int expectedModCount = this.modCount;
        boolean equal = o.getClass() == ArrayListThreadSafe.class ? this.equalsArrayList((ArrayListThreadSafe)o) : this.equalsRange((List)o, 0, this.size.get());
        this.checkForComodification(expectedModCount);
        return equal;
    }

    boolean equalsRange(List<?> other, int from, int to) {
        Object[] es = new Object[this.elementData.length()];
        for (int i = 0; i < this.elementData.length(); ++i) {
            es[i] = this.elementData.get(i);
        }
        if (to > es.length) {
            throw new ConcurrentModificationException();
        }
        Iterator<?> oit = other.iterator();
        while (from < to) {
            if (!oit.hasNext() || !Objects.equals(es[from], oit.next())) {
                return false;
            }
            ++from;
        }
        return !oit.hasNext();
    }

    private boolean equalsArrayList(ArrayListThreadSafe<?> other) {
        int otherModCount = other.modCount;
        int s = this.size.get();
        boolean equal = false;
        if (s == other.size.get()) {
            int i;
            equal = true;
            Object[] otherEs = new Object[other.elementData.length()];
            for (int i2 = 0; i2 < other.elementData.length(); ++i2) {
                otherEs[i2] = other.elementData.get(i2);
            }
            Object[] es = new Object[this.elementData.length()];
            for (i = 0; i < this.elementData.length(); ++i) {
                es[i] = this.elementData.get(i);
            }
            if (s > es.length || s > otherEs.length) {
                throw new ConcurrentModificationException();
            }
            for (i = 0; i < s; ++i) {
                if (Objects.equals(es[i], otherEs[i])) continue;
                equal = false;
                break;
            }
        }
        super.checkForComodification(otherModCount);
        return equal;
    }

    private void checkForComodification(int expectedModCount) {
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        int expectedModCount = this.modCount;
        int hash = this.hashCodeRange(0, this.size.get());
        this.checkForComodification(expectedModCount);
        return hash;
    }

    int hashCodeRange(int from, int to) {
        Object[] es = new Object[to - from];
        for (int i = from; i < to; ++i) {
            es[i - from] = this.elementData.get(i);
        }
        int hashCode = 1;
        for (Object e : es) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean remove(Object o) {
        int size = this.size.get();
        for (int i = 0; i < size; ++i) {
            Object e = this.elementData.get(i);
            if ((o != null || e != null) && (o == null || !o.equals(e))) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    private void fastRemove(int i) {
        int newSize = this.size.decrementAndGet();
        if (newSize > i) {
            for (int j = i; j < newSize; ++j) {
                this.elementData.set(j, this.elementData.get(j + 1));
            }
        }
        this.elementData.set(newSize, null);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size.get(); ++i) {
            this.elementData.set(i, null);
        }
        this.size.set(0);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        int currentSize = this.size.get();
        while (numNew > this.elementData.length() - currentSize) {
            this.grow(currentSize + numNew);
        }
        for (int i = 0; i < numNew; ++i) {
            this.elementData.set(currentSize + i, a[i]);
        }
        this.size.addAndGet(numNew);
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int numMoved;
        this.rangeCheckForAdd(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        int s = this.size.get();
        Object[] elementData = new Object[s + numNew];
        if (numNew > elementData.length - s) {
            this.grow(s + numNew);
            elementData = ArrayListThreadSafe.copyAtomicArrayToArray(this.elementData, new Object[0]);
        }
        if ((numMoved = s - index) > 0) {
            System.arraycopy(elementData, index, elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, elementData, index, numNew);
        this.size.addAndGet(numNew);
        ++this.modCount;
        return true;
    }

    private static Object[] copyAtomicArrayToArray(AtomicReferenceArray<Object> atomicArray, Object[] array) {
        for (int i = 0; i < atomicArray.length(); ++i) {
            array[i] = atomicArray.get(i);
        }
        return array;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(ArrayListThreadSafe.outOfBoundsMsg(fromIndex, toIndex));
        }
        int numToRemove = toIndex - fromIndex;
        if (numToRemove > 0) {
            int i;
            int s = this.size.get();
            int newSize = s - numToRemove;
            if (newSize < fromIndex) {
                for (i = fromIndex; i < s; ++i) {
                    this.elementData.set(i, this.elementData.get(i + numToRemove));
                }
            } else {
                for (i = 0; i < fromIndex; ++i) {
                    this.elementData.set(i + numToRemove, this.elementData.get(i));
                }
                for (i = toIndex; i < s; ++i) {
                    this.elementData.set(i - numToRemove, this.elementData.get(i));
                }
            }
            for (i = newSize; i < s; ++i) {
                this.elementData.set(i, null);
            }
            this.size.set(newSize);
            ++this.modCount;
        }
    }

    private void shiftTailOverGap(AtomicReferenceArray<Object> es, int lo, int hi) {
        int i;
        int newSize = this.size.get() - (hi - lo);
        for (i = hi; i < this.size.get(); ++i) {
            es.set(i - (hi - lo), es.get(i));
        }
        for (i = newSize; i < this.size.get(); ++i) {
            es.set(i, null);
        }
        this.size.set(newSize);
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size.get() || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private static String outOfBoundsMsg(int fromIndex, int toIndex) {
        return "From Index: " + fromIndex + " > To Index: " + toIndex;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchRemove(c, false, 0, this.size.get());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchRemove(c, true, 0, this.size.get());
    }

    boolean batchRemove(Collection<?> c, boolean complement, int from, int end) {
        Objects.requireNonNull(c);
        AtomicReferenceArray<Object> es = this.elementData;
        for (int r = from; r != end; ++r) {
            if (c.contains(es.get(r)) == complement) continue;
            int w = r++;
            try {
                while (r < end) {
                    Object e = es.get(r);
                    if (c.contains(e) == complement) {
                        es.set(w++, e);
                    }
                    ++r;
                }
            }
            catch (Throwable var12) {
                while (r < end) {
                    es.set(w++, es.get(r++));
                }
                throw var12;
            }
            finally {
                this.modCount += end - w;
                this.shiftTailOverGap(es, w, end);
            }
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.size.get());
        for (int i = 0; i < this.size.get(); ++i) {
            s.writeObject(this.elementData.get(i));
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        if (size > 0) {
            Object[] elements = new Object[size];
            for (int i = 0; i < size; ++i) {
                elements[i] = s.readObject();
            }
            this.elementData = new AtomicReferenceArray<Object>(elements);
        } else {
            if (size != 0) {
                throw new InvalidObjectException("Invalid size: " + size);
            }
            this.elementData = new AtomicReferenceArray(0);
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.rangeCheckForAdd(index);
        return new ListItr(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        AtomicReferenceArray<Object> es = this.elementData;
        int size = this.size.get();
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            action.accept(this.elementAt(es, i));
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private E elementAt(AtomicReferenceArray<Object> array, int index) {
        return (E)array.get(index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ArrayListSpliterator(0, -1, 0);
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.removeIf(filter, 0, this.size.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeIf(Predicate<? super E> filter, int i, int end) {
        int expectedModCount;
        Objects.requireNonNull(filter);
        ArrayListThreadSafe arrayListThreadSafe = this;
        synchronized (arrayListThreadSafe) {
            expectedModCount = this.modCount;
        }
        AtomicReferenceArray<Object> es = this.elementData;
        while (i < end && !filter.test(this.elementAt(es, i))) {
            ++i;
        }
        if (i < end) {
            int beg = i;
            long[] deathRow = ArrayListThreadSafe.nBits(end - i);
            deathRow[0] = 1L;
            ++i;
            while (i < end) {
                if (filter.test(this.elementAt(es, i))) {
                    ArrayListThreadSafe.setBit(deathRow, i - beg);
                }
                ++i;
            }
            ArrayListThreadSafe arrayListThreadSafe2 = this;
            synchronized (arrayListThreadSafe2) {
                if (this.modCount != expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                ++this.modCount;
            }
            int w = beg;
            for (i = beg; i < end; ++i) {
                if (!ArrayListThreadSafe.isClear(deathRow, i - beg)) continue;
                es.set(w++, es.get(i));
            }
            this.shiftTailOverGap(es, w, end);
            return true;
        }
        ArrayListThreadSafe arrayListThreadSafe3 = this;
        synchronized (arrayListThreadSafe3) {
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
        return false;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        this.replaceAllRange(operator, 0, this.size.get());
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAllRange(UnaryOperator<E> operator, int i, int end) {
        ArrayListThreadSafe arrayListThreadSafe;
        int expectedModCount;
        Objects.requireNonNull(operator);
        ArrayListThreadSafe arrayListThreadSafe2 = this;
        synchronized (arrayListThreadSafe2) {
            expectedModCount = this.modCount;
        }
        AtomicReferenceArray<Object> es = this.elementData;
        while (i < end) {
            arrayListThreadSafe = this;
            synchronized (arrayListThreadSafe) {
                if (this.modCount != expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
            es.set(i, operator.apply(this.elementAt(es, i)));
            ++i;
        }
        arrayListThreadSafe = this;
        synchronized (arrayListThreadSafe) {
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<? super E> c) {
        int i;
        Object[] array;
        int expectedModCount = this.modCount;
        ArrayListThreadSafe arrayListThreadSafe = this;
        synchronized (arrayListThreadSafe) {
            array = new Object[this.size()];
            for (i = 0; i < this.size(); ++i) {
                array[i] = this.elementData.get(i);
            }
        }
        Arrays.sort(array, c);
        arrayListThreadSafe = this;
        synchronized (arrayListThreadSafe) {
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
            for (i = 0; i < this.size(); ++i) {
                this.elementData.set(i, array[i]);
            }
            ++this.modCount;
        }
    }

    void checkInvariants() {
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            AtomicReferenceArray elementData = ArrayListThreadSafe.this.elementData;
            if (i >= elementData.length()) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData.get(this.lastRet);
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayListThreadSafe.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException var3) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayListThreadSafe.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayListThreadSafe.this.modCount;
            }
            catch (IndexOutOfBoundsException var3) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = ArrayListThreadSafe.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayListThreadSafe.this.size.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ArrayListThreadSafe arrayListThreadSafe = ArrayListThreadSafe.this;
            synchronized (arrayListThreadSafe) {
                this.checkForComodification();
                int i = this.cursor;
                if (i >= ArrayListThreadSafe.this.size.get()) {
                    throw new NoSuchElementException();
                }
                AtomicReferenceArray elementData = ArrayListThreadSafe.this.elementData;
                if (i >= elementData.length()) {
                    throw new ConcurrentModificationException();
                }
                this.cursor = i + 1;
                this.lastRet = i;
                return elementData.get(this.lastRet);
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayListThreadSafe.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayListThreadSafe.this.modCount;
            }
            catch (IndexOutOfBoundsException var2) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int currentSize = ArrayListThreadSafe.this.size.get();
            if (i < currentSize) {
                AtomicReferenceArray es = ArrayListThreadSafe.this.elementData;
                if (i >= es.length()) {
                    throw new ConcurrentModificationException();
                }
                for (i = this.cursor; i < currentSize && ArrayListThreadSafe.this.modCount == this.expectedModCount; ++i) {
                    action.accept(es.get(i));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (ArrayListThreadSafe.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class SubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final ArrayListThreadSafe<E> root;
        private final SubList<E> parent;
        private final int offset;
        private int size;

        public SubList(ArrayListThreadSafe<E> root, int fromIndex, int toIndex) {
            this.root = root;
            this.parent = null;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = ((ArrayListThreadSafe)root).modCount;
        }

        private SubList(SubList<E> parent, int fromIndex, int toIndex) {
            this.root = parent.root;
            this.parent = parent;
            this.offset = parent.offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = parent.modCount;
        }

        @Override
        public E set(int index, E element) {
            ArrayListThreadSafe arrayList = new ArrayListThreadSafe();
            arrayList.checkIndex(index);
            this.checkForComodification();
            Object oldValue = ((ArrayListThreadSafe)this.root).elementData.get(this.offset + index);
            ((ArrayListThreadSafe)this.root).elementData.set(this.offset + index, element);
            return oldValue;
        }

        @Override
        public E get(int index) {
            ArrayListThreadSafe arrayList = new ArrayListThreadSafe();
            arrayList.checkIndex(index);
            this.checkForComodification();
            return this.root.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.root.add(this.offset + index, element);
            this.updateSizeAndModCount(1);
        }

        @Override
        public E remove(int index) {
            ArrayListThreadSafe arrayList = new ArrayListThreadSafe();
            arrayList.checkIndex(index);
            this.checkForComodification();
            E result = this.root.remove(this.offset + index);
            this.updateSizeAndModCount(-1);
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.root.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.updateSizeAndModCount(fromIndex - toIndex);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.root.addAll(this.offset + index, c);
            this.updateSizeAndModCount(cSize);
            return true;
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            ((ArrayListThreadSafe)this.root).replaceAllRange(operator, this.offset, this.offset + this.size);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.batchRemove(c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.batchRemove(c, true);
        }

        private boolean batchRemove(Collection<?> c, boolean complement) {
            this.checkForComodification();
            int oldSize = this.size;
            boolean modified = this.root.batchRemove(c, complement, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.size - oldSize);
            }
            return modified;
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            this.checkForComodification();
            int oldSize = this.size;
            boolean modified = this.root.removeIf(filter, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.size - oldSize);
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            this.checkForComodification();
            AtomicReferenceArray atomicArray = ((ArrayListThreadSafe)this.root).elementData;
            Object[] array = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                array[i] = atomicArray.get(this.offset + i);
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.checkForComodification();
            int size = this.size;
            if (a.length < size) {
                Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                for (int i = 0; i < size; ++i) {
                    newArray[i] = ((ArrayListThreadSafe)this.root).elementData.get(this.offset + i);
                }
                return newArray;
            }
            System.arraycopy(((ArrayListThreadSafe)this.root).elementData, this.offset, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            boolean equal = this.root.equalsRange((List)o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return equal;
        }

        @Override
        public int hashCode() {
            int hash = this.root.hashCodeRange(this.offset, this.offset + this.size);
            this.checkForComodification();
            return hash;
        }

        @Override
        public int indexOf(Object o) {
            int index = this.root.indexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = this.root.lastIndexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    AtomicReferenceArray[] elementData = new AtomicReferenceArray[]{root.elementData};
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    AtomicReferenceArray[] elementData = new AtomicReferenceArray[]{root.elementData};
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    int i;
                    Objects.requireNonNull(action);
                    int size = size;
                    if (i < size) {
                        Object[] es = new AtomicReferenceArray[]{root.elementData};
                        if (offset + i >= es.length) {
                            throw new ConcurrentModificationException();
                        }
                        for (i = this.cursor; i < size && root.modCount == this.expectedModCount; ++i) {
                            action.accept(ArrayListThreadSafe.elementAt(es, offset + i));
                        }
                        this.cursor = i;
                        this.lastRet = i - 1;
                        this.checkForComodification();
                    }
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException var2) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        root.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException var3) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException var3) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (root.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            return new SubList<E>(this, fromIndex, toIndex);
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (((ArrayListThreadSafe)this.root).modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void updateSizeAndModCount(int sizeChange) {
            SubList<E> slist = this;
            do {
                slist.size += sizeChange;
                slist.modCount = ((ArrayListThreadSafe)this.root).modCount;
            } while ((slist = slist.parent) != null);
        }

        @Override
        public Spliterator<E> spliterator() {
            this.checkForComodification();
            return new Spliterator<E>(){
                private int index;
                private int fence;
                private int expectedModCount;
                {
                    this.index = offset;
                    this.fence = -1;
                }

                private int getFence() {
                    int hi = this.fence;
                    if (hi < 0) {
                        this.expectedModCount = modCount;
                        hi = this.fence = offset + size;
                    }
                    return hi;
                }

                public ArrayListSpliterator trySplit() {
                    ArrayListSpliterator var10000;
                    int lo = this.index;
                    int hi = this.getFence();
                    int mid = lo + hi >>> 1;
                    if (lo >= mid) {
                        var10000 = null;
                    } else {
                        ArrayListThreadSafe var10002 = root;
                        Objects.requireNonNull(var10002);
                        ArrayListThreadSafe arrayListThreadSafe = var10002;
                        Objects.requireNonNull(arrayListThreadSafe);
                        this.index = mid;
                        var10000 = arrayListThreadSafe.new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                    }
                    return var10000;
                }

                @Override
                public boolean tryAdvance(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    int hi = this.getFence();
                    int i = this.index;
                    if (i < hi) {
                        this.index = i + 1;
                        AtomicReferenceArray elementData = root.elementData;
                        Object e = elementData.get(i);
                        action.accept(e);
                        if (root.modCount != this.expectedModCount) {
                            throw new ConcurrentModificationException();
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    ArrayListThreadSafe lst = root;
                    AtomicReferenceArray[] a = new AtomicReferenceArray[]{lst.elementData};
                    if (a != null) {
                        int i;
                        int mc;
                        int hi = this.fence;
                        if (hi < 0) {
                            mc = modCount;
                            hi = offset + size;
                        } else {
                            mc = this.expectedModCount;
                        }
                        if (i >= 0 && (this.index = hi) <= a.length) {
                            for (i = this.index; i < hi; ++i) {
                                AtomicReferenceArray e = a[i];
                                action.accept(e);
                            }
                            if (lst.modCount == mc) {
                                return;
                            }
                        }
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public long estimateSize() {
                    return this.getFence() - this.index;
                }

                @Override
                public int characteristics() {
                    return 16464;
                }
            };
        }
    }

    final class ArrayListSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = ArrayListThreadSafe.this.modCount;
                hi = this.fence = ArrayListThreadSafe.this.size.get();
            }
            return hi;
        }

        public ArrayListSpliterator trySplit() {
            ArrayListSpliterator arrayListSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                arrayListSpliterator = null;
            } else {
                ArrayListThreadSafe arrayListThreadSafe = ArrayListThreadSafe.this;
                Objects.requireNonNull(arrayListThreadSafe);
                this.index = mid;
                ArrayListSpliterator arrayListSpliterator2 = arrayListThreadSafe.new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                AtomicReferenceArray[] elementData = new AtomicReferenceArray[]{ArrayListThreadSafe.this.elementData};
                AtomicReferenceArray e = elementData[i];
                action.accept(e);
                if (ArrayListThreadSafe.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            AtomicReferenceArray a = ArrayListThreadSafe.this.elementData;
            if (a != null && (hi = ArrayListThreadSafe.this.size.get()) >= 0) {
                int i;
                int mc = ArrayListThreadSafe.this.modCount;
                if (mc < 0) {
                    mc = ArrayListThreadSafe.this.modCount;
                }
                if ((i = this.index) >= 0 && (this.index = hi) <= a.length()) {
                    while (i < hi) {
                        Object e = a.get(i);
                        if (e != null) {
                            action.accept(e);
                        }
                        ++i;
                    }
                    if (ArrayListThreadSafe.this.modCount == mc) {
                        return;
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

