/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.collections.maps;

import java.util.Objects;

public class LongHashMap2 {
    private transient Entry[] hashArray = new Entry[16];
    private transient int numHashElements;
    private int capacity = 12;
    private final float percentUseable = 0.75f;
    private volatile transient int modCount;

    private static int getHashedKey(long p_76155_0_) {
        return (int)p_76155_0_ + (int)(p_76155_0_ >>> 32) * 92821;
    }

    private static int hash(int p_76157_0_) {
        p_76157_0_ ^= p_76157_0_ >>> 20 ^ p_76157_0_ >>> 12;
        return p_76157_0_ ^ p_76157_0_ >>> 7 ^ p_76157_0_ >>> 4;
    }

    private static int getHashIndex(int p_76158_0_, int p_76158_1_) {
        return p_76158_0_ & p_76158_1_ - 1;
    }

    public int getNumHashElements() {
        return this.numHashElements;
    }

    public Object getValueByKey(long p_76164_1_) {
        int j = LongHashMap2.getHashedKey(p_76164_1_);
        int index = LongHashMap2.getHashIndex(j, this.hashArray.length);
        Entry entry2 = this.hashArray[index];
        while (entry2 != null) {
            if (entry2.key == p_76164_1_) {
                return entry2.value;
            }
            entry2 = entry2.nextEntry;
        }
        return null;
    }

    public boolean containsItem(long p_76161_1_) {
        return this.getEntry(p_76161_1_) != null;
    }

    final Entry getEntry(long p_76160_1_) {
        int index = LongHashMap2.getHashIndex(LongHashMap2.getHashedKey(p_76160_1_), this.hashArray.length);
        Entry entry2 = this.hashArray[index];
        while (entry2 != null) {
            if (entry2.key == p_76160_1_) {
                return entry2;
            }
            entry2 = entry2.nextEntry;
        }
        return null;
    }

    public void add(long p_76163_1_, Object p_76163_3_) {
        int j = LongHashMap2.getHashedKey(p_76163_1_);
        int k = LongHashMap2.getHashIndex(j, this.hashArray.length);
        Entry entry2 = this.hashArray[k];
        while (entry2 != null) {
            if (entry2.key == p_76163_1_) {
                entry2.value = p_76163_3_;
                return;
            }
            entry2 = entry2.nextEntry;
        }
        ++this.modCount;
        this.createKey(j, p_76163_1_, p_76163_3_, k);
    }

    private void resizeTable(int p_76153_1_) {
        Entry[] aentry = this.hashArray;
        int j = aentry.length;
        if (j == 0x40000000) {
            this.capacity = Integer.MAX_VALUE;
        } else {
            Entry[] aentry1 = new Entry[p_76153_1_];
            this.copyHashTableTo(aentry1);
            this.hashArray = aentry1;
            this.capacity = (int)((float)p_76153_1_ * this.percentUseable);
        }
    }

    private void copyHashTableTo(Entry[] p_76154_1_) {
        Entry[] aentry = this.hashArray;
        int i = p_76154_1_.length;
        for (int j = 0; j < aentry.length; ++j) {
            Entry entry1;
            Entry entry2 = aentry[j];
            if (entry2 == null) continue;
            aentry[j] = null;
            do {
                entry1 = entry2.nextEntry;
                int k = LongHashMap2.getHashIndex(entry2.hash, i);
                entry2.nextEntry = p_76154_1_[k];
                p_76154_1_[k] = entry2;
                entry2 = entry1;
            } while (entry1 != null);
        }
    }

    public Object remove(long p_76159_1_) {
        Entry entry2 = this.removeKey(p_76159_1_);
        return entry2 == null ? null : entry2.value;
    }

    final Entry removeKey(long p_76152_1_) {
        Entry entry2;
        int j = LongHashMap2.getHashedKey(p_76152_1_);
        int k = LongHashMap2.getHashIndex(j, this.hashArray.length);
        Entry entry1 = entry2 = this.hashArray[k];
        while (entry1 != null) {
            Entry entry22 = entry1.nextEntry;
            if (entry1.key == p_76152_1_) {
                ++this.modCount;
                --this.numHashElements;
                if (entry2 == entry1) {
                    this.hashArray[k] = entry22;
                } else {
                    entry2.nextEntry = entry22;
                }
                return entry1;
            }
            entry2 = entry1;
            entry1 = entry22;
        }
        return entry1;
    }

    private void createKey(int p_76156_1_, long p_76156_2_, Object p_76156_4_, int p_76156_5_) {
        Entry entry2 = this.hashArray[p_76156_5_];
        this.hashArray[p_76156_5_] = new Entry(p_76156_1_, p_76156_2_, p_76156_4_, entry2);
        if (this.numHashElements++ >= this.capacity) {
            this.resizeTable(2 * this.hashArray.length);
        }
    }

    static class Entry {
        final long key;
        Object value;
        Entry nextEntry;
        final int hash;

        Entry(int p_i1553_1_, long p_i1553_2_, Object p_i1553_4_, Entry p_i1553_5_) {
            this.value = p_i1553_4_;
            this.nextEntry = p_i1553_5_;
            this.key = p_i1553_2_;
            this.hash = p_i1553_1_;
        }

        public final long getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean equals(Object p_equals_1_) {
            if (!(p_equals_1_ instanceof Entry)) {
                return false;
            }
            Entry entry2 = (Entry)p_equals_1_;
            return this.getKey() == entry2.getKey() && Objects.equals(this.getValue(), entry2.getValue());
        }

        public final int hashCode() {
            return LongHashMap2.getHashedKey(this.key);
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

