/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.mixins;

import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.collections.maps.ArrayListThreadSafe;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.network.play.server.S22PacketMultiBlockChange;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.event.world.ChunkWatchEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.internal.DummyInternalMethodHandler;

public class Classers {

    public static class PlayerInstance {
        public final List playersWatchingChunk = new ArrayListThreadSafe();
        public final ChunkCoordIntPair chunkLocation;
        private short[] locationOfBlockChange = new short[64];
        private int numberOfTilesToUpdate;
        private int flagsYAreasToUpdate;
        private long previousWorldTime;
        private final ConcurrentHashMap<EntityPlayerMP, Runnable> players = new ConcurrentHashMap();
        private boolean loaded = false;
        private Runnable loadedRunnable = () -> {
            this.loaded = true;
        };
        private WorldServer worldServer;
        private PlayerManager playerManager = new PlayerManager(this.worldServer);
        private static final Logger field_152627_a = LogManager.getLogger();

        public PlayerInstance(int p_i1518_2_, int p_i1518_3_, WorldServer worldServer) {
            this.worldServer = worldServer;
            this.chunkLocation = new ChunkCoordIntPair(p_i1518_2_, p_i1518_3_);
            worldServer.field_73059_b.loadChunk(p_i1518_2_, p_i1518_3_, this.loadedRunnable);
        }

        public void addPlayer(final EntityPlayerMP p_73255_1_) {
            if (this.playersWatchingChunk.contains(p_73255_1_)) {
                field_152627_a.debug("Failed to add player. {} already is in chunk {}, {}", new Object[]{p_73255_1_, this.chunkLocation.field_77276_a, this.chunkLocation.field_77275_b});
            } else {
                Runnable playerRunnable;
                if (this.playersWatchingChunk.isEmpty()) {
                    this.previousWorldTime = this.playerManager.func_72688_a().func_82737_E();
                }
                this.playersWatchingChunk.add(p_73255_1_);
                if (this.loaded) {
                    playerRunnable = null;
                    p_73255_1_.field_71129_f.add(this.chunkLocation);
                } else {
                    playerRunnable = new Runnable(){

                        @Override
                        public void run() {
                            p_73255_1_.field_71129_f.add(chunkLocation);
                        }
                    };
                    this.playerManager.func_72688_a().field_73059_b.loadChunk(this.chunkLocation.field_77276_a, this.chunkLocation.field_77275_b, playerRunnable);
                }
                this.players.put(p_73255_1_, playerRunnable);
            }
        }

        public void removePlayer(EntityPlayerMP p_73252_1_) {
            if (this.playersWatchingChunk.contains(p_73252_1_)) {
                if (!this.loaded) {
                    ChunkIOExecutor.dropQueuedChunkLoad((World)this.playerManager.func_72688_a(), (int)this.chunkLocation.field_77276_a, (int)this.chunkLocation.field_77275_b, (Runnable)this.players.get(p_73252_1_));
                    this.playersWatchingChunk.remove(p_73252_1_);
                    this.players.remove(p_73252_1_);
                    if (this.playersWatchingChunk.isEmpty()) {
                        ChunkIOExecutor.dropQueuedChunkLoad((World)this.playerManager.func_72688_a(), (int)this.chunkLocation.field_77276_a, (int)this.chunkLocation.field_77275_b, (Runnable)this.loadedRunnable);
                        long i = (long)this.chunkLocation.field_77276_a + Integer.MAX_VALUE | (long)this.chunkLocation.field_77275_b + Integer.MAX_VALUE << 32;
                        this.playerManager.field_72700_c.func_76159_d(i);
                        this.playerManager.field_111193_e.remove(this);
                    }
                    return;
                }
                Chunk chunk = this.playerManager.func_72688_a().func_72964_e(this.chunkLocation.field_77276_a, this.chunkLocation.field_77275_b);
                if (chunk.func_150802_k()) {
                    p_73252_1_.field_71135_a.func_147359_a((Packet)new S21PacketChunkData(chunk, true, 0));
                }
                this.players.remove(p_73252_1_);
                this.playersWatchingChunk.remove(p_73252_1_);
                p_73252_1_.field_71129_f.remove(this.chunkLocation);
                MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.UnWatch(this.chunkLocation, p_73252_1_));
                if (this.playersWatchingChunk.isEmpty()) {
                    long i = (long)this.chunkLocation.field_77276_a + Integer.MAX_VALUE | (long)this.chunkLocation.field_77275_b + Integer.MAX_VALUE << 32;
                    this.increaseInhabitedTime(chunk);
                    this.playerManager.field_72700_c.func_76159_d(i);
                    this.playerManager.field_111193_e.remove(this);
                    if (this.numberOfTilesToUpdate > 0) {
                        this.playerManager.field_72697_d.remove(this);
                    }
                    this.playerManager.func_72688_a().field_73059_b.func_73241_b(this.chunkLocation.field_77276_a, this.chunkLocation.field_77275_b);
                }
            }
        }

        public void processChunk() {
            this.increaseInhabitedTime(this.playerManager.func_72688_a().func_72964_e(this.chunkLocation.field_77276_a, this.chunkLocation.field_77275_b));
        }

        private void increaseInhabitedTime(Chunk p_111196_1_) {
            p_111196_1_.field_111204_q += this.playerManager.func_72688_a().func_82737_E() - this.previousWorldTime;
            this.previousWorldTime = this.playerManager.func_72688_a().func_82737_E();
        }

        public void flagChunkForUpdate(int p_151253_1_, int p_151253_2_, int p_151253_3_) {
            if (this.numberOfTilesToUpdate == 0) {
                this.playerManager.field_72697_d.add(this);
            }
            this.flagsYAreasToUpdate |= 1 << (p_151253_2_ >> 4);
            short short1 = (short)(p_151253_1_ << 12 | p_151253_3_ << 8 | p_151253_2_);
            for (int l = 0; l < this.numberOfTilesToUpdate; ++l) {
                if (this.locationOfBlockChange[l] != short1) continue;
                return;
            }
            if (this.numberOfTilesToUpdate == this.locationOfBlockChange.length) {
                this.locationOfBlockChange = Arrays.copyOf(this.locationOfBlockChange, this.locationOfBlockChange.length << 1);
            }
            this.locationOfBlockChange[this.numberOfTilesToUpdate++] = short1;
        }

        public void sendToAllPlayersWatchingChunk(Packet p_151251_1_) {
            for (int i = 0; i < this.playersWatchingChunk.size(); ++i) {
                EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playersWatchingChunk.get(i);
                if (entityplayermp.field_71129_f.contains(this.chunkLocation)) continue;
                entityplayermp.field_71135_a.func_147359_a(p_151251_1_);
            }
        }

        public void sendChunkUpdate() {
            if (this.numberOfTilesToUpdate != 0) {
                if (this.numberOfTilesToUpdate == 1) {
                    int i = this.chunkLocation.field_77276_a * 16 + (this.locationOfBlockChange[0] >> 12 & 0xF);
                    int j = this.locationOfBlockChange[0] & 0xFF;
                    int k = this.chunkLocation.field_77275_b * 16 + (this.locationOfBlockChange[0] >> 8 & 0xF);
                    this.sendToAllPlayersWatchingChunk((Packet)new S23PacketBlockChange(i, j, k, (World)this.playerManager.func_72688_a()));
                    if (this.playerManager.func_72688_a().func_147439_a(i, j, k).hasTileEntity(this.playerManager.func_72688_a().func_72805_g(i, j, k))) {
                        this.sendTileToAllPlayersWatchingChunk(this.playerManager.func_72688_a().func_147438_o(i, j, k));
                    }
                } else {
                    int k;
                    int j;
                    int i;
                    if (this.numberOfTilesToUpdate >= ForgeModContainer.clumpingThreshold) {
                        i = this.chunkLocation.field_77276_a * 16;
                        j = this.chunkLocation.field_77275_b * 16;
                        this.sendToAllPlayersWatchingChunk((Packet)new S21PacketChunkData(this.playerManager.func_72688_a().func_72964_e(this.chunkLocation.field_77276_a, this.chunkLocation.field_77275_b), false, this.flagsYAreasToUpdate));
                        k = 0;
                    } else {
                        this.sendToAllPlayersWatchingChunk((Packet)new S22PacketMultiBlockChange(this.numberOfTilesToUpdate, this.locationOfBlockChange, this.playerManager.func_72688_a().func_72964_e(this.chunkLocation.field_77276_a, this.chunkLocation.field_77275_b)));
                    }
                    WorldServer world = this.playerManager.func_72688_a();
                    for (i = 0; i < this.numberOfTilesToUpdate; ++i) {
                        j = this.chunkLocation.field_77276_a * 16 + (this.locationOfBlockChange[i] >> 12 & 0xF);
                        k = this.locationOfBlockChange[i] & 0xFF;
                        int l = this.chunkLocation.field_77275_b * 16 + (this.locationOfBlockChange[i] >> 8 & 0xF);
                        if (!world.func_147439_a(j, k, l).hasTileEntity(world.func_72805_g(j, k, l))) continue;
                        this.sendTileToAllPlayersWatchingChunk(this.playerManager.func_72688_a().func_147438_o(j, k, l));
                    }
                }
                this.numberOfTilesToUpdate = 0;
                this.flagsYAreasToUpdate = 0;
            }
        }

        private void sendTileToAllPlayersWatchingChunk(TileEntity p_151252_1_) {
            Packet packet;
            if (p_151252_1_ != null && (packet = p_151252_1_.func_145844_m()) != null) {
                this.sendToAllPlayersWatchingChunk(packet);
            }
        }
    }

    public static class EntryIntHashMap {
        public final int hashEntry;
        public Object valueEntry;
        public EntryIntHashMap nextEntry;
        public final int slotHash;

        public EntryIntHashMap(int p_i1552_1_, int p_i1552_2_, Object p_i1552_3_, EntryIntHashMap p_i1552_4_) {
            this.valueEntry = p_i1552_3_;
            this.nextEntry = p_i1552_4_;
            this.hashEntry = p_i1552_2_;
            this.slotHash = p_i1552_1_;
        }

        public final int getHash() {
            return this.hashEntry;
        }

        public final Object getValue() {
            return this.valueEntry;
        }

        public final boolean equals(Object p_equals_1_) {
            if (p_equals_1_ instanceof EntryIntHashMap) {
                Integer integer1;
                EntryIntHashMap entry2 = (EntryIntHashMap)p_equals_1_;
                Integer integer = this.getHash();
                if (Objects.equals(integer, integer1 = Integer.valueOf(entry2.getHash()))) {
                    Object object1 = this.getValue();
                    Object object2 = entry2.getValue();
                    return Objects.equals(object1, object2);
                }
            }
            return false;
        }

        public final int hashCode() {
            return EntryIntHashMap.computeHash(this.hashEntry);
        }

        public final String toString() {
            return this.getHash() + "=" + this.getValue();
        }

        public static int computeHash(int p_76044_0_) {
            p_76044_0_ ^= p_76044_0_ >>> 20 ^ p_76044_0_ >>> 12;
            return p_76044_0_ ^ p_76044_0_ >>> 7 ^ p_76044_0_ >>> 4;
        }
    }

    public static class Entry {
        public final long key;
        public Object value;
        public Entry nextEntry;
        public final int hash;

        public Entry(int p_i1553_1_, long p_i1553_2_, Object p_i1553_4_, Entry p_i1553_5_) {
            this.value = p_i1553_4_;
            this.nextEntry = p_i1553_5_;
            this.key = p_i1553_2_;
            this.hash = p_i1553_1_;
        }

        public final long getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean equals(Object p_equals_1_) {
            if (!(p_equals_1_ instanceof Entry)) {
                return false;
            }
            Entry entry2 = (Entry)p_equals_1_;
            return this.getKey() == entry2.getKey() && Objects.equals(this.getValue(), entry2.getValue());
        }

        public final int hashCode() {
            return Entry.getHashedKey(this.key);
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        public static int getHashedKey(long p_76155_0_) {
            return (int)p_76155_0_ + (int)(p_76155_0_ >>> 32) * 92821;
        }
    }

    public static class FlowCostContext {
        public final int x;
        public final int y;
        public final int z;
        public final int recurseDepth;
        public final int adjSide;

        public FlowCostContext(int x, int y, int z, int recurseDepth, int adjSide) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.recurseDepth = recurseDepth;
            this.adjSide = adjSide;
        }
    }

    public static class XZCoord {
        public int x;
        public int z;

        public XZCoord(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public XZCoord() {
            this(0, 0);
        }

        public XZCoord offset(int dir, int amount) {
            int xOff = 0;
            int zOff = 0;
            switch (dir) {
                case 2: {
                    zOff = -amount;
                    break;
                }
                default: {
                    zOff = amount;
                    break;
                }
                case 4: {
                    xOff = -amount;
                    break;
                }
                case 5: {
                    xOff = amount;
                }
            }
            return new XZCoord(this.x + xOff, this.z + zOff);
        }

        public XZCoord offset(int dir) {
            return this.offset(dir, 1);
        }
    }

    public static enum Quadrant {
        X_Z,
        X_NEGZ,
        NEGX_Z,
        NEGX_NEGZ;


        public Quadrant next() {
            switch (this) {
                case NEGX_Z: {
                    return X_Z;
                }
                case NEGX_NEGZ: {
                    return NEGX_Z;
                }
                case X_Z: {
                    return X_NEGZ;
                }
            }
            return NEGX_NEGZ;
        }

        public Quadrant previous() {
            switch (this) {
                case NEGX_Z: {
                    return NEGX_NEGZ;
                }
                case NEGX_NEGZ: {
                    return X_NEGZ;
                }
                case X_Z: {
                    return NEGX_Z;
                }
            }
            return X_Z;
        }
    }

    public static class Coord2D {
        public int x;
        public int y;

        public Coord2D(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class FakeMethodHandler
    extends DummyInternalMethodHandler {
        public boolean isResearchComplete(String username, String researchkey) {
            return true;
        }
    }

    public static class Pair {
        public int x;
        public int y;

        public Pair(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object p) {
            if (!(p instanceof Pair)) {
                return false;
            }
            return ((Pair)p).x == this.x && ((Pair)p).y == this.y;
        }
    }

    public static class ModIdComparator
    implements Comparator<ModContainer> {
        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            return o1.getModId().compareTo(o2.getModId());
        }
    }

    public static class ItemStackKey2 {
        public final ItemStack stack;

        public ItemStackKey2(ItemStack stack) {
            this.stack = stack;
        }

        public int hashCode() {
            if (this.stack == null) {
                return 1;
            }
            int hashCode = 1;
            hashCode = 31 * hashCode + this.stack.field_77994_a;
            hashCode = 31 * hashCode + Item.func_150891_b((Item)this.stack.func_77973_b());
            hashCode = 31 * hashCode + this.stack.func_77960_j();
            hashCode = 31 * hashCode + (!this.stack.func_77942_o() ? 0 : this.stack.func_77978_p().hashCode());
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemStackKey2)) {
                return false;
            }
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)((ItemStackKey2)o).stack);
        }
    }

    public static class Block {
        public static WorldChunkManager chunkManager;
        public float[] rainfallValues = new float[256];
        public BiomeGenBase[] biomes = new BiomeGenBase[256];
        public int xPosition;
        public int zPosition;
        public long lastAccessTime;

        public Block(int p_i1972_2_, int p_i1972_3_, WorldChunkManager chunkManager) {
            Block.chunkManager = chunkManager;
            this.xPosition = p_i1972_2_;
            this.zPosition = p_i1972_3_;
            chunkManager.func_76936_a(this.rainfallValues, p_i1972_2_ << 4, p_i1972_3_ << 4, 16, 16);
            chunkManager.func_76931_a(this.biomes, p_i1972_2_ << 4, p_i1972_3_ << 4, 16, 16, false);
        }

        public BiomeGenBase getBiomeGenAt(int p_76885_1_, int p_76885_2_) {
            return this.biomes[p_76885_1_ & 0xF | (p_76885_2_ & 0xF) << 4];
        }
    }
}

