/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.tidychunkbackport;

import com.falsepattern.lib.compat.ChunkPos;
import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.world.World;

public class TidyChunkBackportWorldContext {
    private final ConcurrentHashMap<ChunkPos, Long> chunks = new ConcurrentHashMap();
    private int removeCount = 0;

    public static boolean isTargetEntity(@Nonnull Entity e) {
        return e instanceof EntityItem;
    }

    public void add(ChunkPos pos, World world) {
        long currentTime = world.func_82737_E();
        this.chunks.put(pos, currentTime);
    }

    public void searchAndDestroy(@Nonnull World world) {
        if (!this.chunks.isEmpty()) {
            ArrayList<EntityItem> entitiesToRemove = new ArrayList<EntityItem>();
            for (Object entityObject : world.field_72996_f) {
                EntityItem itemEntity;
                if (!(entityObject instanceof EntityItem) || !TidyChunkBackportWorldContext.isTargetEntity((Entity)(itemEntity = (EntityItem)entityObject)) || !this.isContained((Entity)itemEntity)) continue;
                entitiesToRemove.add(itemEntity);
            }
            this.removeEntities(entitiesToRemove, world);
        }
    }

    private void removeEntities(List<EntityItem> entities, World world) {
        for (EntityItem entity : entities) {
            if (OptimizationsandTweaksConfig.enableTidyChunkBackportDebugger) {
                System.out.println("Entity meets criteria, removing... (" + entity + ")");
            }
            this.removeEntity((Entity)entity, world);
        }
        if (this.removeCount > 0) {
            this.removeCount = 0;
        }
    }

    public void removeOldContext(World world) {
        int span = OptimizationsandTweaksConfig.TidyChunkBackportPostTick;
        long currentTime = world.func_82737_E();
        for (Map.Entry<ChunkPos, Long> entry2 : this.chunks.entrySet()) {
            long time = entry2.getValue();
            if (currentTime - time <= (long)span) continue;
            this.chunks.remove(entry2.getKey());
        }
    }

    public void removeEntity(Entity entity, World world) {
        entity.func_70106_y();
        world.func_72900_e(entity);
        ++this.removeCount;
    }

    public boolean isContained(@Nonnull Entity entity) {
        if (entity instanceof EntityItem && entity.func_70089_S()) {
            EntityItem item = (EntityItem)entity;
            ChunkPos chunkPos = new ChunkPos(item.field_70176_ah, item.field_70164_aj);
            return this.chunks.containsKey(chunkPos);
        }
        return false;
    }
}

