/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.vanilla;

import fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.resources.GZIPOutputStream2;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class CompressTask {
    private final NBTTagCompound data;
    private static final Executor namedExecutor = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "CompressTaskThread");
        t.setDaemon(true);
        return t;
    });

    public CompressTask(NBTTagCompound data) {
        this.data = data;
    }

    public CompletableFuture<byte[]> compressAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CompressTask.compress(this.data);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }, namedExecutor);
    }

    public static byte[] compress(NBTTagCompound p_74798_0_) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream2(bytearrayoutputstream));){
            CompressedStreamTools.func_74800_a((NBTTagCompound)p_74798_0_, (DataOutput)dataoutputstream);
        }
        return bytearrayoutputstream.toByteArray();
    }
}

