/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.org.pcollections;

import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.AbstractUnmodifiableMap;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.IntTree;
import fr.iamacat.optimizationsandtweaks.utils.org.pcollections.PMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class IntTreePMap<V>
extends AbstractUnmodifiableMap<Integer, V>
implements PMap<Integer, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final IntTreePMap<Object> EMPTY = new IntTreePMap<Object>(IntTree.EMPTYNODE);
    private final IntTree<V> root;
    private transient Set<Map.Entry<Integer, V>> entrySet = null;

    public static <V> IntTreePMap<V> empty() {
        return EMPTY;
    }

    public static <V> IntTreePMap<V> singleton(Integer key, V value) {
        return IntTreePMap.empty().plus(key, value);
    }

    public static <V> IntTreePMap<V> from(Map<? extends Integer, ? extends V> map) {
        if (map instanceof IntTreePMap) {
            return (IntTreePMap)map;
        }
        return IntTreePMap.empty().plusAll((Map)map);
    }

    private IntTreePMap(IntTree<V> root) {
        this.root = Objects.requireNonNull(root, "root is null");
    }

    private IntTreePMap<V> withRoot(IntTree<V> root) {
        if (root == this.root) {
            return this;
        }
        return new IntTreePMap<V>(root);
    }

    public IntTreePMap<V> minusRange(int start, int end) {
        IntTree<V> root = this.root;
        for (int i = start; i < end; ++i) {
            root = root.minus(i);
        }
        return this.withRoot(root);
    }

    IntTreePMap<V> withKeysChangedAbove(int key, int delta) {
        return this.withRoot(this.root.changeKeysAbove(key, delta));
    }

    IntTreePMap<V> withKeysChangedBelow(int key, int delta) {
        return this.withRoot(this.root.changeKeysBelow(key, delta));
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, V>>(){

                @Override
                public int size() {
                    return IntTreePMap.this.size();
                }

                @Override
                public Iterator<Map.Entry<Integer, V>> iterator() {
                    return IntTreePMap.this.root.iterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Object k = e.getKey();
                    if (!IntTreePMap.this.containsKey(k)) {
                        return false;
                    }
                    return Objects.equals(IntTreePMap.this.get(k), e.getValue());
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public boolean containsKey(Object key) {
        if (Objects.requireNonNull(key) instanceof Integer) {
            return this.root.containsKey(((Integer)key).intValue());
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof Integer)) {
            return null;
        }
        return this.root.get(((Integer)key).intValue());
    }

    public IntTreePMap<V> plus(Integer key, V value) {
        return this.withRoot(this.root.plus(key.intValue(), value));
    }

    public IntTreePMap<V> minus(Object key) {
        if (!(Objects.requireNonNull(key, "key is null") instanceof Integer)) {
            return this;
        }
        return this.withRoot(this.root.minus(((Integer)key).intValue()));
    }

    public IntTreePMap<V> plusAll(Map<? extends Integer, ? extends V> map) {
        IntTree<V> root = this.root;
        for (Map.Entry<Integer, V> entry2 : map.entrySet()) {
            root = root.plus(entry2.getKey().intValue(), entry2.getValue());
        }
        return this.withRoot(root);
    }

    public IntTreePMap<V> minusAll(Collection<?> keys) {
        IntTree<V> root = this.root;
        for (Object key : keys) {
            if (!(Objects.requireNonNull(key, "key is null") instanceof Integer)) continue;
            root = root.minus(((Integer)key).intValue());
        }
        return this.withRoot(root);
    }
}

