/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utilsformods.minefactoryreloaded;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Unique;
import powercrystals.minefactoryreloaded.setup.MFRThings;

public class WorldGenRubberTree2 {
    public void generateLeaves(World world, Random rand, int x, int y, int z, int treeHeight) {
        ArrayList<ChunkCoordinates> leavesToPlace = new ArrayList<ChunkCoordinates>();
        Chunk chunk = world.func_72938_d(x, z);
        for (int yOffset = y - 3 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
            int var12 = yOffset - (y + treeHeight);
            int center = 1 - var12 / 2;
            for (int xOffset = x - center; xOffset <= x + center; ++xOffset) {
                for (int zOffset = z - center; zOffset <= z + center; ++zOffset) {
                    int xPos = xOffset - x;
                    int zPos = zOffset - z;
                    if (xPos == center && zPos == center && (rand.nextInt(2) == 0 || var12 == 0) || !this.canPlaceLeaf(rand) || !chunk.field_76636_d) continue;
                    leavesToPlace.add(new ChunkCoordinates(xOffset, yOffset, zOffset));
                }
            }
        }
        this.placeLeaves(world, leavesToPlace);
    }

    private void placeLeaves(World world, List<ChunkCoordinates> leavesToPlace) {
        if (leavesToPlace.isEmpty()) {
            return;
        }
        ArrayList<ChunkCoordinates> validLeavesToPlace = new ArrayList<ChunkCoordinates>();
        for (ChunkCoordinates pos : leavesToPlace) {
            if (!world.func_72899_e(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c) || !world.func_147439_a(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c).isAir((IBlockAccess)world, pos.field_71574_a, pos.field_71572_b, pos.field_71573_c) || !world.func_72863_F().func_73149_a(pos.field_71574_a >> 4, pos.field_71573_c >> 4)) continue;
            validLeavesToPlace.add(pos);
        }
        if (!validLeavesToPlace.isEmpty()) {
            for (ChunkCoordinates pos : validLeavesToPlace) {
                world.func_147465_d(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c, MFRThings.rubberLeavesBlock, 0, 2);
            }
        }
    }

    private boolean canPlaceLeaf(Random rand) {
        return rand.nextFloat() < 0.9f;
    }

    @Unique
    public static int optimizationsAndTweaks$getSurfaceBlockY(World world, int x, int z) {
        int y = world.func_72800_K();
        while (--y >= 0) {
            Chunk chunk;
            Block block;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (world.func_72863_F().func_73149_a(chunkX, chunkZ) && ((block = (chunk = world.func_72964_e(chunkX, chunkZ)).func_150810_a(x & 0xF, y, z & 0xF)).isAir((IBlockAccess)world, x, y, z) || block.isReplaceable((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z) || block.isFoliage((IBlockAccess)world, x, y, z) || block.canBeReplacedByLeaves((IBlockAccess)world, x, y, z))) continue;
        }
        return y;
    }
}

